/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.internal.executor.ExecutorUtil;
import org.ehcache.management.CollectorService;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.notification.ContextualNotification;
import org.terracotta.management.model.stats.ContextualStatistics;
import org.terracotta.management.registry.StatisticQuery;

@ServiceDependencies(value={CacheManagerProviderService.class, ManagementRegistryService.class, ExecutionService.class, TimeSourceService.class})
public class DefaultCollectorService
implements CollectorService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCollectorService.class);
    private volatile ScheduledFuture<?> task;
    private final ConcurrentMap<String, StatisticQuery.Builder> selectedStatsPerCapability = new ConcurrentHashMap<String, StatisticQuery.Builder>();
    private final CollectorService.Collector collector;
    private volatile TimeSource timeSource;
    private volatile ManagementRegistryService managementRegistry;
    private volatile ScheduledExecutorService scheduledExecutorService;
    private volatile InternalCacheManager cacheManager;
    private volatile ManagementRegistryServiceConfiguration configuration;

    public DefaultCollectorService() {
        this(CollectorService.Collector.EMPTY);
    }

    public DefaultCollectorService(CollectorService.Collector collector) {
        this.collector = collector;
    }

    public synchronized void start(ServiceProvider<Service> serviceProvider) {
        this.timeSource = ((TimeSourceService)serviceProvider.getService(TimeSourceService.class)).getTimeSource();
        this.managementRegistry = (ManagementRegistryService)serviceProvider.getService(ManagementRegistryService.class);
        this.configuration = this.managementRegistry.getConfiguration();
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        this.scheduledExecutorService = ((ExecutionService)serviceProvider.getService(ExecutionService.class)).getScheduledExecutor(this.configuration.getCollectorExecutorAlias());
        this.cacheManager.registerListener((CacheManagerListener)this);
    }

    public synchronized void stop() {
        this.stopStatisticCollector();
        ExecutorUtil.shutdownNow((ExecutorService)this.scheduledExecutorService);
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        this.collector.onNotification(new ContextualNotification(this.configuration.getContext().with("cacheName", alias), EhcacheNotification.CACHE_ADDED.name()));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        this.collector.onNotification(new ContextualNotification(this.configuration.getContext().with("cacheName", alias), EhcacheNotification.CACHE_REMOVED.name()));
    }

    public void stateTransition(Status from, Status to) {
        switch (to) {
            case AVAILABLE: {
                this.managementRegistry.register(this);
                this.collector.onNotification(new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_AVAILABLE.name()));
                this.startStatisticCollector();
                break;
            }
            case MAINTENANCE: {
                this.collector.onNotification(new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_MAINTENANCE.name()));
                break;
            }
            case UNINITIALIZED: {
                this.collector.onNotification(new ContextualNotification(this.configuration.getContext(), EhcacheNotification.CACHE_MANAGER_CLOSED.name()));
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + to));
            }
        }
    }

    public synchronized void startStatisticCollector() {
        if (this.task == null) {
            StatisticsProviderConfiguration providerConfiguration = this.configuration.getConfigurationFor(EhcacheStatisticsProvider.class);
            long timeToDisableMs = TimeUnit.MILLISECONDS.convert(providerConfiguration.timeToDisable(), providerConfiguration.timeToDisableUnit());
            long pollingIntervalMs = Math.round((double)timeToDisableMs * 0.75);
            final AtomicLong lastPoll = new AtomicLong(this.timeSource.getTimeMillis());
            this.task = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DefaultCollectorService.this.task != null && !DefaultCollectorService.this.selectedStatsPerCapability.isEmpty()) {
                            ArrayList<Context> cacheContexts = new ArrayList<Context>();
                            for (String cacheAlias : new HashSet(DefaultCollectorService.this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().keySet())) {
                                cacheContexts.add(DefaultCollectorService.this.configuration.getContext().with("cacheName", cacheAlias));
                            }
                            ArrayList<ContextualStatistics> statistics = new ArrayList<ContextualStatistics>();
                            long since = lastPoll.get();
                            for (Map.Entry entry : DefaultCollectorService.this.selectedStatsPerCapability.entrySet()) {
                                for (ContextualStatistics contextualStatistics : ((StatisticQuery)((StatisticQuery.Builder)((StatisticQuery.Builder)entry.getValue()).since(since).on(cacheContexts)).build()).execute()) {
                                    statistics.add(contextualStatistics);
                                }
                            }
                            lastPoll.set(DefaultCollectorService.this.timeSource.getTimeMillis());
                            if (DefaultCollectorService.this.task != null && !statistics.isEmpty()) {
                                DefaultCollectorService.this.collector.onStatistics(statistics);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        LOGGER.error("StatisticCollector: " + e.getMessage(), (Throwable)e);
                    }
                }
            }, pollingIntervalMs, pollingIntervalMs, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopStatisticCollector() {
        if (this.task != null) {
            ScheduledFuture<?> _task = this.task;
            this.task = null;
            _task.cancel(false);
        }
    }

    public void updateCollectedStatistics(String capabilityName, Collection<String> statisticNames) {
        if (!statisticNames.isEmpty()) {
            StatisticQuery.Builder builder = this.managementRegistry.withCapability(capabilityName).queryStatistics(statisticNames);
            this.selectedStatsPerCapability.put(capabilityName, builder);
        } else {
            this.selectedStatsPerCapability.remove(capabilityName);
        }
    }

    Map<String, StatisticQuery.Builder> getSelectedStatsPerCapability() {
        return Collections.unmodifiableMap(this.selectedStatsPerCapability);
    }

    void setManagementRegistry(ManagementRegistryService managementRegistry) {
        this.managementRegistry = managementRegistry;
    }

    private static enum EhcacheNotification {
        CACHE_ADDED,
        CACHE_REMOVED,
        CACHE_MANAGER_AVAILABLE,
        CACHE_MANAGER_MAINTENANCE,
        CACHE_MANAGER_CLOSED;

    }
}

