/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.actions;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ehcache.management.annotations.Exposed;
import org.ehcache.management.annotations.Named;
import org.ehcache.management.providers.CacheBindingManagementProviderSkeleton;
import org.ehcache.management.providers.actions.EhcacheActionWrapper;
import org.ehcache.management.registry.CacheBinding;
import org.ehcache.management.utils.ClassLoadingHelper;
import org.terracotta.management.call.Parameter;
import org.terracotta.management.capabilities.ActionsCapability;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.capabilities.context.CapabilityContext;
import org.terracotta.management.capabilities.descriptors.CallDescriptor;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.context.Context;

@Named(value="ActionsCapability")
public class EhcacheActionProvider
extends CacheBindingManagementProviderSkeleton<EhcacheActionWrapper> {
    public EhcacheActionProvider(String cacheManagerAlias) {
        super(cacheManagerAlias);
    }

    @Override
    protected EhcacheActionWrapper createManagedObject(CacheBinding cacheBinding) {
        return new EhcacheActionWrapper(cacheBinding.getCache());
    }

    @Override
    protected Capability createCapability(String name, CapabilityContext context, Collection<Descriptor> descriptors) {
        return new ActionsCapability(name, descriptors, context);
    }

    public final Set<Descriptor> getDescriptors() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        Collection actions = this.managedObjects.values();
        for (Object action : actions) {
            Method[] methods;
            Class<?> actionClass = action.getClass();
            for (Method method : methods = actionClass.getMethods()) {
                Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
                boolean expose = false;
                for (Annotation declaredAnnotation : declaredAnnotations) {
                    if (declaredAnnotation.annotationType() != Exposed.class) continue;
                    expose = true;
                    break;
                }
                if (!expose) continue;
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                Class<?>[] parameterTypes = method.getParameterTypes();
                ArrayList<String> parameterNames = new ArrayList<String>();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[i];
                    boolean named = false;
                    for (Annotation parameterAnnotation : parameterAnnotations) {
                        if (!(parameterAnnotation instanceof Named)) continue;
                        Named namedAnnotation = (Named)parameterAnnotation;
                        parameterNames.add(namedAnnotation.value());
                        named = true;
                        break;
                    }
                    if (named) continue;
                    parameterNames.add("arg" + i);
                }
                ArrayList<CallDescriptor.Parameter> parameters = new ArrayList<CallDescriptor.Parameter>();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters.add(new CallDescriptor.Parameter((String)parameterNames.get(i), parameterTypes[i].getName()));
                }
                capabilities.add((Descriptor)new CallDescriptor(methodName, returnType.getName(), parameters));
            }
        }
        return capabilities;
    }

    @Override
    public <T> T callAction(Context context, String methodName, Class<T> returnType, Parameter ... parameters) {
        Map.Entry entry = this.findManagedObject(context);
        if (entry != null) {
            Object managedObject = entry.getValue();
            ClassLoader classLoader = entry.getKey().getCache().getRuntimeConfiguration().getClassLoader();
            Object[] argClassNames = new String[parameters.length];
            Object[] args = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                argClassNames[i] = parameters[i].getClassName();
                args[i] = parameters[i].getValue();
            }
            try {
                Method method = managedObject.getClass().getMethod(methodName, ClassLoadingHelper.toClasses(classLoader, (String[])argClassNames));
                return returnType.cast(method.invoke(managedObject, args));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No such method : " + methodName + " with arg(s) " + Arrays.toString(argClassNames), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("No such managed object for context : " + context);
    }
}

