/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.management.config.EhcacheStatisticsProviderConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.actions.EhcacheActionProvider;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.management.registry.AbstractManagementRegistry;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.spi.ServiceProvider;

public class DefaultManagementRegistry
extends AbstractManagementRegistry {
    public static final EhcacheStatisticsProviderConfiguration DEFAULT_EHCACHE_STATISTICS_PROVIDER_CONFIGURATION = new EhcacheStatisticsProviderConfiguration(300L, TimeUnit.SECONDS, 100, 1L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS);
    private final DefaultManagementRegistryConfiguration defaultManagementRegistryConfiguration;
    private volatile ScheduledExecutorService executor;
    private final AtomicInteger startedCounter = new AtomicInteger();

    public DefaultManagementRegistry() {
        this(null);
    }

    public DefaultManagementRegistry(DefaultManagementRegistryConfiguration defaultManagementRegistryConfiguration) {
        this.defaultManagementRegistryConfiguration = defaultManagementRegistryConfiguration;
    }

    @Override
    public void start(ServiceProvider serviceProvider) {
        if (this.startedCounter.getAndIncrement() > 0) {
            return;
        }
        StatisticsProviderConfiguration statisticsProviderConfiguration = this.defaultManagementRegistryConfiguration == null ? DEFAULT_EHCACHE_STATISTICS_PROVIDER_CONFIGURATION : this.defaultManagementRegistryConfiguration.getConfigurationFor(EhcacheStatisticsProvider.class);
        this.executor = Executors.newScheduledThreadPool(1);
        this.addSupportFor(new EhcacheStatisticsProvider(statisticsProviderConfiguration, this.executor));
        this.addSupportFor(new EhcacheActionProvider());
        super.start(serviceProvider);
    }

    @Override
    public void stop() {
        int count = this.startedCounter.decrementAndGet();
        if (count < 0) {
            this.startedCounter.incrementAndGet();
        }
        if (count == 0) {
            super.stop();
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

