/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.actions;

import org.ehcache.Ehcache;
import org.ehcache.management.annotations.Exposed;
import org.ehcache.management.annotations.Named;
import org.ehcache.management.utils.ConversionHelper;

public class EhcacheActionWrapper {
    private final Ehcache ehcache;

    public EhcacheActionWrapper(Ehcache ehcache) {
        this.ehcache = ehcache;
    }

    @Exposed
    public void clear() {
        this.ehcache.clear();
    }

    @Exposed
    public Object get(@Named(value="key") Object key) {
        Object convertedKey = ConversionHelper.convert(key, this.ehcache.getRuntimeConfiguration().getKeyType());
        return this.ehcache.get(convertedKey);
    }

    @Exposed
    public void remove(@Named(value="key") Object key) {
        Object convertedKey = ConversionHelper.convert(key, this.ehcache.getRuntimeConfiguration().getKeyType());
        this.ehcache.remove(convertedKey);
    }

    @Exposed
    public void put(@Named(value="key") Object key, @Named(value="value") Object value) {
        Object convertedKey = ConversionHelper.convert(key, this.ehcache.getRuntimeConfiguration().getKeyType());
        Object convertedValue = ConversionHelper.convert(value, this.ehcache.getRuntimeConfiguration().getValueType());
        this.ehcache.put(convertedKey, convertedValue);
    }
}

