/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap.holders;

import java.nio.ByteBuffer;
import java.time.Duration;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class SerializedOnHeapValueHolder<V>
extends OnHeapValueHolder<V>
implements BinaryValueHolder {
    private final ByteBuffer buffer;
    @IgnoreSizeOf
    private final Serializer<V> serializer;

    protected SerializedOnHeapValueHolder(long id, V value, long creationTime, long expirationTime, boolean evictionAdvice, Serializer<V> serializer) {
        super(id, creationTime, expirationTime, evictionAdvice);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (serializer == null) {
            throw new NullPointerException("null serializer");
        }
        this.serializer = serializer;
        this.buffer = serializer.serialize(value).asReadOnlyBuffer();
    }

    public SerializedOnHeapValueHolder(V value, long creationTime, boolean evictionAdvice, Serializer<V> serializer) {
        this(value, creationTime, -1L, evictionAdvice, serializer);
    }

    public SerializedOnHeapValueHolder(V value, long creationTime, long expirationTime, boolean evictionAdvice, Serializer<V> serializer) {
        this(-1L, value, creationTime, expirationTime, evictionAdvice, serializer);
    }

    public SerializedOnHeapValueHolder(Store.ValueHolder<V> valueHolder, V value, boolean evictionAdvice, Serializer<V> serializer, long now, Duration expiration) {
        this(valueHolder.getId(), value, valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT), evictionAdvice, serializer);
        this.accessed(now, expiration);
    }

    public SerializedOnHeapValueHolder(Store.ValueHolder<V> valueHolder, ByteBuffer binaryValue, boolean evictionAdvice, Serializer<V> serializer, long now, Duration expiration) {
        super(valueHolder.getId(), valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT), evictionAdvice);
        this.buffer = binaryValue;
        this.serializer = serializer;
        this.accessed(now, expiration);
    }

    public final V get() {
        try {
            return (V)this.serializer.read(this.buffer.duplicate());
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
    }

    @Override
    public ByteBuffer getBinaryValue() throws IllegalStateException {
        return this.buffer.duplicate();
    }

    @Override
    public boolean isBinaryValueAvailable() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SerializedOnHeapValueHolder that = (SerializedOnHeapValueHolder)other;
        if (!super.equals(that)) {
            return false;
        }
        try {
            if (!this.serializer.equals(that.get(), this.buffer)) {
                return false;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new SerializerException((Throwable)cnfe);
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + super.hashCode();
        return result;
    }
}

