/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.spi.service.ServiceCreationConfigurationProvider;

public class ConfigurationBuilder
implements Builder<Configuration> {
    private final Map<String, CacheConfiguration<?, ?>> caches;
    private final List<ServiceCreationConfiguration<?>> serviceConfigurations;
    private final ClassLoader classLoader;

    public static ConfigurationBuilder newConfigurationBuilder() {
        return new ConfigurationBuilder();
    }

    private ConfigurationBuilder() {
        this.caches = Collections.emptyMap();
        this.serviceConfigurations = Collections.emptyList();
        this.classLoader = null;
    }

    private ConfigurationBuilder(ConfigurationBuilder builder, Map<String, CacheConfiguration<?, ?>> caches) {
        this.caches = Collections.unmodifiableMap(caches);
        this.serviceConfigurations = builder.serviceConfigurations;
        this.classLoader = builder.classLoader;
    }

    private ConfigurationBuilder(ConfigurationBuilder builder, List<ServiceCreationConfiguration<?>> serviceConfigurations) {
        this.caches = builder.caches;
        this.serviceConfigurations = Collections.unmodifiableList(serviceConfigurations);
        this.classLoader = builder.classLoader;
    }

    private ConfigurationBuilder(ConfigurationBuilder builder, ClassLoader classLoader) {
        this.caches = builder.caches;
        this.serviceConfigurations = builder.serviceConfigurations;
        this.classLoader = classLoader;
    }

    public Configuration build() {
        return new DefaultConfiguration(this.caches, this.classLoader, this.addedAndDiscoveredServiceConfigurations());
    }

    public ConfigurationBuilder addCache(String alias, CacheConfiguration<?, ?> config) {
        HashMap newCaches = new HashMap(this.caches);
        if (newCaches.put(alias, config) != null) {
            throw new IllegalArgumentException("Cache alias '" + alias + "' already exists");
        }
        return new ConfigurationBuilder(this, newCaches);
    }

    public ConfigurationBuilder removeCache(String alias) {
        HashMap newCaches = new HashMap(this.caches);
        newCaches.remove(alias);
        return new ConfigurationBuilder(this, newCaches);
    }

    public ConfigurationBuilder addService(ServiceCreationConfiguration<?> serviceConfiguration) {
        if (this.findServiceByClass(serviceConfiguration.getClass()) != null) {
            throw new IllegalArgumentException("There is already a ServiceCreationConfiguration registered for service " + serviceConfiguration.getServiceType() + " of type " + serviceConfiguration.getClass());
        }
        ArrayList newServiceConfigurations = new ArrayList(this.serviceConfigurations);
        newServiceConfigurations.add(serviceConfiguration);
        return new ConfigurationBuilder(this, newServiceConfigurations);
    }

    <T> T findServiceByClass(Class<T> type) {
        for (ServiceCreationConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            if (!serviceConfiguration.getClass().equals(type)) continue;
            return type.cast(serviceConfiguration);
        }
        return null;
    }

    public ConfigurationBuilder removeService(ServiceCreationConfiguration<?> serviceConfiguration) {
        ArrayList newServiceConfigurations = new ArrayList(this.serviceConfigurations);
        newServiceConfigurations.remove(serviceConfiguration);
        return new ConfigurationBuilder(this, newServiceConfigurations);
    }

    public ConfigurationBuilder withClassLoader(ClassLoader classLoader) {
        return new ConfigurationBuilder(this, classLoader);
    }

    public boolean containsCache(String alias) {
        return this.caches.containsKey(alias);
    }

    private ServiceCreationConfiguration<?>[] addedAndDiscoveredServiceConfigurations() {
        Collection configuredServices = this.serviceConfigurations.stream().map(ServiceCreationConfiguration::getServiceType).collect(Collectors.toSet());
        return (ServiceCreationConfiguration[])Stream.concat(this.serviceConfigurations.stream(), StreamSupport.stream(ServiceLoader.load(ServiceCreationConfigurationProvider.class, this.classLoader).spliterator(), true).filter(provider -> !configuredServices.contains(provider.getServiceType())).map(Supplier::get).map(ServiceCreationConfiguration.class::cast)).toArray(ServiceCreationConfiguration[]::new);
    }
}

