/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.time.Duration;
import java.util.Objects;
import org.ehcache.ValueSupplier;
import org.ehcache.config.Builder;
import org.ehcache.expiry.ExpiryPolicy;

public final class ExpiryPolicyBuilder
implements Builder<ExpiryPolicy<Object, Object>> {
    private Duration create = ExpiryPolicy.INFINITE;
    private Duration access = null;
    private Duration update = null;

    public static ExpiryPolicy<Object, Object> noExpiration() {
        return ExpiryPolicy.NO_EXPIRY;
    }

    public static ExpiryPolicy<Object, Object> timeToLiveExpiration(Duration timeToLive) {
        Objects.requireNonNull(timeToLive, "TTL duration cannot be null");
        if (timeToLive.isNegative()) {
            throw new IllegalArgumentException("TTL duration cannot be negative");
        }
        return new TimeToLiveExpiryPolicy(timeToLive);
    }

    public static ExpiryPolicy<Object, Object> timeToIdleExpiration(Duration timeToIdle) {
        Objects.requireNonNull(timeToIdle, "TTI duration cannot be null");
        if (timeToIdle.isNegative()) {
            throw new IllegalArgumentException("TTI duration cannot be negative");
        }
        return new TimeToIdleExpiryPolicy(timeToIdle);
    }

    public static ExpiryPolicyBuilder expiry() {
        return new ExpiryPolicyBuilder();
    }

    private ExpiryPolicyBuilder() {
    }

    public ExpiryPolicyBuilder create(Duration create) {
        Objects.requireNonNull(create, "Create duration cannot be null");
        if (create.isNegative()) {
            throw new IllegalArgumentException("Create duration must be positive");
        }
        this.create = create;
        return this;
    }

    public ExpiryPolicyBuilder access(Duration access) {
        if (access != null && access.isNegative()) {
            throw new IllegalArgumentException("Access duration must be positive");
        }
        this.access = access;
        return this;
    }

    public ExpiryPolicyBuilder update(Duration update) {
        if (update != null && update.isNegative()) {
            throw new IllegalArgumentException("Update duration must be positive");
        }
        this.update = update;
        return this;
    }

    public ExpiryPolicy<Object, Object> build() {
        return new BaseExpiryPolicy(this.create, this.access, this.update);
    }

    private static final class TimeToIdleExpiryPolicy
    extends BaseExpiryPolicy {
        TimeToIdleExpiryPolicy(Duration tti) {
            super(tti, tti, tti);
        }
    }

    private static final class TimeToLiveExpiryPolicy
    extends BaseExpiryPolicy {
        TimeToLiveExpiryPolicy(Duration ttl) {
            super(ttl, null, ttl);
        }
    }

    private static class BaseExpiryPolicy
    implements ExpiryPolicy<Object, Object> {
        private final Duration create;
        private final Duration access;
        private final Duration update;

        BaseExpiryPolicy(Duration create, Duration access, Duration update) {
            this.create = create;
            this.access = access;
            this.update = update;
        }

        public Duration getExpiryForCreation(Object key, Object value) {
            return this.create;
        }

        public Duration getExpiryForAccess(Object key, ValueSupplier<? extends Object> value) {
            return this.access;
        }

        public Duration getExpiryForUpdate(Object key, ValueSupplier<? extends Object> oldValue, Object newValue) {
            return this.update;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseExpiryPolicy that = (BaseExpiryPolicy)o;
            if (!Objects.equals(this.access, that.access)) {
                return false;
            }
            if (!Objects.equals(this.create, that.create)) {
                return false;
            }
            return Objects.equals(this.update, that.update);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.create);
            result = 31 * result + Objects.hashCode(this.access);
            result = 31 * result + Objects.hashCode(this.update);
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{create=" + this.create + ", access=" + this.access + ", update=" + this.update + '}';
        }
    }
}

