/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.Cache;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.core.statistics.TypedValueStatistic;
import org.ehcache.impl.internal.statistics.StatsUtils;
import org.terracotta.statistics.ConstantValueStatistic;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.extended.StatisticType;

class DefaultTierStatistics
implements TierStatistics {
    private static final ValueStatistic<Long> NOT_AVAILABLE = ConstantValueStatistic.instance((Number)-1L);
    private volatile CompensatingCounters compensatingCounters = CompensatingCounters.empty();
    private final Map<String, TypedValueStatistic> knownStatistics;
    private final OperationStatistic<TierOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<TierOperationOutcomes.EvictionOutcome> eviction;
    private final ValueStatistic<Long> mapping;
    private final ValueStatistic<Long> maxMapping;
    private final ValueStatistic<Long> allocatedMemory;
    private final ValueStatistic<Long> occupiedMemory;

    public DefaultTierStatistics(Cache<?, ?> cache, String tierName) {
        this.get = (OperationStatistic)StatsUtils.findStatisticOnDescendants(cache, tierName, "tier", "get");
        this.eviction = (OperationStatistic)StatsUtils.findStatisticOnDescendants(cache, tierName, "tier", "eviction");
        this.mapping = this.findValueStatistics(cache, tierName, "mappings");
        this.maxMapping = this.findValueStatistics(cache, tierName, "maxMappings");
        this.allocatedMemory = this.findValueStatistics(cache, tierName, "allocatedMemory");
        this.occupiedMemory = this.findValueStatistics(cache, tierName, "occupiedMemory");
        Map<String, TypedValueStatistic> knownStatistics = this.createKnownStatistics(tierName);
        this.knownStatistics = Collections.unmodifiableMap(knownStatistics);
    }

    private Map<String, TypedValueStatistic> createKnownStatistics(String tierName) {
        HashMap<String, TypedValueStatistic> knownStatistics = new HashMap<String, TypedValueStatistic>(7);
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "HitCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            public Number value() {
                return DefaultTierStatistics.this.getHits();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "MissCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            public Number value() {
                return DefaultTierStatistics.this.getMisses();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "EvictionCount", this.get, new TypedValueStatistic(StatisticType.COUNTER){

            public Number value() {
                return DefaultTierStatistics.this.getEvictions();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "MappingCount", this.mapping, new TypedValueStatistic(StatisticType.COUNTER){

            public Number value() {
                return DefaultTierStatistics.this.getMappings();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "MaxMappingCount", this.maxMapping, new TypedValueStatistic(StatisticType.COUNTER){

            public Number value() {
                return DefaultTierStatistics.this.getMaxMappings();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "AllocatedByteSize", this.allocatedMemory, new TypedValueStatistic(StatisticType.SIZE){

            public Number value() {
                return DefaultTierStatistics.this.getAllocatedByteSize();
            }
        });
        DefaultTierStatistics.addKnownStatistic(knownStatistics, tierName, "OccupiedByteSize", this.occupiedMemory, new TypedValueStatistic(StatisticType.SIZE){

            public Number value() {
                return DefaultTierStatistics.this.getOccupiedByteSize();
            }
        });
        return knownStatistics;
    }

    public Map<String, TypedValueStatistic> getKnownStatistics() {
        return this.knownStatistics;
    }

    private static void addKnownStatistic(Map<String, TypedValueStatistic> knownStatistics, String tierName, String name, Object stat, TypedValueStatistic statistic) {
        if (stat != NOT_AVAILABLE) {
            knownStatistics.put(tierName + ":" + name, statistic);
        }
    }

    private ValueStatistic<Long> findValueStatistics(Cache<?, ?> cache, String tierName, String statName) {
        ValueStatistic stat = (ValueStatistic)StatsUtils.findStatisticOnDescendants(cache, tierName, tierName, statName);
        if (stat == null) {
            return NOT_AVAILABLE;
        }
        return stat;
    }

    public void clear() {
        this.compensatingCounters = this.compensatingCounters.snapshot(this);
    }

    public long getHits() {
        return this.get.sum(EnumSet.of(TierOperationOutcomes.GetOutcome.HIT));
    }

    public long getMisses() {
        return this.get.sum(EnumSet.of(TierOperationOutcomes.GetOutcome.MISS));
    }

    public long getEvictions() {
        return this.eviction.sum(EnumSet.of(TierOperationOutcomes.EvictionOutcome.SUCCESS));
    }

    public long getMappings() {
        return (Long)this.mapping.value();
    }

    public long getMaxMappings() {
        return (Long)this.maxMapping.value();
    }

    public long getAllocatedByteSize() {
        return (Long)this.allocatedMemory.value();
    }

    public long getOccupiedByteSize() {
        return (Long)this.occupiedMemory.value();
    }

    private static class CompensatingCounters {
        final long hits;
        final long misses;
        final long evictions;

        private CompensatingCounters(long hits, long misses, long evictions) {
            this.hits = hits;
            this.misses = misses;
            this.evictions = evictions;
        }

        static CompensatingCounters empty() {
            return new CompensatingCounters(0L, 0L, 0L);
        }

        CompensatingCounters snapshot(DefaultTierStatistics statistics) {
            return new CompensatingCounters(statistics.getHits() + this.hits, statistics.getMisses() + this.misses, statistics.getEvictions() + this.evictions);
        }
    }
}

