/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.StatisticsManager;

public class TieredStore<K, V>
implements Store<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(TieredStore.class);
    private final AtomicReference<CachingTier<K, V>> cachingTierRef;
    private final CachingTier<K, V> noopCachingTier;
    private final CachingTier<K, V> realCachingTier;
    private final AuthoritativeTier<K, V> authoritativeTier;

    public TieredStore(CachingTier<K, V> cachingTier, AuthoritativeTier<K, V> authoritativeTier) {
        this.cachingTierRef = new AtomicReference<CachingTier<K, CachingTier<K, V>>>(cachingTier);
        this.authoritativeTier = authoritativeTier;
        this.realCachingTier = cachingTier;
        this.noopCachingTier = new NoopCachingTier<K, V>(authoritativeTier);
        this.realCachingTier.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                TieredStore.this.authoritativeTier.flush(key, valueHolder);
            }
        });
        this.authoritativeTier.setInvalidationValve(new AuthoritativeTier.InvalidationValve(){

            public void invalidateAll() throws StoreAccessException {
                TieredStore.this.invalidateAllInternal();
            }

            public void invalidateAllWithHash(long hash) throws StoreAccessException {
                TieredStore.this.cachingTier().invalidateAllWithHash(hash);
            }
        });
        StatisticsManager.associate(cachingTier).withParent((Object)this);
        StatisticsManager.associate(authoritativeTier).withParent((Object)this);
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K key) {
                    try {
                        return TieredStore.this.authoritativeTier.getAndFault(key);
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    public boolean containsKey(K key) throws StoreAccessException {
        return this.authoritativeTier.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        try {
            Store.PutStatus putStatus = this.authoritativeTier.put(key, value);
            return putStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.putIfAbsent(key, value);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) throws StoreAccessException {
        try {
            boolean bl = this.authoritativeTier.remove(key);
            return bl;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        try {
            Store.RemoveStatus removeStatus = this.authoritativeTier.remove(key, value);
            return removeStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.replace(key, value);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        try {
            Store.ReplaceStatus replaceStatus = this.authoritativeTier.replace(key, oldValue, newValue);
            return replaceStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws StoreAccessException {
        this.swapCachingTiers();
        try {
            this.authoritativeTier.clear();
        }
        finally {
            try {
                this.realCachingTier.clear();
            }
            finally {
                this.swapBackCachingTiers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAllInternal() throws StoreAccessException {
        this.swapCachingTiers();
        try {
            this.realCachingTier.invalidateAll();
        }
        finally {
            this.swapBackCachingTiers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapCachingTiers() {
        boolean interrupted = false;
        while (!this.cachingTierRef.compareAndSet(this.realCachingTier, this.noopCachingTier)) {
            CachingTier<K, V> cachingTier = this.noopCachingTier;
            synchronized (cachingTier) {
                if (this.cachingTierRef.get() == this.noopCachingTier) {
                    try {
                        this.noopCachingTier.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapBackCachingTiers() {
        if (!this.cachingTierRef.compareAndSet(this.noopCachingTier, this.realCachingTier)) {
            throw new AssertionError((Object)"Something bad happened");
        }
        CachingTier<K, V> cachingTier = this.noopCachingTier;
        synchronized (cachingTier) {
            this.noopCachingTier.notify();
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.authoritativeTier.getStoreEventSource();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return this.authoritativeTier.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction, replaceEqual);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K k) {
                    try {
                        return TieredStore.this.authoritativeTier.computeIfAbsentAndFault(k, mappingFunction);
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction, replaceEqual);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkComputeIfAbsent(keys, mappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.addAll(this.realCachingTier.getConfigurationChangeListeners());
        configurationChangeListenerList.addAll(this.authoritativeTier.getConfigurationChangeListeners());
        return configurationChangeListenerList;
    }

    private CachingTier<K, V> cachingTier() {
        return this.cachingTierRef.get();
    }

    private static class NoopCachingTier<K, V>
    implements CachingTier<K, V> {
        private final AuthoritativeTier<K, V> authoritativeTier;

        public NoopCachingTier(AuthoritativeTier<K, V> authoritativeTier) {
            this.authoritativeTier = authoritativeTier;
        }

        public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
            Store.ValueHolder apply = (Store.ValueHolder)source.apply(key);
            this.authoritativeTier.flush(key, apply);
            return apply;
        }

        public void invalidate(K key) throws StoreAccessException {
        }

        public void invalidateAll() {
        }

        public void clear() throws StoreAccessException {
        }

        public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        }

        public void invalidateAllWithHash(long hash) throws StoreAccessException {
        }

        public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
            return null;
        }
    }

    @ServiceDependencies(value={CachingTier.Provider.class, AuthoritativeTier.Provider.class})
    public static class Provider
    implements Store.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<Store<?, ?>, Map.Entry<CachingTier.Provider, AuthoritativeTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            if (resourceTypes.size() == 1) {
                return 0;
            }
            ResourceType<?> authorityResource = this.getAuthorityResource(resourceTypes);
            int authorityRank = 0;
            Collection authorityProviders = this.serviceProvider.getServicesOfType(AuthoritativeTier.Provider.class);
            for (AuthoritativeTier.Provider authorityProvider : authorityProviders) {
                int newRank = authorityProvider.rankAuthority(authorityResource, serviceConfigs);
                if (newRank <= authorityRank) continue;
                authorityRank = newRank;
            }
            if (authorityRank == 0) {
                return 0;
            }
            HashSet cachingResources = new HashSet();
            cachingResources.addAll(resourceTypes);
            cachingResources.remove(authorityResource);
            int cachingTierRank = 0;
            Collection cachingTierProviders = this.serviceProvider.getServicesOfType(CachingTier.Provider.class);
            for (CachingTier.Provider cachingTierProvider : cachingTierProviders) {
                int newRank = cachingTierProvider.rankCachingTier(cachingResources, serviceConfigs);
                if (newRank <= cachingTierRank) continue;
                cachingTierRank = newRank;
            }
            if (cachingTierRank == 0) {
                return 0;
            }
            return authorityRank + cachingTierRank;
        }

        private ResourceType<?> getAuthorityResource(Set<ResourceType<?>> resourceTypes) {
            ResourceType<?> authorityResource = null;
            for (ResourceType<?> resourceType : resourceTypes) {
                if (authorityResource != null && authorityResource.getTierHeight() <= resourceType.getTierHeight()) continue;
                authorityResource = resourceType;
            }
            return authorityResource;
        }

        public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            ArrayList enhancedServiceConfigs = new ArrayList(Arrays.asList(serviceConfigs));
            ResourcePools resourcePools = storeConfig.getResourcePools();
            if (this.rank(resourcePools.getResourceTypeSet(), enhancedServiceConfigs) == 0) {
                throw new IllegalArgumentException("TieredStore.Provider does not support configured resource types " + resourcePools.getResourceTypeSet());
            }
            ResourceType<?> authorityResource = this.getAuthorityResource(resourcePools.getResourceTypeSet());
            AuthoritativeTier.Provider authoritativeTierProvider = this.getAuthoritativeTierProvider(authorityResource, enhancedServiceConfigs);
            HashSet cachingResources = new HashSet();
            cachingResources.addAll(resourcePools.getResourceTypeSet());
            cachingResources.remove(authorityResource);
            CachingTier.Provider cachingTierProvider = this.getCachingTierProvider(cachingResources, enhancedServiceConfigs);
            ServiceConfiguration[] configurations = enhancedServiceConfigs.toArray(new ServiceConfiguration[enhancedServiceConfigs.size()]);
            CachingTier cachingTier = cachingTierProvider.createCachingTier(storeConfig, configurations);
            AuthoritativeTier authoritativeTier = authoritativeTierProvider.createAuthoritativeTier(storeConfig, configurations);
            TieredStore store = new TieredStore(cachingTier, authoritativeTier);
            this.registerStore(store, cachingTierProvider, authoritativeTierProvider);
            return store;
        }

        private CachingTier.Provider getCachingTierProvider(Set<ResourceType<?>> cachingResources, List<ServiceConfiguration<?>> enhancedServiceConfigs) {
            CachingTier.Provider cachingTierProvider = null;
            Collection cachingTierProviders = this.serviceProvider.getServicesOfType(CachingTier.Provider.class);
            for (CachingTier.Provider provider : cachingTierProviders) {
                if (provider.rankCachingTier(cachingResources, enhancedServiceConfigs) == 0) continue;
                cachingTierProvider = provider;
                break;
            }
            if (cachingTierProvider == null) {
                throw new AssertionError((Object)("No CachingTier.Provider found although ranking found one for " + cachingResources));
            }
            return cachingTierProvider;
        }

        private AuthoritativeTier.Provider getAuthoritativeTierProvider(ResourceType<?> authorityResource, List<ServiceConfiguration<?>> enhancedServiceConfigs) {
            AuthoritativeTier.Provider authoritativeTierProvider = null;
            Collection authorityProviders = this.serviceProvider.getServicesOfType(AuthoritativeTier.Provider.class);
            for (AuthoritativeTier.Provider provider : authorityProviders) {
                if (provider.rankAuthority(authorityResource, enhancedServiceConfigs) == 0) continue;
                authoritativeTierProvider = provider;
                break;
            }
            if (authoritativeTierProvider == null) {
                throw new AssertionError((Object)("No AuthoritativeTier.Provider found although ranking found one for " + authorityResource));
            }
            return authoritativeTierProvider;
        }

        <K, V> void registerStore(TieredStore<K, V> store, CachingTier.Provider cachingTierProvider, AuthoritativeTier.Provider authoritativeTierProvider) {
            if (this.providersMap.putIfAbsent(store, new AbstractMap.SimpleEntry<CachingTier.Provider, AuthoritativeTier.Provider>(cachingTierProvider, authoritativeTierProvider)) != null) {
                throw new IllegalStateException("Instance of the Store already registered!");
            }
        }

        public void releaseStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            TieredStore tieredStore = (TieredStore)resource;
            tieredStore.authoritativeTier.setInvalidationValve(new AuthoritativeTier.InvalidationValve(){

                public void invalidateAll() throws StoreAccessException {
                }

                public void invalidateAllWithHash(long hash) throws StoreAccessException {
                }
            });
            ((CachingTier.Provider)entry.getKey()).releaseCachingTier(tieredStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).releaseAuthoritativeTier(tieredStore.authoritativeTier);
        }

        public void initStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            TieredStore tieredStore = (TieredStore)resource;
            ((CachingTier.Provider)entry.getKey()).initCachingTier(tieredStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).initAuthoritativeTier(tieredStore.authoritativeTier);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(StoreAccessException cause) {
            super((Throwable)cause);
        }

        public StoreAccessException getStoreAccessException() {
            return (StoreAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

