/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.ValueSupplier;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeEvent;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.CacheConfigurationProperty;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.events.NullStoreEventDispatcher;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.internal.util.ValueSuppliers;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.heap.LimitExceededException;
import org.ehcache.core.spi.store.heap.SizeOfEngine;
import org.ehcache.core.spi.store.heap.SizeOfEngineProvider;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.HigherCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.CachingTierOperationOutcomes;
import org.ehcache.core.statistics.HigherCachingTierOperationOutcomes;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.impl.internal.events.ScopedStoreEventDispatcher;
import org.ehcache.impl.internal.sizeof.NoopSizeOfEngine;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.heap.Backend;
import org.ehcache.impl.internal.store.heap.KeyCopyBackend;
import org.ehcache.impl.internal.store.heap.SimpleBackend;
import org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapValueHolder;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.impl.internal.store.heap.holders.SerializedOnHeapValueHolder;
import org.ehcache.impl.serialization.TransientStateRepository;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.StatefulSerializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;
import org.terracotta.statistics.MappedOperationStatistic;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public class OnHeapStore<K, V>
implements Store<K, V>,
HigherCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(OnHeapStore.class);
    private static final String STATISTICS_TAG = "OnHeap";
    private static final int ATTEMPT_RATIO = 4;
    private static final int EVICTION_RATIO = 2;
    private static final EvictionAdvisor<Object, OnHeapValueHolder<?>> EVICTION_ADVISOR = new EvictionAdvisor<Object, OnHeapValueHolder<?>>(){

        public boolean adviseAgainstEviction(Object key, OnHeapValueHolder<?> value) {
            return value.evictionAdvice();
        }
    };
    private static final Comparator<Store.ValueHolder<?>> EVICTION_PRIORITIZER = new Comparator<Store.ValueHolder<?>>(){

        @Override
        public int compare(Store.ValueHolder<?> t, Store.ValueHolder<?> u) {
            if (t instanceof Fault) {
                return -1;
            }
            if (u instanceof Fault) {
                return 1;
            }
            return Long.signum(u.lastAccessTime(TimeUnit.NANOSECONDS) - t.lastAccessTime(TimeUnit.NANOSECONDS));
        }
    };
    private static final CachingTier.InvalidationListener<?, ?> NULL_INVALIDATION_LISTENER = new CachingTier.InvalidationListener<Object, Object>(){

        public void onInvalidation(Object key, Store.ValueHolder<Object> valueHolder) {
        }
    };
    static final int SAMPLE_SIZE = 8;
    private volatile Backend<K, V> map;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Copier<V> valueCopier;
    private final SizeOfEngine sizeOfEngine;
    private final boolean byteSized;
    private volatile long capacity;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final Expiry<? super K, ? super V> expiry;
    private final TimeSource timeSource;
    private final StoreEventDispatcher<K, V> storeEventDispatcher;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener = NULL_INVALIDATION_LISTENER;
    private CacheConfigurationChangeListener cacheConfigurationChangeListener = new CacheConfigurationChangeListener(){

        public void cacheConfigurationChange(CacheConfigurationChangeEvent event) {
            if (event.getProperty().equals((Object)CacheConfigurationProperty.UPDATE_SIZE)) {
                ResourcePools updatedPools = (ResourcePools)event.getNewValue();
                ResourcePools configuredPools = (ResourcePools)event.getOldValue();
                if (((SizedResourcePool)updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP)).getSize() != ((SizedResourcePool)configuredPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP)).getSize()) {
                    LOG.info("Updating size to: {}", (Object)((SizedResourcePool)updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP)).getSize());
                    SizedResourcePool pool = (SizedResourcePool)updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP);
                    if (pool.getUnit() instanceof MemoryUnit) {
                        OnHeapStore.this.capacity = ((MemoryUnit)pool.getUnit()).toBytes(pool.getSize());
                    } else {
                        OnHeapStore.this.capacity = pool.getSize();
                    }
                }
            }
        }
    };
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome> getOrComputeIfAbsentObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateAllOutcome> invalidateAllObserver;
    private final OperationObserver<CachingTierOperationOutcomes.InvalidateAllWithHashOutcome> invalidateAllWithHashObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome> silentInvalidateObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome> silentInvalidateAllObserver;
    private final OperationObserver<HigherCachingTierOperationOutcomes.SilentInvalidateAllWithHashOutcome> silentInvalidateAllWithHashObserver;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public OnHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, Copier<K> keyCopier, Copier<V> valueCopier, SizeOfEngine sizeOfEngine, StoreEventDispatcher<K, V> eventDispatcher) {
        if (keyCopier == null) {
            throw new NullPointerException("keyCopier must not be null");
        }
        if (valueCopier == null) {
            throw new NullPointerException("valueCopier must not be null");
        }
        SizedResourcePool heapPool = (SizedResourcePool)config.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        if (heapPool == null) {
            throw new IllegalArgumentException("OnHeap store must be configured with a resource of type 'heap'");
        }
        if (timeSource == null) {
            throw new NullPointerException("timeSource must not be null");
        }
        if (sizeOfEngine == null) {
            throw new NullPointerException("sizeOfEngine must not be null");
        }
        this.sizeOfEngine = sizeOfEngine;
        this.byteSized = !(this.sizeOfEngine instanceof NoopSizeOfEngine);
        this.capacity = this.byteSized ? ((MemoryUnit)heapPool.getUnit()).toBytes(heapPool.getSize()) : heapPool.getSize();
        this.timeSource = timeSource;
        this.evictionAdvisor = config.getEvictionAdvisor() == null ? Eviction.noAdvice() : config.getEvictionAdvisor();
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        this.valueCopier = valueCopier;
        this.storeEventDispatcher = eventDispatcher;
        this.map = keyCopier instanceof IdentityCopier ? new SimpleBackend(this.byteSized) : new KeyCopyBackend(this.byteSized, keyCopier);
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).named("get")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).named("put")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).named("remove")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).named("putIfAbsent")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).named("conditionalRemove")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).named("replace")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).named("conditionalReplace")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.computeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeOutcome.class).named("compute")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.computeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfAbsentOutcome.class).named("computeIfAbsent")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).named("eviction")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.expirationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ExpirationOutcome.class).named("expiration")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.getOrComputeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.class).named("getOrComputeIfAbsent")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.invalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.InvalidateOutcome.class).named("invalidate")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.invalidateAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.InvalidateAllOutcome.class).named("invalidateAll")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.invalidateAllWithHashObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CachingTierOperationOutcomes.InvalidateAllWithHashOutcome.class).named("invalidateAllWithHash")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.silentInvalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.class).named("silentInvalidate")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.silentInvalidateAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome.class).named("silentInvalidateAll")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        this.silentInvalidateAllWithHashObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(HigherCachingTierOperationOutcomes.SilentInvalidateAllWithHashOutcome.class).named("silentInvalidateAllWithHash")).of((Object)this)).tag(new String[]{STATISTICS_TAG})).build();
        HashSet<String> tags = new HashSet<String>(Arrays.asList(STATISTICS_TAG, "tier"));
        Map<String, String> properties = Collections.singletonMap("discriminator", STATISTICS_TAG);
        StatisticsManager.createPassThroughStatistic((Object)this, (String)"mappings", tags, properties, (Callable)new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                return OnHeapStore.this.map.mappingCount();
            }
        });
        StatisticsManager.createPassThroughStatistic((Object)this, (String)"occupiedMemory", tags, properties, (Callable)new Callable<Number>(){

            @Override
            public Number call() throws Exception {
                if (OnHeapStore.this.byteSized) {
                    return OnHeapStore.this.map.byteSize();
                }
                return -1L;
            }
        });
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.internalGet(key, true);
    }

    private OnHeapValueHolder<V> internalGet(K key, boolean updateAccess) throws StoreAccessException {
        this.getObserver.begin();
        try {
            OnHeapValueHolder<V> mapping = this.getQuiet(key);
            if (mapping == null) {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            if (updateAccess) {
                this.setAccessTimeAndExpiryThenReturnMappingOutsideLock(key, mapping, this.timeSource.getTimeMillis());
            }
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
            return mapping;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    private OnHeapValueHolder<V> getQuiet(K key) throws StoreAccessException {
        try {
            OnHeapValueHolder<V> mapping = this.map.get(key);
            if (mapping == null) {
                return null;
            }
            if (mapping.isExpired(this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                this.expireMappingUnderLock(key, (Store.ValueHolder<V>)mapping);
                return null;
            }
            return mapping;
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public boolean containsKey(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.getQuiet(key) != null;
    }

    public Store.PutStatus put(final K key, final V value) throws StoreAccessException {
        this.putObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final long now = this.timeSource.getTimeMillis();
        final AtomicReference<StoreOperationOutcomes.PutOutcome> statOutcome = new AtomicReference<StoreOperationOutcomes.PutOutcome>(StoreOperationOutcomes.PutOutcome.NOOP);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        mappedValue = null;
                    }
                    if (mappedValue == null) {
                        OnHeapValueHolder newValue = OnHeapStore.this.newCreateValueHolder(key, value, now, eventSink);
                        if (newValue != null) {
                            OnHeapStore.this.updateUsageInBytesIfRequired(newValue.size());
                            statOutcome.set(StoreOperationOutcomes.PutOutcome.PUT);
                        }
                        return newValue;
                    }
                    OnHeapValueHolder newValue = OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now, eventSink);
                    if (newValue != null) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(newValue.size() - mappedValue.size());
                    } else {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    statOutcome.set(StoreOperationOutcomes.PutOutcome.REPLACED);
                    return newValue;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            StoreOperationOutcomes.PutOutcome outcome = statOutcome.get();
            this.putObserver.end((Enum)outcome);
            switch (outcome) {
                case REPLACED: {
                    return Store.PutStatus.UPDATE;
                }
                case PUT: {
                    return Store.PutStatus.PUT;
                }
                case NOOP: {
                    return Store.PutStatus.NOOP;
                }
            }
            throw new AssertionError((Object)("Unknown enum value " + outcome));
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.PutStatus.NOOP;
        }
    }

    public boolean remove(K key) throws StoreAccessException {
        this.removeObserver.begin();
        this.checkKey(key);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        final long now = this.timeSource.getTimeMillis();
        try {
            final AtomicReference<StoreOperationOutcomes.RemoveOutcome> statisticOutcome = new AtomicReference<StoreOperationOutcomes.RemoveOutcome>(StoreOperationOutcomes.RemoveOutcome.MISS);
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    statisticOutcome.set(StoreOperationOutcomes.RemoveOutcome.REMOVED);
                    eventSink.removed(mappedKey, mappedValue);
                    return null;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            StoreOperationOutcomes.RemoveOutcome outcome = statisticOutcome.get();
            this.removeObserver.end((Enum)outcome);
            switch (outcome) {
                case REMOVED: {
                    return true;
                }
                case MISS: {
                    return false;
                }
            }
            throw new AssertionError((Object)("Unknown enum value " + outcome));
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return false;
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        return this.putIfAbsent(key, value, false);
    }

    private OnHeapValueHolder<V> putIfAbsent(final K key, final V value, boolean returnCurrentMapping) throws StoreAccessException {
        this.putIfAbsentObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            OnHeapValueHolder<V> inCache = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapValueHolder holder;
                        if (mappedValue != null) {
                            OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                            OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        }
                        if ((holder = OnHeapStore.this.newCreateValueHolder(key, value, now, eventSink)) != null) {
                            OnHeapStore.this.updateUsageInBytesIfRequired(holder.size());
                        }
                        entryActuallyAdded.set(holder != null);
                        return holder;
                    }
                    returnValue.set(mappedValue);
                    OnHeapValueHolder holder = OnHeapStore.this.setAccessTimeAndExpiryThenReturnMappingUnderLock(key, mappedValue, now, eventSink);
                    if (holder == null) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    return holder;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (entryActuallyAdded.get()) {
                this.enforceCapacity();
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
            } else {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            }
            if (returnCurrentMapping) {
                return inCache;
            }
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return returnValue.get();
    }

    public Store.RemoveStatus remove(final K key, final V value) throws StoreAccessException {
        this.conditionalRemoveObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Store.RemoveStatus> outcome = new AtomicReference<Store.RemoveStatus>(Store.RemoveStatus.KEY_MISSING);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    if (value.equals(mappedValue.value())) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        eventSink.removed(mappedKey, mappedValue);
                        outcome.set(Store.RemoveStatus.REMOVED);
                        return null;
                    }
                    outcome.set(Store.RemoveStatus.KEY_PRESENT);
                    OnHeapValueHolder holder = OnHeapStore.this.setAccessTimeAndExpiryThenReturnMappingUnderLock(key, mappedValue, now, eventSink);
                    if (holder == null) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    return holder;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            Store.RemoveStatus removeStatus = outcome.get();
            switch (removeStatus) {
                case REMOVED: {
                    this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                    break;
                }
                case KEY_MISSING: 
                case KEY_PRESENT: {
                    this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
                    break;
                }
            }
            return removeStatus;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.RemoveStatus.KEY_MISSING;
        }
    }

    public Store.ValueHolder<V> replace(final K key, final V value) throws StoreAccessException {
        this.replaceObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        return null;
                    }
                    returnValue.set(mappedValue);
                    OnHeapValueHolder holder = OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now, eventSink);
                    if (holder != null) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(holder.size() - mappedValue.size());
                    } else {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    return holder;
                }
            });
            OnHeapValueHolder valueHolder = returnValue.get();
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            if (valueHolder != null) {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            } else {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return returnValue.get();
    }

    public Store.ReplaceStatus replace(final K key, final V oldValue, final V newValue) throws StoreAccessException {
        this.conditionalReplaceObserver.begin();
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        final AtomicReference<Store.ReplaceStatus> outcome = new AtomicReference<Store.ReplaceStatus>(Store.ReplaceStatus.MISS_NOT_PRESENT);
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    Object existingValue = mappedValue.value();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        return null;
                    }
                    if (oldValue.equals(existingValue)) {
                        outcome.set(Store.ReplaceStatus.HIT);
                        OnHeapValueHolder holder = OnHeapStore.this.newUpdateValueHolder(key, mappedValue, newValue, now, eventSink);
                        if (holder != null) {
                            OnHeapStore.this.updateUsageInBytesIfRequired(holder.size() - mappedValue.size());
                        } else {
                            OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        }
                        return holder;
                    }
                    outcome.set(Store.ReplaceStatus.MISS_PRESENT);
                    OnHeapValueHolder holder = OnHeapStore.this.setAccessTimeAndExpiryThenReturnMappingUnderLock(key, mappedValue, now, eventSink);
                    if (holder == null) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    return holder;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            Store.ReplaceStatus replaceStatus = outcome.get();
            switch (replaceStatus) {
                case HIT: {
                    this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                    break;
                }
                case MISS_PRESENT: 
                case MISS_NOT_PRESENT: {
                    this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown enum value " + replaceStatus));
                }
            }
            return replaceStatus;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
    }

    public void clear() {
        this.map = this.map.clear();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private final Iterator<Map.Entry<K, OnHeapValueHolder<V>>> it;
            {
                this.it = OnHeapStore.this.map.entrySetIterator();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
                Map.Entry next = this.it.next();
                final Object key = next.getKey();
                final OnHeapValueHolder value = next.getValue();
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return key;
                    }

                    public Store.ValueHolder<V> getValue() {
                        return value;
                    }
                };
            }
        };
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(final K key, final Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            Fault fault;
            this.getOrComputeIfAbsentObserver.begin();
            Backend backEnd = this.map;
            OnHeapValueHolder<V> cachedValue = backEnd.get(key);
            long now = this.timeSource.getTimeMillis();
            if (cachedValue == null && (cachedValue = backEnd.putIfAbsent(key, fault = new Fault(new NullaryFunction<Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply() {
                    return (Store.ValueHolder)source.apply(key);
                }
            }))) == null) {
                return this.resolveFault(key, backEnd, now, fault);
            }
            if (!(cachedValue instanceof Fault)) {
                if (cachedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    this.expireMappingUnderLock(key, (Store.ValueHolder<V>)cachedValue);
                    fault = new Fault(new NullaryFunction<Store.ValueHolder<V>>(){

                        public Store.ValueHolder<V> apply() {
                            return (Store.ValueHolder)source.apply(key);
                        }
                    });
                    cachedValue = backEnd.putIfAbsent(key, fault);
                    if (cachedValue == null) {
                        return this.resolveFault(key, backEnd, now, fault);
                    }
                } else {
                    this.setAccessTimeAndExpiryThenReturnMappingOutsideLock(key, cachedValue, now);
                }
            }
            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.HIT);
            return this.getValue((Store.ValueHolder<V>)cachedValue);
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    private Store.ValueHolder<V> resolveFault(final K key, Backend<K, V> backEnd, long now, Fault<V> fault) throws StoreAccessException {
        try {
            OnHeapValueHolder<V> newValue;
            Store.ValueHolder value = ((Fault)fault).get();
            if (value != null) {
                newValue = this.importValueFromLowerTier(key, value, now, backEnd, fault);
                if (newValue == null) {
                    backEnd.remove(key, fault);
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                    return value;
                }
            } else {
                backEnd.remove(key, fault);
                this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.MISS);
                return null;
            }
            if (backEnd.replace(key, fault, newValue)) {
                this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULTED);
                this.updateUsageInBytesIfRequired(newValue.size());
                this.enforceCapacity();
                return newValue;
            }
            final AtomicReference invalidatedValue = new AtomicReference();
            backEnd.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    OnHeapStore.this.notifyInvalidation(key, mappedValue);
                    invalidatedValue.set(mappedValue);
                    OnHeapStore.this.updateUsageInBytesIfRequired(mappedValue.size());
                    return null;
                }
            });
            Store.ValueHolder<V> p = this.getValue((Store.ValueHolder)invalidatedValue.get());
            if (p != null) {
                if (p.isExpired(now, TimeUnit.MILLISECONDS)) {
                    this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED_MISS);
                    return null;
                }
                this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
                return p;
            }
            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
            return newValue;
        }
        catch (Throwable e) {
            backEnd.remove(key, fault);
            throw new StoreAccessException(e);
        }
    }

    private void invalidateInGetOrComputeIfAbsent(Backend<K, V> map, final K key, final Store.ValueHolder<V> value, final Fault<V> fault, final long now, final Duration expiration) {
        map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue.equals((Object)fault)) {
                    try {
                        OnHeapStore.this.invalidationListener.onInvalidation(key, (Store.ValueHolder)OnHeapStore.this.cloneValueHolder(key, value, now, expiration, false));
                    }
                    catch (LimitExceededException ex) {
                        throw new AssertionError((Object)"Sizing is not expected to happen.");
                    }
                    return null;
                }
                return mappedValue;
            }
        });
    }

    public void invalidate(final K key) throws StoreAccessException {
        this.invalidateObserver.begin();
        this.checkKey(key);
        try {
            final AtomicReference<CachingTierOperationOutcomes.InvalidateOutcome> outcome = new AtomicReference<CachingTierOperationOutcomes.InvalidateOutcome>(CachingTierOperationOutcomes.InvalidateOutcome.MISS);
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> present) {
                    if (!(present instanceof Fault)) {
                        OnHeapStore.this.notifyInvalidation(key, present);
                        outcome.set(CachingTierOperationOutcomes.InvalidateOutcome.REMOVED);
                    }
                    OnHeapStore.this.updateUsageInBytesIfRequired(-present.size());
                    return null;
                }
            });
            this.invalidateObserver.end((Enum)outcome.get());
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public void silentInvalidate(K key, final Function<Store.ValueHolder<V>, Void> function) throws StoreAccessException {
        this.silentInvalidateObserver.begin();
        this.checkKey(key);
        try {
            final AtomicReference<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome> outcome = new AtomicReference<HigherCachingTierOperationOutcomes.SilentInvalidateOutcome>(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.MISS);
            this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    long size = 0L;
                    OnHeapValueHolder holderToPass = null;
                    if (mappedValue != null) {
                        size = mappedValue.size();
                        if (!(mappedValue instanceof Fault)) {
                            holderToPass = mappedValue;
                            outcome.set(HigherCachingTierOperationOutcomes.SilentInvalidateOutcome.REMOVED);
                        }
                    }
                    function.apply(holderToPass);
                    OnHeapStore.this.updateUsageInBytesIfRequired(-size);
                    return null;
                }
            });
            this.silentInvalidateObserver.end((Enum)outcome.get());
        }
        catch (RuntimeException re) {
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public void invalidateAll() throws StoreAccessException {
        this.invalidateAllObserver.begin();
        long errorCount = 0L;
        StoreAccessException firstException = null;
        for (K key : this.map.keySet()) {
            try {
                this.invalidate(key);
            }
            catch (StoreAccessException cae) {
                ++errorCount;
                if (firstException != null) continue;
                firstException = cae;
            }
        }
        if (firstException != null) {
            this.invalidateAllObserver.end((Enum)CachingTierOperationOutcomes.InvalidateAllOutcome.FAILURE);
            throw new StoreAccessException("Error(s) during invalidation - count is " + errorCount, (Throwable)firstException);
        }
        this.clear();
        this.invalidateAllObserver.end((Enum)CachingTierOperationOutcomes.InvalidateAllOutcome.SUCCESS);
    }

    public void silentInvalidateAll(final BiFunction<K, Store.ValueHolder<V>, Void> biFunction) throws StoreAccessException {
        this.silentInvalidateAllObserver.begin();
        StoreAccessException exception = null;
        long errorCount = 0L;
        for (final K k : this.map.keySet()) {
            try {
                this.silentInvalidate(k, new Function<Store.ValueHolder<V>, Void>(){

                    public Void apply(Store.ValueHolder<V> mappedValue) {
                        biFunction.apply(k, mappedValue);
                        return null;
                    }
                });
            }
            catch (StoreAccessException e) {
                ++errorCount;
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            this.silentInvalidateAllObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome.FAILURE);
            throw new StoreAccessException("silentInvalidateAll failed - error count: " + errorCount, (Throwable)exception);
        }
        this.silentInvalidateAllObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateAllOutcome.SUCCESS);
    }

    public void silentInvalidateAllWithHash(long hash, BiFunction<K, Store.ValueHolder<V>, Void> biFunction) throws StoreAccessException {
        this.silentInvalidateAllWithHashObserver.begin();
        Map<K, OnHeapValueHolder<V>> removed = this.map.removeAllWithHash((int)hash);
        for (Map.Entry<K, OnHeapValueHolder<V>> entry : removed.entrySet()) {
            biFunction.apply(entry.getKey(), entry.getValue());
        }
        this.silentInvalidateAllWithHashObserver.end((Enum)HigherCachingTierOperationOutcomes.SilentInvalidateAllWithHashOutcome.SUCCESS);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public void setInvalidationListener(final CachingTier.InvalidationListener<K, V> providedInvalidationListener) {
        this.invalidationListener = new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                if (!(valueHolder instanceof Fault)) {
                    providedInvalidationListener.onInvalidation(key, valueHolder);
                }
            }
        };
    }

    public void invalidateAllWithHash(long hash) throws StoreAccessException {
        this.invalidateAllWithHashObserver.begin();
        Map<K, OnHeapValueHolder<V>> removed = this.map.removeAllWithHash((int)hash);
        for (Map.Entry<K, OnHeapValueHolder<V>> entry : removed.entrySet()) {
            this.notifyInvalidation(entry.getKey(), (Store.ValueHolder)entry.getValue());
        }
        LOG.debug("CLIENT: onheap store removed all with hash {}", (Object)hash);
        this.invalidateAllWithHashObserver.end((Enum)CachingTierOperationOutcomes.InvalidateAllWithHashOutcome.SUCCESS);
    }

    private Store.ValueHolder<V> getValue(Store.ValueHolder<V> cachedValue) {
        if (cachedValue instanceof Fault) {
            return ((Fault)cachedValue).get();
        }
        return cachedValue;
    }

    private long getSizeOfKeyValuePairs(K key, OnHeapValueHolder<V> holder) throws LimitExceededException {
        return this.sizeOfEngine.sizeof(key, holder);
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        this.computeObserver.begin();
        this.checkKey(key);
        final long now = this.timeSource.getTimeMillis();
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            final AtomicReference valueHeld = new AtomicReference();
            final AtomicReference<StoreOperationOutcomes.ComputeOutcome> outcome = new AtomicReference<StoreOperationOutcomes.ComputeOutcome>(StoreOperationOutcomes.ComputeOutcome.MISS);
            OnHeapValueHolder computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    Object existingValue;
                    Object computedValue;
                    long sizeDelta = 0L;
                    if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        sizeDelta -= mappedValue.size();
                        mappedValue = null;
                    }
                    if ((computedValue = mappingFunction.apply(mappedKey, existingValue = mappedValue == null ? null : mappedValue.value())) == null) {
                        if (existingValue != null) {
                            eventSink.removed(mappedKey, mappedValue);
                            outcome.set(StoreOperationOutcomes.ComputeOutcome.REMOVED);
                            OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        }
                        return null;
                    }
                    if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue() && mappedValue != null) {
                        OnHeapValueHolder holder = OnHeapStore.this.setAccessTimeAndExpiryThenReturnMappingUnderLock(key, mappedValue, now, eventSink);
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.HIT);
                        if (holder == null) {
                            valueHeld.set(mappedValue);
                            OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        }
                        return holder;
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    if (mappedValue != null) {
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.PUT);
                        long expirationTime = mappedValue.expirationTime(OnHeapValueHolder.TIME_UNIT);
                        OnHeapValueHolder valueHolder = OnHeapStore.this.newUpdateValueHolder(key, mappedValue, computedValue, now, eventSink);
                        sizeDelta -= mappedValue.size();
                        if (valueHolder == null) {
                            try {
                                valueHeld.set(OnHeapStore.this.makeValue(key, computedValue, now, expirationTime, OnHeapStore.this.valueCopier, false));
                            }
                            catch (LimitExceededException e) {}
                        } else {
                            sizeDelta += valueHolder.size();
                        }
                        OnHeapStore.this.updateUsageInBytesIfRequired(sizeDelta);
                        return valueHolder;
                    }
                    OnHeapValueHolder holder = OnHeapStore.this.newCreateValueHolder(key, computedValue, now, eventSink);
                    if (holder != null) {
                        outcome.set(StoreOperationOutcomes.ComputeOutcome.PUT);
                        sizeDelta += holder.size();
                    }
                    OnHeapStore.this.updateUsageInBytesIfRequired(sizeDelta);
                    return holder;
                }
            });
            if (computeResult == null && valueHeld.get() != null) {
                computeResult = (OnHeapValueHolder)((Object)valueHeld.get());
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
            this.enforceCapacity();
            this.computeObserver.end((Enum)outcome.get());
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(final K key, final Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        this.computeIfAbsentObserver.begin();
        this.checkKey(key);
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            final long now = this.timeSource.getTimeMillis();
            final AtomicReference previousValue = new AtomicReference();
            final AtomicReference<StoreOperationOutcomes.ComputeIfAbsentOutcome> outcome = new AtomicReference<StoreOperationOutcomes.ComputeIfAbsentOutcome>(StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
            OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        Object computedValue;
                        if (mappedValue != null) {
                            OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                            OnHeapStore.this.fireOnExpirationEvent(mappedKey, mappedValue, eventSink);
                        }
                        if ((computedValue = mappingFunction.apply(mappedKey)) == null) {
                            return null;
                        }
                        OnHeapStore.this.checkValue(computedValue);
                        OnHeapValueHolder holder = OnHeapStore.this.newCreateValueHolder(key, computedValue, now, eventSink);
                        if (holder != null) {
                            outcome.set(StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                            OnHeapStore.this.updateUsageInBytesIfRequired(holder.size());
                        }
                        return holder;
                    }
                    previousValue.set(mappedValue);
                    outcome.set(StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
                    OnHeapValueHolder holder = OnHeapStore.this.setAccessTimeAndExpiryThenReturnMappingUnderLock(key, mappedValue, now, eventSink);
                    if (holder == null) {
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    }
                    return holder;
                }
            });
            OnHeapValueHolder previousValueHolder = (OnHeapValueHolder)((Object)previousValue.get());
            this.storeEventDispatcher.releaseEventSink(eventSink);
            if (computeResult != null) {
                this.enforceCapacity();
            }
            this.computeIfAbsentObserver.end((Enum)outcome.get());
            if (computeResult == null && previousValueHolder != null) {
                return previousValueHolder;
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            StorePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            Store.ValueHolder<V> newValue = this.computeIfAbsent(key, new Function<K, V>(){

                public V apply(K k) {
                    Set keySet = Collections.singleton(k);
                    Iterable entries = (Iterable)mappingFunction.apply(keySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object computedKey = next.getKey();
                    Object computedValue = next.getValue();
                    OnHeapStore.this.checkKey(computedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    return computedValue;
                }
            });
            result.put(key, newValue);
        }
        return result;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(this.cacheConfigurationChangeListener);
        return configurationChangeListenerList;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Store.ValueHolder<V> newValue = this.compute(key, new BiFunction<K, V, V>(){

                public V apply(K k, V oldValue) {
                    Set entrySet = Collections.singletonMap(k, oldValue).entrySet();
                    Iterable entries = (Iterable)remappingFunction.apply(entrySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object key = next.getKey();
                    Object value = next.getValue();
                    OnHeapStore.this.checkKey(key);
                    if (value != null) {
                        OnHeapStore.this.checkValue(value);
                    }
                    return value;
                }
            }, replaceEqual);
            result.put(key, newValue);
        }
        return result;
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.storeEventDispatcher;
    }

    private OnHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMappingOutsideLock(K key, OnHeapValueHolder<V> valueHolder, long now) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            duration = Duration.ZERO;
        }
        valueHolder.accessed(now, duration);
        if (Duration.ZERO.equals((Object)duration)) {
            this.expireMappingUnderLock(key, (Store.ValueHolder<V>)valueHolder);
            return null;
        }
        return valueHolder;
    }

    private OnHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMappingUnderLock(K key, OnHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        valueHolder.accessed(now, duration);
        if (Duration.ZERO.equals((Object)duration)) {
            this.fireOnExpirationEvent(key, (Store.ValueHolder<V>)valueHolder, eventSink);
            return null;
        }
        return valueHolder;
    }

    private void expireMappingUnderLock(final K key, final Store.ValueHolder<V> value) {
        final StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                    if (mappedValue.equals(value)) {
                        OnHeapStore.this.fireOnExpirationEvent(key, value, eventSink);
                        OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                        return null;
                    }
                    return mappedValue;
                }
            });
            this.storeEventDispatcher.releaseEventSink(eventSink);
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw re;
        }
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, OnHeapValueHolder<V> oldValue, V newValue, long now, StoreEventSink<K, V> eventSink) {
        if (oldValue == null) {
            throw new NullPointerException();
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForUpdate(key, oldValue, newValue);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals((Object)duration)) {
            eventSink.updated(key, oldValue, newValue);
            eventSink.expired(key, ValueSuppliers.supplierOf(newValue));
            return null;
        }
        long expirationTime = duration == null ? oldValue.expirationTime(OnHeapValueHolder.TIME_UNIT) : (duration.isInfinite() ? -1L : OnHeapStore.safeExpireTime(now, duration));
        OnHeapValueHolder<V> holder = null;
        try {
            holder = this.makeValue(key, newValue, now, expirationTime, this.valueCopier);
            eventSink.updated(key, oldValue, newValue);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
            eventSink.removed(key, oldValue);
        }
        return holder;
    }

    private OnHeapValueHolder<V> newCreateValueHolder(K key, V value, long now, StoreEventSink<K, V> eventSink) {
        Duration duration;
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            duration = this.expiry.getExpiryForCreation(key, value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return null;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        long expirationTime = duration.isInfinite() ? -1L : OnHeapStore.safeExpireTime(now, duration);
        OnHeapValueHolder<V> holder = null;
        try {
            holder = this.makeValue(key, value, now, expirationTime, this.valueCopier);
            eventSink.created(key, value);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
        }
        return holder;
    }

    private OnHeapValueHolder<V> importValueFromLowerTier(K key, Store.ValueHolder<V> valueHolder, long now, Backend<K, V> backEnd, Fault<V> fault) {
        Duration expiration = Duration.ZERO;
        try {
            expiration = this.expiry.getExpiryForAccess(key, valueHolder);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals((Object)expiration)) {
            this.invalidateInGetOrComputeIfAbsent(backEnd, key, valueHolder, fault, now, Duration.ZERO);
            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
            return null;
        }
        try {
            return this.cloneValueHolder(key, valueHolder, now, expiration, true);
        }
        catch (LimitExceededException e) {
            LOG.warn(e.getMessage());
            this.invalidateInGetOrComputeIfAbsent(backEnd, key, valueHolder, fault, now, expiration);
            this.getOrComputeIfAbsentObserver.end((Enum)CachingTierOperationOutcomes.GetOrComputeIfAbsentOutcome.FAULT_FAILED);
            return null;
        }
    }

    private OnHeapValueHolder<V> cloneValueHolder(K key, Store.ValueHolder<V> valueHolder, long now, Duration expiration, boolean sizingEnabled) throws LimitExceededException {
        Object realValue = valueHolder.value();
        boolean evictionAdvice = this.checkEvictionAdvice(key, realValue);
        OnHeapValueHolder clonedValueHolder = null;
        clonedValueHolder = this.valueCopier instanceof SerializingCopier ? (valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)valueHolder).isBinaryValueAvailable() ? new SerializedOnHeapValueHolder<V>(valueHolder, ((BinaryValueHolder)valueHolder).getBinaryValue(), evictionAdvice, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration) : new SerializedOnHeapValueHolder<Object>(valueHolder, realValue, evictionAdvice, ((SerializingCopier)this.valueCopier).getSerializer(), now, expiration)) : new CopiedOnHeapValueHolder<Object>(valueHolder, realValue, evictionAdvice, this.valueCopier, now, expiration);
        if (sizingEnabled) {
            clonedValueHolder.setSize(this.getSizeOfKeyValuePairs(key, clonedValueHolder));
        }
        return clonedValueHolder;
    }

    private OnHeapValueHolder<V> makeValue(K key, V value, long creationTime, long expirationTime, Copier<V> valueCopier) throws LimitExceededException {
        return this.makeValue(key, value, creationTime, expirationTime, valueCopier, true);
    }

    private OnHeapValueHolder<V> makeValue(K key, V value, long creationTime, long expirationTime, Copier<V> valueCopier, boolean size) throws LimitExceededException {
        boolean evictionAdvice = this.checkEvictionAdvice(key, value);
        OnHeapValueHolder valueHolder = valueCopier instanceof SerializingCopier ? new SerializedOnHeapValueHolder<V>(value, creationTime, expirationTime, evictionAdvice, ((SerializingCopier)valueCopier).getSerializer()) : new CopiedOnHeapValueHolder<V>(value, creationTime, expirationTime, evictionAdvice, valueCopier);
        if (size) {
            valueHolder.setSize(this.getSizeOfKeyValuePairs(key, valueHolder));
        }
        return valueHolder;
    }

    private boolean checkEvictionAdvice(K key, V value) {
        try {
            return this.evictionAdvisor.adviseAgainstEviction(key, value);
        }
        catch (Exception e) {
            LOG.error("Exception raised while running eviction advisor - Eviction will assume entry is NOT advised against eviction", (Throwable)e);
            return false;
        }
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OnHeapValueHolder.TIME_UNIT.convert(duration.getLength(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void updateUsageInBytesIfRequired(long delta) {
        this.map.updateUsageInBytesIfRequired(delta);
    }

    protected long byteSized() {
        return this.map.byteSize();
    }

    @FindbugsSuppressWarnings(value={"QF_QUESTIONABLE_FOR_LOOP"})
    protected void enforceCapacity() {
        StoreEventSink eventSink = this.storeEventDispatcher.eventSink();
        try {
            int evicted = 0;
            for (int attempts = 0; attempts < 4 && evicted < 2 && this.capacity < this.map.naturalSize(); ++attempts) {
                if (!this.evict(eventSink)) continue;
                ++evicted;
            }
            this.storeEventDispatcher.releaseEventSink(eventSink);
        }
        catch (RuntimeException re) {
            this.storeEventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw re;
        }
    }

    boolean evict(final StoreEventSink<K, V> eventSink) {
        this.evictionObserver.begin();
        Random random = new Random();
        Map.Entry<K, OnHeapValueHolder<V>> candidate = this.map.getEvictionCandidate(random, 8, EVICTION_PRIORITIZER, EVICTION_ADVISOR);
        if (candidate == null) {
            candidate = this.map.getEvictionCandidate(random, 8, EVICTION_PRIORITIZER, Eviction.noAdvice());
        }
        if (candidate == null) {
            return false;
        }
        final Map.Entry<K, OnHeapValueHolder<V>> evictionCandidate = candidate;
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.map.computeIfPresent(evictionCandidate.getKey(), new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue.equals(evictionCandidate.getValue())) {
                    removed.set(true);
                    if (!(evictionCandidate.getValue() instanceof Fault)) {
                        eventSink.evicted(evictionCandidate.getKey(), (ValueSupplier)evictionCandidate.getValue());
                        OnHeapStore.this.invalidationListener.onInvalidation(mappedKey, (Store.ValueHolder)evictionCandidate.getValue());
                    }
                    OnHeapStore.this.updateUsageInBytesIfRequired(-mappedValue.size());
                    return null;
                }
                return mappedValue;
            }
        });
        if (removed.get()) {
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            return true;
        }
        this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.FAILURE);
        return false;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private void fireOnExpirationEvent(K mappedKey, Store.ValueHolder<V> mappedValue, StoreEventSink<K, V> eventSink) {
        this.expirationObserver.begin();
        this.expirationObserver.end((Enum)StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
        eventSink.expired(mappedKey, mappedValue);
        this.invalidationListener.onInvalidation(mappedKey, mappedValue);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    @ServiceDependencies(value={TimeSourceService.class, CopyProvider.class, SizeOfEngineProvider.class})
    public static class Provider
    implements Store.Provider,
    CachingTier.Provider,
    HigherCachingTier.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final Map<Store<?, ?>, List<Copier>> createdStores = new ConcurrentWeakIdentityHashMap();
        private final Map<OnHeapStore<?, ?>, Collection<MappedOperationStatistic<?, ?>>> tierOperationStatistics = new ConcurrentWeakIdentityHashMap();

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            return ((Object)resourceTypes).equals(Collections.singleton(ResourceType.Core.HEAP)) ? 1 : 0;
        }

        public int rankCachingTier(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            return this.rank(resourceTypes, serviceConfigs);
        }

        public <K, V> OnHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            OnHeapStore<K, V> store = this.createStoreInternal(storeConfig, new ScopedStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            ArrayList<MappedOperationStatistic> tieredOps = new ArrayList<MappedOperationStatistic>();
            MappedOperationStatistic get = new MappedOperationStatistic(store, TierOperationOutcomes.GET_TRANSLATION, "get", ResourceType.Core.HEAP.getTierHeight(), "get", OnHeapStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)get).withParent(store);
            tieredOps.add(get);
            MappedOperationStatistic evict = new MappedOperationStatistic(store, TierOperationOutcomes.EVICTION_TRANSLATION, "eviction", ResourceType.Core.HEAP.getTierHeight(), "eviction", OnHeapStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)evict).withParent(store);
            tieredOps.add(evict);
            this.tierOperationStatistics.put(store, tieredOps);
            return store;
        }

        public <K, V> OnHeapStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?> ... serviceConfigs) {
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            CopyProvider copyProvider = (CopyProvider)this.serviceProvider.getService(CopyProvider.class);
            Copier keyCopier = copyProvider.createKeyCopier(storeConfig.getKeyType(), storeConfig.getKeySerializer(), serviceConfigs);
            Copier valueCopier = copyProvider.createValueCopier(storeConfig.getValueType(), storeConfig.getValueSerializer(), serviceConfigs);
            ArrayList<Copier> copiers = new ArrayList<Copier>();
            copiers.add(keyCopier);
            copiers.add(valueCopier);
            SizeOfEngineProvider sizeOfEngineProvider = (SizeOfEngineProvider)this.serviceProvider.getService(SizeOfEngineProvider.class);
            SizeOfEngine sizeOfEngine = sizeOfEngineProvider.createSizeOfEngine(((SizedResourcePool)storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP)).getUnit(), serviceConfigs);
            OnHeapStore<K, V> onHeapStore = new OnHeapStore<K, V>(storeConfig, timeSource, keyCopier, valueCopier, sizeOfEngine, eventDispatcher);
            this.createdStores.put(onHeapStore, copiers);
            return onHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            List<Copier> copiers = this.createdStores.remove(resource);
            if (copiers == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OnHeapStore onHeapStore = (OnHeapStore)resource;
            Provider.close(onHeapStore);
            StatisticsManager.nodeFor((Object)onHeapStore).clean();
            this.tierOperationStatistics.remove(onHeapStore);
            CopyProvider copyProvider = (CopyProvider)this.serviceProvider.getService(CopyProvider.class);
            for (Copier copier : copiers) {
                try {
                    copyProvider.releaseCopier(copier);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Exception while releasing Copier instance.", e);
                }
            }
        }

        static void close(OnHeapStore onHeapStore) {
            onHeapStore.clear();
        }

        public void initStore(Store<?, ?> resource) {
            this.checkResource(resource);
            List<Copier> copiers = this.createdStores.get(resource);
            for (Copier copier : copiers) {
                Serializer serializer;
                if (!(copier instanceof SerializingCopier) || !((serializer = ((SerializingCopier)copier).getSerializer()) instanceof StatefulSerializer)) continue;
                ((StatefulSerializer)serializer).init((StateRepository)new TransientStateRepository());
            }
        }

        private void checkResource(Object resource) {
            if (!this.createdStores.containsKey(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            OnHeapStore<K, V> cachingTier = this.createStoreInternal(storeConfig, NullStoreEventDispatcher.nullStoreEventDispatcher(), serviceConfigs);
            ArrayList<MappedOperationStatistic> tieredOps = new ArrayList<MappedOperationStatistic>();
            MappedOperationStatistic get = new MappedOperationStatistic(cachingTier, TierOperationOutcomes.GET_OR_COMPUTEIFABSENT_TRANSLATION, "get", ResourceType.Core.HEAP.getTierHeight(), "getOrComputeIfAbsent", OnHeapStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)get).withParent(cachingTier);
            tieredOps.add(get);
            MappedOperationStatistic evict = new MappedOperationStatistic(cachingTier, TierOperationOutcomes.EVICTION_TRANSLATION, "eviction", ResourceType.Core.HEAP.getTierHeight(), "eviction", OnHeapStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)evict).withParent(cachingTier);
            tieredOps.add(evict);
            this.tierOperationStatistics.put(cachingTier, tieredOps);
            return cachingTier;
        }

        public void releaseCachingTier(CachingTier<?, ?> resource) {
            this.checkResource(resource);
            try {
                resource.invalidateAll();
            }
            catch (StoreAccessException e) {
                LOG.warn("Invalidation failure while releasing caching tier", (Throwable)e);
            }
            this.releaseStore((Store)resource);
        }

        public void initCachingTier(CachingTier<?, ?> resource) {
            this.checkResource(resource);
        }

        public <K, V> HigherCachingTier<K, V> createHigherCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            OnHeapStore<K, V> higherCachingTier = this.createStoreInternal(storeConfig, new ScopedStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            ArrayList<MappedOperationStatistic> tieredOps = new ArrayList<MappedOperationStatistic>();
            MappedOperationStatistic get = new MappedOperationStatistic(higherCachingTier, TierOperationOutcomes.GET_OR_COMPUTEIFABSENT_TRANSLATION, "get", ResourceType.Core.HEAP.getTierHeight(), "getOrComputeIfAbsent", OnHeapStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)get).withParent(higherCachingTier);
            tieredOps.add(get);
            MappedOperationStatistic evict = new MappedOperationStatistic(higherCachingTier, TierOperationOutcomes.EVICTION_TRANSLATION, "eviction", ResourceType.Core.HEAP.getTierHeight(), "eviction", OnHeapStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)evict).withParent(higherCachingTier);
            tieredOps.add(evict);
            this.tierOperationStatistics.put(higherCachingTier, tieredOps);
            return higherCachingTier;
        }

        public void releaseHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.releaseCachingTier((CachingTier<?, ?>)resource);
        }

        public void initHigherCachingTier(HigherCachingTier<?, ?> resource) {
            this.checkResource(resource);
        }
    }

    private static class Fault<V>
    extends OnHeapValueHolder<V> {
        private static final int FAULT_ID = -1;
        @IgnoreSizeOf
        private final NullaryFunction<Store.ValueHolder<V>> source;
        private Store.ValueHolder<V> value;
        private Throwable throwable;
        private boolean complete;

        public Fault(NullaryFunction<Store.ValueHolder<V>> source) {
            super(-1L, 0L, true);
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(Store.ValueHolder<V> value) {
            Fault fault = this;
            synchronized (fault) {
                this.value = value;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Store.ValueHolder<V> get() {
            Fault fault = this;
            synchronized (fault) {
                if (!this.complete) {
                    try {
                        this.complete((Store.ValueHolder)this.source.apply());
                    }
                    catch (Throwable e) {
                        this.fail(e);
                    }
                }
            }
            return this.throwOrReturn();
        }

        public long getId() {
            throw new UnsupportedOperationException("You should NOT call that?!");
        }

        private Store.ValueHolder<V> throwOrReturn() {
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException("Faulting from repository failed", this.throwable);
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            Fault fault = this;
            synchronized (fault) {
                this.throwable = t;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
            this.throwOrReturn();
        }

        public V value() {
            throw new UnsupportedOperationException();
        }

        public long creationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public void setExpirationTime(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long expirationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean isExpired(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long lastAccessTime(TimeUnit unit) {
            return Long.MAX_VALUE;
        }

        public void setLastAccessTime(long lastAccessTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSize(long size) {
            throw new UnsupportedOperationException("Faults should not be sized");
        }

        @Override
        public long size() {
            return 0L;
        }

        public String toString() {
            return "[Fault : " + (this.complete ? (this.throwable == null ? String.valueOf(this.value) : this.throwable.getMessage()) : "???") + "]";
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

