/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.copy;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.ehcache.impl.internal.store.copy.ImmutableCopyingCollection;
import org.ehcache.impl.internal.store.copy.ImmutableCopyingSet;

class ImmutableCopyingMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> delegate;
    private final UnaryOperator<K> keyCopier;
    private final UnaryOperator<V> valueCopier;

    public ImmutableCopyingMap(Map<K, V> delegate, UnaryOperator<K> keyCopier, UnaryOperator<V> valueCopier) {
        this.delegate = delegate;
        this.keyCopier = keyCopier;
        this.valueCopier = valueCopier;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.valueCopier.apply(this.delegate.get(key));
    }

    @Override
    public Set<K> keySet() {
        return new ImmutableCopyingSet<K>(this.delegate.keySet(), this.keyCopier);
    }

    @Override
    public Collection<V> values() {
        return new ImmutableCopyingCollection<V>(this.delegate.values(), this.valueCopier);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ImmutableCopyingSet<Map.Entry<K, V>>(this.delegate.entrySet(), e -> new AbstractMap.SimpleImmutableEntry(this.keyCopier.apply(e.getKey()), this.valueCopier.apply(e.getValue())));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.valueCopier.apply(this.delegate.getOrDefault(key, defaultValue));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.delegate.forEach((k, v) -> action.accept((K)this.keyCopier.apply(k), (V)this.valueCopier.apply(v)));
    }
}

