/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.Cache;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.internal.service.ServiceLocator;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.HigherCachingTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.impl.internal.store.heap.OnHeapStore;
import org.ehcache.impl.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.impl.internal.store.tiering.CompoundCachingTierServiceConfiguration;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.StatisticsManager;

public class CompoundCachingTier<K, V>
implements CachingTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompoundCachingTier.class);
    private final HigherCachingTier<K, V> higher;
    private final LowerCachingTier<K, V> lower;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;

    public CompoundCachingTier(HigherCachingTier<K, V> higher, final LowerCachingTier<K, V> lower) {
        this.higher = higher;
        this.lower = lower;
        this.higher.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, final Store.ValueHolder<V> valueHolder) {
                try {
                    CompoundCachingTier.this.lower.installMapping(key, new Function<K, Store.ValueHolder<V>>(){

                        public Store.ValueHolder<V> apply(K k) {
                            return valueHolder;
                        }
                    });
                }
                catch (StoreAccessException cae) {
                    CompoundCachingTier.this.notifyInvalidation(key, valueHolder);
                    LOGGER.warn("Error overflowing '{}' into lower caching tier {}", new Object[]{key, lower, cae});
                }
            }
        });
        StatisticsManager.associate(higher).withParent((Object)this);
        StatisticsManager.associate(lower).withParent((Object)this);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(K key, final Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            return this.higher.getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K k) {
                    try {
                        Store.ValueHolder valueHolder = CompoundCachingTier.this.lower.getAndRemove(k);
                        if (valueHolder != null) {
                            return valueHolder;
                        }
                        return (Store.ValueHolder)source.apply(k);
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    public void invalidate(final K key) throws StoreAccessException {
        try {
            this.higher.silentInvalidate(key, new Function<Store.ValueHolder<V>, Void>(){

                public Void apply(Store.ValueHolder<V> mappedValue) {
                    try {
                        if (mappedValue != null) {
                            CompoundCachingTier.this.notifyInvalidation(key, mappedValue);
                        } else {
                            CompoundCachingTier.this.lower.invalidate(key);
                        }
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                    return null;
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    public void invalidate() {
        if (this.higher instanceof OnHeapStore) {
            ((OnHeapStore)this.higher).invalidate();
        }
        if (this.lower instanceof AbstractOffHeapStore) {
            AbstractOffHeapStore offHeapStore = (AbstractOffHeapStore)this.lower;
            Store.Iterator iterator = offHeapStore.iterator();
            while (iterator.hasNext()) {
                try {
                    offHeapStore.invalidate(((Cache.Entry)iterator.next()).getKey());
                }
                catch (StoreAccessException e) {
                    LOGGER.warn("Error during invalidation", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws StoreAccessException {
        try {
            this.higher.clear();
        }
        finally {
            this.lower.clear();
        }
    }

    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.lower.setInvalidationListener(invalidationListener);
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> listeners = new ArrayList<CacheConfigurationChangeListener>();
        listeners.addAll(this.higher.getConfigurationChangeListeners());
        listeners.addAll(this.lower.getConfigurationChangeListeners());
        return listeners;
    }

    public static class Provider
    implements CachingTier.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<CachingTier<?, ?>, Map.Entry<HigherCachingTier.Provider, LowerCachingTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new RuntimeException("ServiceProvider is null.");
            }
            CompoundCachingTierServiceConfiguration compoundCachingTierServiceConfiguration = (CompoundCachingTierServiceConfiguration)ServiceLocator.findSingletonAmongst(CompoundCachingTierServiceConfiguration.class, (Object[])serviceConfigs);
            if (compoundCachingTierServiceConfiguration == null) {
                throw new IllegalArgumentException("Compound caching tier cannot be configured without explicit config");
            }
            HigherCachingTier.Provider higherProvider = (HigherCachingTier.Provider)this.serviceProvider.getService(compoundCachingTierServiceConfiguration.higherProvider());
            HigherCachingTier higherCachingTier = higherProvider.createHigherCachingTier(storeConfig, serviceConfigs);
            LowerCachingTier.Provider lowerProvider = (LowerCachingTier.Provider)this.serviceProvider.getService(compoundCachingTierServiceConfiguration.lowerProvider());
            LowerCachingTier lowerCachingTier = lowerProvider.createCachingTier(storeConfig, serviceConfigs);
            CompoundCachingTier compoundCachingTier = new CompoundCachingTier(higherCachingTier, lowerCachingTier);
            this.providersMap.put(compoundCachingTier, new AbstractMap.SimpleEntry<HigherCachingTier.Provider, LowerCachingTier.Provider>(higherProvider, lowerProvider));
            return compoundCachingTier;
        }

        public void releaseCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((HigherCachingTier.Provider)entry.getKey()).releaseHigherCachingTier(compoundCachingTier.higher);
            ((LowerCachingTier.Provider)entry.getValue()).releaseCachingTier(compoundCachingTier.lower);
        }

        public void initCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((LowerCachingTier.Provider)entry.getValue()).initCachingTier(compoundCachingTier.lower);
            ((HigherCachingTier.Provider)entry.getKey()).initHigherCachingTier(compoundCachingTier.higher);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(StoreAccessException cause) {
            super(cause);
        }

        public StoreAccessException getStoreAccessException() {
            return (StoreAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

