/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;

public class StringSerializer
implements Serializer<String> {
    public StringSerializer() {
    }

    public StringSerializer(ClassLoader classLoader) {
    }

    public StringSerializer(ClassLoader classLoader, FileBasedPersistenceContext persistenceContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer serialize(String object) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(object.length());
        try {
            char c;
            int i;
            int length = object.length();
            for (i = 0; i < length && (c = object.charAt(i)) != '\u0000' && c <= '\u007f'; ++i) {
                bout.write(c);
            }
            while (i < length) {
                c = object.charAt(i);
                if (c == '\u0000') {
                    bout.write(192);
                    bout.write(128);
                } else if (c < '\u0080') {
                    bout.write(c);
                } else if (c < '\u0800') {
                    bout.write(0xC0 | c >>> 6 & 0x1F);
                    bout.write(0x80 | c & 0x3F);
                } else {
                    bout.write(0xE0 | c >>> 12 & 0x1F);
                    bout.write(0x80 | c >>> 6 & 0x3F);
                    bout.write(0x80 | c & 0x3F);
                }
                ++i;
            }
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    public String read(ByteBuffer binary) throws ClassNotFoundException {
        byte a;
        int i;
        StringBuilder sb = new StringBuilder(binary.remaining());
        int end = binary.limit();
        for (i = binary.position(); i < end && ((a = binary.get(i)) & 0x80) == 0; ++i) {
            sb.append((char)a);
        }
        while (i < end) {
            a = binary.get(i);
            if ((a & 0x80) == 0) {
                sb.append((char)a);
            } else if ((a & 0xE0) == 192) {
                sb.append((char)((a & 0x1F) << 6 | binary.get(++i) & 0x3F));
            } else if ((a & 0xF0) == 224) {
                sb.append((char)((a & 0xF) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F));
            } else {
                int codepoint;
                if ((a & 0xF8) == 240) {
                    codepoint = (a & 7) << 18 | (binary.get(++i) & 0x3F) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F;
                } else if ((a & 0xFC) == 248) {
                    codepoint = (a & 3) << 24 | (binary.get(++i) & 0x3F) << 18 | (binary.get(++i) & 0x3F) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F;
                } else if ((a & 0xFE) == 252) {
                    codepoint = (a & 1) << 30 | (binary.get(++i) & 0x3F) << 24 | (binary.get(++i) & 0x3F) << 18 | (binary.get(++i) & 0x3F) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F;
                } else {
                    throw new SerializerException("Unexpected encoding");
                }
                sb.appendCodePoint(codepoint);
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean equals(String object, ByteBuffer binary) throws ClassNotFoundException {
        byte a;
        int si;
        if (binary.remaining() < object.length()) {
            return false;
        }
        int bEnd = binary.limit();
        int bi = binary.position();
        int sLength = object.length();
        for (si = 0; bi < bEnd && si < sLength && ((a = binary.get(bi)) & 0x80) == 0; ++bi, ++si) {
            if (object.charAt(si) == (char)a) continue;
            return false;
        }
        while (bi < bEnd && si < sLength) {
            a = binary.get(bi);
            if ((a & 0x80) == 0) {
                if (object.charAt(si) != (char)a) {
                    return false;
                }
            } else if ((a & 0xE0) == 192) {
                if (object.charAt(si) != (char)((a & 0x1F) << 6 | binary.get(++bi) & 0x3F)) {
                    return false;
                }
            } else if ((a & 0xF0) == 224) {
                if (object.charAt(si) != (char)((a & 0xF) << 12 | (binary.get(++bi) & 0x3F) << 6 | binary.get(++bi) & 0x3F)) {
                    return false;
                }
            } else {
                int codepoint;
                if ((a & 0xF8) == 240) {
                    codepoint = (a & 7) << 18 | (binary.get(++bi) & 0x3F) << 12 | (binary.get(++bi) & 0x3F) << 6 | binary.get(++bi) & 0x3F;
                } else if ((a & 0xFC) == 248) {
                    codepoint = (a & 3) << 24 | (binary.get(++bi) & 0x3F) << 18 | (binary.get(++bi) & 0x3F) << 12 | (binary.get(++bi) & 0x3F) << 6 | binary.get(++bi) & 0x3F;
                } else if ((a & 0xFE) == 252) {
                    codepoint = (a & 1) << 30 | (binary.get(++bi) & 0x3F) << 24 | (binary.get(++bi) & 0x3F) << 18 | (binary.get(++bi) & 0x3F) << 12 | (binary.get(++bi) & 0x3F) << 6 | binary.get(++bi) & 0x3F;
                } else {
                    throw new SerializerException("Unrecognized encoding");
                }
                char[] chars = Character.toChars(codepoint);
                if (si + 1 == sLength || object.charAt(si) != chars[0] || object.charAt(++si) != chars[1]) {
                    return false;
                }
            }
            ++bi;
            ++si;
        }
        return bi == bEnd && si == sLength;
    }
}

