/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.CachePersistenceException;
import org.ehcache.Status;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.internal.service.ServiceLocator;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.impl.internal.events.ThreadLocalStoreEventDispatcher;
import org.ehcache.impl.internal.store.disk.DiskWriteThreadPool;
import org.ehcache.impl.internal.store.disk.EhcachePersistentConcurrentOffHeapClockCache;
import org.ehcache.impl.internal.store.disk.factories.EhcachePersistentSegmentFactory;
import org.ehcache.impl.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.impl.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.terracotta.offheapstore.disk.persistent.Persistent;
import org.terracotta.offheapstore.disk.persistent.PersistentPortability;
import org.terracotta.offheapstore.disk.storage.FileBackedStorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.util.Factory;
import org.terracotta.offheapstore.util.MemoryUnit;

public class OffHeapDiskStore<K, V>
extends AbstractOffHeapStore<K, V>
implements AuthoritativeTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapDiskStore.class);
    private static final String KEY_TYPE_PROPERTY_NAME = "keyType";
    private static final String VALUE_TYPE_PROPERTY_NAME = "valueType";
    private static final int DEFAULT_CONCURRENCY = 16;
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.UNINITIALIZED);
    private final EvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ClassLoader classLoader;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private final FileBasedPersistenceContext fileBasedPersistenceContext;
    private final ExecutionService executionService;
    private final String threadPoolAlias;
    private final int writerConcurrency;
    private volatile EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapDiskStore(FileBasedPersistenceContext fileBasedPersistenceContext, ExecutionService executionService, String threadPoolAlias, int writerConcurrency, Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher, long sizeInBytes) {
        super("local-disk", config, timeSource, eventDispatcher);
        this.fileBasedPersistenceContext = fileBasedPersistenceContext;
        this.executionService = executionService;
        this.threadPoolAlias = threadPoolAlias;
        this.writerConcurrency = writerConcurrency;
        EvictionAdvisor evictionAdvisor = config.getEvictionAdvisor();
        this.evictionAdvisor = evictionAdvisor != null ? OffHeapDiskStore.wrap(evictionAdvisor) : Eviction.noAdvice();
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.classLoader = config.getClassLoader();
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
        if (!this.status.compareAndSet(Status.UNINITIALIZED, Status.AVAILABLE)) {
            throw new AssertionError();
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> getBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, EvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) {
        File dataFile = this.getDataFile();
        File indexFile = this.getIndexFile();
        File metadataFile = this.getMetadataFile();
        if (dataFile.isFile() && indexFile.isFile() && metadataFile.isFile()) {
            try {
                return this.recoverBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            return this.createBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> recoverBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, EvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) throws IOException {
        File dataFile = this.getDataFile();
        File indexFile = this.getIndexFile();
        File metadataFile = this.getMetadataFile();
        FileInputStream fis = new FileInputStream(metadataFile);
        Properties properties = new Properties();
        try {
            properties.load(fis);
        }
        finally {
            fis.close();
        }
        try {
            Class<?> persistedKeyType = Class.forName(properties.getProperty(KEY_TYPE_PROPERTY_NAME), false, this.classLoader);
            if (!this.keyType.equals(persistedKeyType)) {
                throw new IllegalArgumentException("Persisted key type '" + persistedKeyType.getName() + "' is not the same as the configured key type '" + this.keyType.getName() + "'");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Persisted key type class not found", cnfe);
        }
        try {
            Class<?> persistedValueType = Class.forName(properties.getProperty(VALUE_TYPE_PROPERTY_NAME), false, this.classLoader);
            if (!this.valueType.equals(persistedValueType)) {
                throw new IllegalArgumentException("Persisted value type '" + persistedValueType.getName() + "' is not the same as the configured value type '" + this.valueType.getName() + "'");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Persisted value type class not found", cnfe);
        }
        FileInputStream fin = new FileInputStream(indexFile);
        try {
            ObjectInputStream input = new ObjectInputStream(fin);
            long dataTimestampFromIndex = input.readLong();
            long dataTimestampFromFile = dataFile.lastModified();
            long delta = dataTimestampFromFile - dataTimestampFromIndex;
            if (delta < 0L) {
                LOGGER.info("The index for data file {} is more recent than the data file itself by {}ms : this is harmless.", (Object)dataFile.getName(), (Object)(-delta));
            } else {
                if (delta > TimeUnit.SECONDS.toMillis(1L)) {
                    LOGGER.warn("The index for data file {} is out of date by {}ms, probably due to an unclean shutdown. Creating a new empty store.", (Object)dataFile.getName(), (Object)delta);
                    EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = this.createBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
                    return ehcachePersistentConcurrentOffHeapClockCache;
                }
                if (delta > 0L) {
                    LOGGER.info("The index for data file {} is out of date by {}ms, assuming this small delta is a result of the OS/filesystem.", (Object)dataFile.getName(), (Object)delta);
                }
            }
            MappedPageSource source = new MappedPageSource(dataFile, false, size);
            try {
                PersistentPortability<K> keyPortability = OffHeapDiskStore.persistent(new SerializerPortability<K>(keySerializer));
                PersistentPortability<V> elementPortability = OffHeapDiskStore.persistent(new OffHeapValueHolderPortability<V>(valueSerializer));
                DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool(this.executionService, this.threadPoolAlias, this.writerConcurrency);
                Factory storageEngineFactory = FileBackedStorageEngine.createFactory((MappedPageSource)source, (long)Math.max(size / 16L / 10L, 1024L), (MemoryUnit)MemoryUnit.BYTES, keyPortability, elementPortability, (Factory)writeWorkers, (boolean)false);
                EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>> factory = new EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, 64, evictionAdvisor, this.mapEvictionListener, false);
                EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> m = new EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(input, evictionAdvisor, factory);
                m.bootstrap(input);
                EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = m;
                return ehcachePersistentConcurrentOffHeapClockCache;
            }
            catch (IOException e) {
                try {
                    source.close();
                    throw e;
                }
                catch (Exception e2) {
                    LOGGER.info("Index file was corrupt. Deleting data file {}. {}", (Object)dataFile.getAbsolutePath(), (Object)e2.getMessage());
                    LOGGER.debug("Exception during recovery", (Throwable)e2);
                    EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = this.createBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
                    return ehcachePersistentConcurrentOffHeapClockCache;
                }
            }
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, EvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) throws IOException {
        File metadataFile = this.getMetadataFile();
        FileOutputStream fos = new FileOutputStream(metadataFile);
        try {
            Properties properties = new Properties();
            properties.put(KEY_TYPE_PROPERTY_NAME, this.keyType.getName());
            properties.put(VALUE_TYPE_PROPERTY_NAME, this.valueType.getName());
            properties.store(fos, "Key and value types");
        }
        finally {
            fos.close();
        }
        MappedPageSource source = new MappedPageSource(this.getDataFile(), size);
        PersistentPortability<K> keyPortability = OffHeapDiskStore.persistent(new SerializerPortability<K>(keySerializer));
        PersistentPortability<V> elementPortability = OffHeapDiskStore.persistent(new OffHeapValueHolderPortability<V>(valueSerializer));
        DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool(this.executionService, this.threadPoolAlias, this.writerConcurrency);
        Factory storageEngineFactory = FileBackedStorageEngine.createFactory((MappedPageSource)source, (long)Math.max(size / 16L / 10L, 1024L), (MemoryUnit)MemoryUnit.BYTES, keyPortability, elementPortability, (Factory)writeWorkers, (boolean)true);
        EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>> factory = new EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, 64, evictionAdvisor, this.mapEvictionListener, true);
        return new EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(evictionAdvisor, factory, 16);
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    private File getDataFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.data");
    }

    private File getIndexFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.index");
    }

    private File getMetadataFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.meta");
    }

    public static <T> PersistentPortability<T> persistent(final Portability<T> normal) {
        Class<?> normalKlazz = normal.getClass();
        Class<?>[] delegateInterfaces = normalKlazz.getInterfaces();
        Class<?>[] proxyInterfaces = Arrays.copyOf(delegateInterfaces, delegateInterfaces.length + 1);
        proxyInterfaces[delegateInterfaces.length] = PersistentPortability.class;
        return (PersistentPortability)Proxy.newProxyInstance(normal.getClass().getClassLoader(), proxyInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] os) throws Throwable {
                if (method.getDeclaringClass().equals(Persistent.class)) {
                    return null;
                }
                return method.invoke((Object)normal, os);
            }
        });
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class, ExecutionService.class})
    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider {
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());
        private final String defaultThreadPool;
        private volatile ServiceProvider<Service> serviceProvider;

        public Provider() {
            this(null);
        }

        public Provider(String threadPoolAlias) {
            this.defaultThreadPool = threadPoolAlias;
        }

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            return ((Object)resourceTypes).equals(Collections.singleton(ResourceType.Core.DISK)) ? 1 : 0;
        }

        public <K, V> OffHeapDiskStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
        }

        private <K, V> OffHeapDiskStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?> ... serviceConfigs) {
            int writerConcurrency;
            String threadPoolAlias;
            if (this.serviceProvider == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapDiskStore.Provider.");
            }
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            ExecutionService executionService = (ExecutionService)this.serviceProvider.getService(ExecutionService.class);
            SizedResourcePool diskPool = (SizedResourcePool)storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.DISK);
            if (!(diskPool.getUnit() instanceof org.ehcache.config.units.MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapDiskStore only supports resources configuration expressed in \"memory\" unit");
            }
            org.ehcache.config.units.MemoryUnit unit = (org.ehcache.config.units.MemoryUnit)diskPool.getUnit();
            LocalPersistenceService localPersistenceService = (LocalPersistenceService)this.serviceProvider.getService(LocalPersistenceService.class);
            if (localPersistenceService == null) {
                throw new IllegalStateException("No LocalPersistenceService could be found - did you configure it at the CacheManager level?");
            }
            OffHeapDiskStoreConfiguration config = (OffHeapDiskStoreConfiguration)ServiceLocator.findSingletonAmongst(OffHeapDiskStoreConfiguration.class, (Object[])serviceConfigs);
            if (config == null) {
                threadPoolAlias = this.defaultThreadPool;
                writerConcurrency = 1;
            } else {
                threadPoolAlias = config.getThreadPoolAlias();
                writerConcurrency = config.getWriterConcurrency();
            }
            LocalPersistenceService.PersistenceSpaceIdentifier space = (LocalPersistenceService.PersistenceSpaceIdentifier)ServiceLocator.findSingletonAmongst(LocalPersistenceService.PersistenceSpaceIdentifier.class, (Object[])serviceConfigs);
            try {
                FileBasedPersistenceContext persistenceContext = localPersistenceService.createPersistenceContextWithin(space, "offheap-disk-store");
                OffHeapDiskStore<K, V> offHeapStore = new OffHeapDiskStore<K, V>(persistenceContext, executionService, threadPoolAlias, writerConcurrency, storeConfig, timeSource, eventDispatcher, unit.toBytes(diskPool.getSize()));
                this.createdStores.add((Store<?, ?>)offHeapStore);
                return offHeapStore;
            }
            catch (CachePersistenceException cpex) {
                throw new RuntimeException("Unable to create persistence context in " + space, cpex);
            }
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            try {
                Provider.close((OffHeapDiskStore)resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static <K, V> void close(OffHeapDiskStore<K, V> resource) throws IOException {
            EhcachePersistentConcurrentOffHeapClockCache localMap = ((OffHeapDiskStore)resource).map;
            if (localMap != null) {
                ((OffHeapDiskStore)resource).map = null;
                localMap.flush();
                ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(((OffHeapDiskStore)resource).getIndexFile()));
                try {
                    output.writeLong(System.currentTimeMillis());
                    localMap.persist(output);
                }
                finally {
                    output.close();
                }
                localMap.close();
            }
        }

        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapDiskStore)resource);
        }

        static <K, V> void init(OffHeapDiskStore<K, V> resource) {
            ((OffHeapDiskStore)resource).map = ((OffHeapDiskStore)resource).getBackingMap(((OffHeapDiskStore)resource).sizeInBytes, ((OffHeapDiskStore)resource).keySerializer, ((OffHeapDiskStore)resource).valueSerializer, ((OffHeapDiskStore)resource).evictionAdvisor);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }
    }
}

