/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.events;

import org.ehcache.core.internal.events.EventListenerWrapper;
import org.ehcache.event.CacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventDispatchTask<K, V>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatchTask.class);
    private final CacheEvent<K, V> cacheEvent;
    private final Iterable<EventListenerWrapper> listenerWrappers;

    EventDispatchTask(CacheEvent<K, V> cacheEvent, Iterable<EventListenerWrapper> listener) {
        if (cacheEvent == null) {
            throw new NullPointerException("cache event cannot be null");
        }
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        this.cacheEvent = cacheEvent;
        this.listenerWrappers = listener;
    }

    @Override
    public void run() {
        for (EventListenerWrapper listenerWrapper : this.listenerWrappers) {
            if (!listenerWrapper.isForEventType(this.cacheEvent.getType())) continue;
            try {
                listenerWrapper.onEvent(this.cacheEvent);
            }
            catch (Exception e) {
                LOGGER.warn(listenerWrapper.getListener() + " Failed to fire Event due to ", (Throwable)e);
            }
        }
    }
}

