/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.impl.internal.store.disk.OffHeapDiskStore;
import org.ehcache.impl.internal.store.heap.OnHeapStore;
import org.ehcache.impl.internal.store.offheap.OffHeapStore;
import org.ehcache.impl.internal.store.tiering.CompoundCachingTier;
import org.ehcache.impl.internal.store.tiering.CompoundCachingTierServiceConfiguration;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.statistics.StatisticsManager;

public class TieredStore<K, V>
implements Store<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(TieredStore.class);
    private final AtomicReference<CachingTier<K, V>> cachingTierRef;
    private final CachingTier<K, V> noopCachingTier;
    private final CachingTier<K, V> realCachingTier;
    private final AuthoritativeTier<K, V> authoritativeTier;
    private final TieringStoreStatsSettings tieringStoreStatsSettings;

    public TieredStore(CachingTier<K, V> cachingTier, AuthoritativeTier<K, V> authoritativeTier) {
        this.cachingTierRef = new AtomicReference<CachingTier<K, CachingTier<K, V>>>(cachingTier);
        this.authoritativeTier = authoritativeTier;
        this.realCachingTier = cachingTier;
        this.noopCachingTier = new NoopCachingTier<K, V>(authoritativeTier);
        this.realCachingTier.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, Store.ValueHolder<V> valueHolder) {
                TieredStore.this.authoritativeTier.flush(key, valueHolder);
            }
        });
        StatisticsManager.associate(cachingTier).withParent((Object)this);
        StatisticsManager.associate(authoritativeTier).withParent((Object)this);
        this.tieringStoreStatsSettings = new TieringStoreStatsSettings(cachingTier, authoritativeTier);
        StatisticsManager.associate((Object)this.tieringStoreStatsSettings).withParent((Object)this);
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K key) {
                    try {
                        return TieredStore.this.authoritativeTier.getAndFault(key);
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    public boolean containsKey(K key) throws StoreAccessException {
        return this.authoritativeTier.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        try {
            Store.PutStatus putStatus = this.authoritativeTier.put(key, value);
            return putStatus;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        Store.ValueHolder previous = null;
        try {
            previous = this.authoritativeTier.putIfAbsent(key, value);
        }
        finally {
            if (previous == null) {
                this.cachingTier().invalidate(key);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) throws StoreAccessException {
        try {
            boolean bl = this.authoritativeTier.remove(key);
            return bl;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        Store.RemoveStatus removed = null;
        try {
            Store.RemoveStatus removeStatus = removed = this.authoritativeTier.remove(key, value);
            return removeStatus;
        }
        finally {
            if (removed != null && removed.equals((Object)Store.RemoveStatus.REMOVED)) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        Store.ValueHolder previous = null;
        boolean exceptionThrown = true;
        try {
            previous = this.authoritativeTier.replace(key, value);
            exceptionThrown = false;
        }
        finally {
            if (exceptionThrown || previous != null) {
                this.cachingTier().invalidate(key);
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        Store.ReplaceStatus replaced = null;
        try {
            replaced = this.authoritativeTier.replace(key, oldValue, newValue);
        }
        finally {
            if (replaced != null && replaced.equals((Object)Store.ReplaceStatus.HIT)) {
                this.cachingTier().invalidate(key);
            }
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws StoreAccessException {
        CachingTier<K, V> cachingTier;
        boolean interrupted = false;
        while (!this.cachingTierRef.compareAndSet(this.realCachingTier, this.noopCachingTier)) {
            cachingTier = this.noopCachingTier;
            synchronized (cachingTier) {
                if (this.cachingTierRef.get() == this.noopCachingTier) {
                    try {
                        this.noopCachingTier.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            this.authoritativeTier.clear();
        }
        finally {
            try {
                this.realCachingTier.clear();
            }
            finally {
                if (!this.cachingTierRef.compareAndSet(this.noopCachingTier, this.realCachingTier)) {
                    throw new AssertionError((Object)"Something bad happened");
                }
                cachingTier = this.noopCachingTier;
                synchronized (cachingTier) {
                    this.noopCachingTier.notify();
                }
            }
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.authoritativeTier.getStoreEventSource();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return this.authoritativeTier.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        try {
            Store.ValueHolder valueHolder = this.authoritativeTier.compute(key, mappingFunction, replaceEqual);
            return valueHolder;
        }
        finally {
            this.cachingTier().invalidate(key);
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        try {
            return this.cachingTier().getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K k) {
                    try {
                        return TieredStore.this.authoritativeTier.computeIfAbsentAndFault(k, mappingFunction);
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkCompute(keys, remappingFunction, replaceEqual);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        try {
            Map map = this.authoritativeTier.bulkComputeIfAbsent(keys, mappingFunction);
            return map;
        }
        finally {
            for (K key : keys) {
                this.cachingTier().invalidate(key);
            }
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.addAll(this.realCachingTier.getConfigurationChangeListeners());
        configurationChangeListenerList.addAll(this.authoritativeTier.getConfigurationChangeListeners());
        return configurationChangeListenerList;
    }

    private CachingTier<K, V> cachingTier() {
        return this.cachingTierRef.get();
    }

    private static class NoopCachingTier<K, V>
    implements CachingTier<K, V> {
        private final AuthoritativeTier<K, V> authoritativeTier;

        public NoopCachingTier(AuthoritativeTier<K, V> authoritativeTier) {
            this.authoritativeTier = authoritativeTier;
        }

        public Store.ValueHolder<V> getOrComputeIfAbsent(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
            Store.ValueHolder apply = (Store.ValueHolder)source.apply(key);
            this.authoritativeTier.flush(key, apply);
            return apply;
        }

        public void invalidate(K key) throws StoreAccessException {
        }

        public void clear() throws StoreAccessException {
        }

        public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        }

        public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
            return null;
        }
    }

    private static final class TieringStoreStatsSettings {
        @ContextAttribute(value="tags")
        private final Set<String> tags = new HashSet<String>(Arrays.asList("store"));
        @ContextAttribute(value="cachingTier")
        private final CachingTier<?, ?> cachingTier;
        @ContextAttribute(value="authoritativeTier")
        private final AuthoritativeTier<?, ?> authoritativeTier;

        TieringStoreStatsSettings(CachingTier<?, ?> cachingTier, AuthoritativeTier<?, ?> authoritativeTier) {
            this.cachingTier = cachingTier;
            this.authoritativeTier = authoritativeTier;
        }
    }

    @ServiceDependencies(value={CompoundCachingTier.Provider.class, OnHeapStore.Provider.class, OffHeapStore.Provider.class, OffHeapDiskStore.Provider.class})
    public static class Provider
    implements Store.Provider {
        private static final Set<Set<ResourceType.Core>> SUPPORTED_RESOURCE_COMBINATIONS;
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<Store<?, ?>, Map.Entry<CachingTier.Provider, AuthoritativeTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            if (SUPPORTED_RESOURCE_COMBINATIONS.contains(resourceTypes)) {
                return resourceTypes.size();
            }
            return 0;
        }

        public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            ArrayList enhancedServiceConfigs = new ArrayList(Arrays.asList(serviceConfigs));
            TieredStoreConfiguration tieredStoreServiceConfig = this.setTierConfigurations(storeConfig, enhancedServiceConfigs);
            Class<? extends CachingTier.Provider> cachingTierProviderClass = tieredStoreServiceConfig.cachingTierProvider();
            CachingTier.Provider cachingTierProvider = (CachingTier.Provider)this.serviceProvider.getService(cachingTierProviderClass);
            if (cachingTierProvider == null) {
                throw new IllegalArgumentException("No registered service for caching tier provider " + cachingTierProviderClass.getName());
            }
            Class<? extends AuthoritativeTier.Provider> authoritativeTierProviderClass = tieredStoreServiceConfig.authoritativeTierProvider();
            AuthoritativeTier.Provider authoritativeTierProvider = (AuthoritativeTier.Provider)this.serviceProvider.getService(authoritativeTierProviderClass);
            if (authoritativeTierProvider == null) {
                throw new IllegalArgumentException("No registered service for authoritative tier provider " + authoritativeTierProviderClass.getName());
            }
            ServiceConfiguration[] configurations = enhancedServiceConfigs.toArray(new ServiceConfiguration[enhancedServiceConfigs.size()]);
            CachingTier cachingTier = cachingTierProvider.createCachingTier(storeConfig, configurations);
            AuthoritativeTier authoritativeTier = authoritativeTierProvider.createAuthoritativeTier(storeConfig, configurations);
            TieredStore store = new TieredStore(cachingTier, authoritativeTier);
            this.registerStore(store, cachingTierProvider, authoritativeTierProvider);
            return store;
        }

        private <K, V> TieredStoreConfiguration setTierConfigurations(Store.Configuration<K, V> storeConfig, List<ServiceConfiguration<?>> enhancedServiceConfigs) {
            TieredStoreConfiguration tieredStoreConfiguration;
            ResourcePools resourcePools = storeConfig.getResourcePools();
            if (this.rank(resourcePools.getResourceTypeSet(), enhancedServiceConfigs) == 0) {
                throw new IllegalArgumentException("TieredStore.Provider does not support configured resource types " + resourcePools.getResourceTypeSet());
            }
            ResourcePool heapPool = resourcePools.getPoolForResource((ResourceType)ResourceType.Core.HEAP);
            ResourcePool offHeapPool = resourcePools.getPoolForResource((ResourceType)ResourceType.Core.OFFHEAP);
            ResourcePool diskPool = resourcePools.getPoolForResource((ResourceType)ResourceType.Core.DISK);
            if (diskPool != null) {
                if (heapPool == null) {
                    throw new IllegalStateException("Cannot store to disk without heap resource");
                }
                if (offHeapPool != null) {
                    enhancedServiceConfigs.add(new CompoundCachingTierServiceConfiguration().higherProvider(OnHeapStore.Provider.class).lowerProvider(OffHeapStore.Provider.class));
                    tieredStoreConfiguration = new TieredStoreConfiguration().cachingTierProvider(CompoundCachingTier.Provider.class).authoritativeTierProvider(OffHeapDiskStore.Provider.class);
                } else {
                    tieredStoreConfiguration = new TieredStoreConfiguration().cachingTierProvider(OnHeapStore.Provider.class).authoritativeTierProvider(OffHeapDiskStore.Provider.class);
                }
            } else if (offHeapPool != null) {
                if (heapPool == null) {
                    throw new IllegalStateException("Cannot store to offheap without heap resource");
                }
                tieredStoreConfiguration = new TieredStoreConfiguration().cachingTierProvider(OnHeapStore.Provider.class).authoritativeTierProvider(OffHeapStore.Provider.class);
            } else {
                throw new IllegalStateException("TieredStore.Provider does not support heap-only stores");
            }
            return tieredStoreConfiguration;
        }

        <K, V> void registerStore(TieredStore<K, V> store, CachingTier.Provider cachingTierProvider, AuthoritativeTier.Provider authoritativeTierProvider) {
            if (this.providersMap.putIfAbsent(store, new AbstractMap.SimpleEntry<CachingTier.Provider, AuthoritativeTier.Provider>(cachingTierProvider, authoritativeTierProvider)) != null) {
                throw new IllegalStateException("Instance of the Store already registered!");
            }
        }

        public void releaseStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            TieredStore tieredStore = (TieredStore)resource;
            ((CachingTier.Provider)entry.getKey()).releaseCachingTier(tieredStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).releaseAuthoritativeTier(tieredStore.authoritativeTier);
        }

        public void initStore(Store<?, ?> resource) {
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            if (entry == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            TieredStore tieredStore = (TieredStore)resource;
            ((CachingTier.Provider)entry.getKey()).initCachingTier(tieredStore.realCachingTier);
            ((AuthoritativeTier.Provider)entry.getValue()).initAuthoritativeTier(tieredStore.authoritativeTier);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }

        static {
            HashSet<Set<ResourceType.Core>> supported = new HashSet<Set<ResourceType.Core>>();
            supported.add(Collections.unmodifiableSet(EnumSet.of(ResourceType.Core.HEAP, ResourceType.Core.DISK)));
            supported.add(Collections.unmodifiableSet(EnumSet.of(ResourceType.Core.HEAP, ResourceType.Core.OFFHEAP)));
            supported.add(Collections.unmodifiableSet(EnumSet.of(ResourceType.Core.HEAP, ResourceType.Core.OFFHEAP, ResourceType.Core.DISK)));
            SUPPORTED_RESOURCE_COMBINATIONS = Collections.unmodifiableSet(supported);
        }

        private static class TieredStoreConfiguration {
            private Class<? extends CachingTier.Provider> cachingTierProvider;
            private Class<? extends AuthoritativeTier.Provider> authoritativeTierProvider;

            private TieredStoreConfiguration() {
            }

            public TieredStoreConfiguration cachingTierProvider(Class<? extends CachingTier.Provider> cachingTierProvider) {
                this.cachingTierProvider = cachingTierProvider;
                return this;
            }

            public TieredStoreConfiguration authoritativeTierProvider(Class<? extends AuthoritativeTier.Provider> authoritativeTierProvider) {
                this.authoritativeTierProvider = authoritativeTierProvider;
                return this;
            }

            public Class<? extends CachingTier.Provider> cachingTierProvider() {
                return this.cachingTierProvider;
            }

            public Class<? extends AuthoritativeTier.Provider> authoritativeTierProvider() {
                return this.authoritativeTierProvider;
            }
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(StoreAccessException cause) {
            super(cause);
        }

        public StoreAccessException getStoreAccessException() {
            return (StoreAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

