/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap.factories;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.ehcache.config.EvictionVeto;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.terracotta.offheapstore.ReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.util.Factory;

public class EhcacheSegmentFactory<K, V>
implements Factory<PinnableSegment<K, V>> {
    private final Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private final EvictionVeto<? super K, ? super V> evictionVeto;
    private final EhcacheSegment.EvictionListener<K, V> evictionListener;

    public EhcacheSegmentFactory(PageSource source, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory, int initialTableSize, EvictionVeto<? super K, ? super V> evictionVeto, EhcacheSegment.EvictionListener<K, V> evictionListener) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.evictionVeto = evictionVeto;
        this.evictionListener = evictionListener;
    }

    public PinnableSegment<K, V> newInstance() {
        StorageEngine storageEngine = (StorageEngine)this.storageEngineFactory.newInstance();
        try {
            return new EhcacheSegment<K, V>(this.tableSource, storageEngine, this.tableSize, this.evictionVeto, this.evictionListener);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcacheSegment<K, V>
    extends ReadWriteLockedOffHeapClockCache<K, V> {
        public static final int VETOED = 0x20000000;
        private final EvictionVeto<? super K, ? super V> evictionVeto;
        private final EvictionListener<K, V> evictionListener;

        EhcacheSegment(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize, EvictionVeto<? super K, ? super V> evictionVeto, EvictionListener<K, V> evictionListener) {
            super(source, true, storageEngine, tableSize);
            this.evictionVeto = evictionVeto;
            this.evictionListener = evictionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V compute(K key, BiFunction<K, V, V> mappingFunction, boolean pin) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Object value = this.get(key);
                Object newValue = mappingFunction.apply(key, value);
                if (newValue != null) {
                    if (newValue != value) {
                        this.put(key, newValue);
                    }
                    if (pin) {
                        this.setPinning(key, true);
                    }
                } else {
                    this.remove(key);
                }
                Object object = newValue;
                return (V)object;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V computeIfPresent(K key, BiFunction<K, V, V> mappingFunction) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Object value = this.get(key);
                if (value != null) {
                    Object newValue = mappingFunction.apply(key, value);
                    if (newValue != value) {
                        if (newValue != null) {
                            this.put(key, newValue);
                        } else {
                            this.remove(key);
                        }
                    }
                    Object object = newValue;
                    return (V)object;
                }
                V v = null;
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean computeIfPinned(K key, BiFunction<K, V, V> remappingFunction, Function<V, Boolean> flippingPinningBitFunction) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                if (this.isPinned(key)) {
                    Object previousValue = this.get(key);
                    Object newValue = remappingFunction.apply(key, previousValue);
                    if (newValue != previousValue) {
                        if (newValue == null) {
                            this.remove(key);
                        } else {
                            this.put(key, newValue);
                        }
                    }
                    if (((Boolean)flippingPinningBitFunction.apply(previousValue)).booleanValue()) {
                        this.getAndSetMetadata(key, 0x40000000, 0);
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        public V put(K key, V value) {
            int metadata = this.getVetoedStatus(key, value);
            return (V)this.put(key, value, metadata);
        }

        private int getVetoedStatus(K key, V value) {
            return this.evictionVeto.vetoes(key, value) ? 0x20000000 : 0;
        }

        public V putPinned(K key, V value) {
            int metadata = this.getVetoedStatus(key, value) | 0x40000000;
            return (V)this.put(key, value, metadata);
        }

        protected boolean evictable(int status) {
            return super.evictable(status) && (status & 0x20000000) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evict(int index, boolean shrink) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Map.Entry entry = this.getEntryAtTableOffset(index);
                boolean evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.onEviction(entry.getKey(), entry.getValue());
                }
                boolean bl = evicted;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        public static interface EvictionListener<K, V> {
            public void onEviction(K var1, V var2);
        }
    }
}

