/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.sizeof;

import org.ehcache.config.ResourceUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.sizeof.SizeOfEngineConfiguration;
import org.ehcache.core.spi.ServiceLocator;
import org.ehcache.core.spi.sizeof.SizeOfEngine;
import org.ehcache.core.spi.sizeof.SizeOfEngineProvider;
import org.ehcache.impl.internal.sizeof.DefaultSizeOfEngine;
import org.ehcache.impl.internal.sizeof.NoopSizeOfEngine;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.ServiceConfiguration;

public class DefaultSizeOfEngineProvider
implements SizeOfEngineProvider {
    private final long maxObjectGraphSize;
    private final long maxObjectSize;

    public DefaultSizeOfEngineProvider(long maxObjectGraphSize, long maxObjectSize) {
        this.maxObjectGraphSize = maxObjectGraphSize;
        this.maxObjectSize = maxObjectSize;
    }

    public void start(ServiceProvider serviceProvider) {
    }

    public void stop() {
    }

    public SizeOfEngine createSizeOfEngine(ResourceUnit resourceUnit, ServiceConfiguration<?> ... serviceConfigs) {
        boolean isByteSized = resourceUnit instanceof MemoryUnit;
        if (!isByteSized) {
            return new NoopSizeOfEngine();
        }
        SizeOfEngineConfiguration config = (SizeOfEngineConfiguration)ServiceLocator.findSingletonAmongst(SizeOfEngineConfiguration.class, (Object[])serviceConfigs);
        if (config != null) {
            long maxSize = config.getUnit().toBytes(config.getMaxObjectSize());
            return new DefaultSizeOfEngine(config.getMaxObjectGraphSize(), maxSize);
        }
        return new DefaultSizeOfEngine(this.maxObjectGraphSize, this.maxObjectSize);
    }
}

