/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.loaderwriter.writebehind;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.ehcache.exceptions.BulkCacheWritingException;
import org.ehcache.exceptions.CacheWritingException;
import org.ehcache.loaderwriter.writebehind.WriteBehind;
import org.ehcache.loaderwriter.writebehind.operations.DeleteOperation;
import org.ehcache.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.loaderwriter.writebehind.operations.WriteOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;

abstract class AbstractWriteBehind<K, V>
implements WriteBehind<K, V> {
    private final CacheLoaderWriter<K, V> cacheLoaderWriter;

    public AbstractWriteBehind(CacheLoaderWriter<K, V> cacheLoaderWriter) {
        this.cacheLoaderWriter = cacheLoaderWriter;
    }

    public V load(K key) throws Exception {
        SingleOperation<K, V> operation = this.getOperation(key);
        return (V)(operation == null ? this.cacheLoaderWriter.load(key) : (operation.getClass() == WriteOperation.class ? ((WriteOperation)operation).getValue() : null));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        HashMap<K, V> entries = new HashMap<K, V>();
        for (K k : keys) {
            entries.put(k, this.load(k));
        }
        return entries;
    }

    public void write(K key, V value) throws CacheWritingException {
        this.addOperation(new WriteOperation<K, V>(key, value));
    }

    public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) throws BulkCacheWritingException, Exception {
        for (Map.Entry<K, V> entry : entries) {
            this.write(entry.getKey(), entry.getValue());
        }
    }

    public void delete(K key) throws CacheWritingException {
        this.addOperation(new DeleteOperation(key));
    }

    public void deleteAll(Iterable<? extends K> keys) throws BulkCacheWritingException, Exception {
        for (K k : keys) {
            this.delete(k);
        }
    }

    protected abstract SingleOperation<K, V> getOperation(K var1);

    protected abstract void addOperation(SingleOperation<K, V> var1);

    protected static <T> void putUninterruptibly(BlockingQueue<T> queue, T r) {
        boolean interrupted = false;
        while (true) {
            try {
                queue.put(r);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

