/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.ehcache.Cache;
import org.ehcache.config.EvictionVeto;
import org.ehcache.events.CacheEvents;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.exceptions.CachePassThroughException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.function.Predicate;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.spi.cache.CacheStoreHelper;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.cache.tiering.LowerCachingTier;
import org.ehcache.statistics.AuthoritativeTierOperationOutcomes;
import org.ehcache.statistics.LowerCachingTierOperationsOutcome;
import org.ehcache.statistics.StoreOperationOutcomes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.observer.OperationObserver;

public abstract class AbstractOffHeapStore<K, V>
implements AuthoritativeTier<K, V>,
LowerCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOffHeapStore.class);
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TimeSource timeSource;
    private final Expiry<? super K, ? super V> expiry;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfPresentOutcome> computeIfPresentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.GetAndFaultOutcome> getAndFaultObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome> computeIfAbsentAndFaultObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.FlushOutcome> flushObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.GetAndRemoveOutcome> getAndRemoveObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InstallMappingOutcome> installMappingObserver;
    private volatile Callable<Void> valve;
    private volatile StoreEventListener<K, V> eventListener = CacheEvents.nullStoreEventListener();
    protected BackingMapEvictionListener<K, V> mapEvictionListener;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public AbstractOffHeapStore(String statisticsTag, Store.Configuration<K, V> config, TimeSource timeSource) {
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        this.timeSource = timeSource;
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of((Object)this)).named("get")).tag(new String[]{statisticsTag})).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of((Object)this)).named("put")).tag(new String[]{statisticsTag})).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).of((Object)this)).named("putIfAbsent")).tag(new String[]{statisticsTag})).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of((Object)this)).named("remove")).tag(new String[]{statisticsTag})).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).of((Object)this)).named("conditionalRemove")).tag(new String[]{statisticsTag})).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).of((Object)this)).named("replace")).tag(new String[]{statisticsTag})).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).of((Object)this)).named("conditionalReplace")).tag(new String[]{statisticsTag})).build();
        this.computeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeOutcome.class).of((Object)this)).named("compute")).tag(new String[]{statisticsTag})).build();
        this.computeIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfAbsentOutcome.class).of((Object)this)).named("computeIfAbsent")).tag(new String[]{statisticsTag})).build();
        this.computeIfPresentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ComputeIfPresentOutcome.class).of((Object)this)).named("computeIfPresent")).tag(new String[]{statisticsTag})).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).of((Object)this)).named("eviction")).tag(new String[]{statisticsTag})).build();
        this.expirationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ExpirationOutcome.class).of((Object)this)).named("expiration")).tag(new String[]{statisticsTag})).build();
        this.getAndFaultObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.class).of((Object)this)).named("getAndFault")).tag(new String[]{statisticsTag})).build();
        this.computeIfAbsentAndFaultObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.class).of((Object)this)).named("computeIfAbsentAndFault")).tag(new String[]{statisticsTag})).build();
        this.flushObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.FlushOutcome.class).of((Object)this)).named("flush")).tag(new String[]{statisticsTag})).build();
        this.invalidateObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.InvalidateOutcome.class).of((Object)this)).named("invalidate")).tag(new String[]{statisticsTag})).build();
        this.getAndRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.class).of((Object)this)).named("getAndRemove")).tag(new String[]{statisticsTag})).build();
        this.installMappingObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(LowerCachingTierOperationsOutcome.InstallMappingOutcome.class).of((Object)this)).named("installMapping")).tag(new String[]{statisticsTag})).build();
        this.mapEvictionListener = new BackingMapEvictionListener(this.evictionObserver);
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, true);
    }

    private Store.ValueHolder<V> internalGet(K key, final boolean updateAccess) throws CacheAccessException {
        this.getObserver.begin();
        try {
            OffHeapValueHolder<V> result = this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        if (mappedValue != null) {
                            AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                        }
                        return null;
                    }
                    if (updateAccess) {
                        return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
                    }
                    return mappedValue;
                }
            }, false);
            if (result == null) {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
            } else {
                this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
            }
            return result;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public boolean containsKey(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, false) != null;
    }

    public void put(final K key, final V value) throws CacheAccessException {
        this.putObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean entryReplaced = new AtomicBoolean(false);
        while (true) {
            final long now = this.timeSource.getTimeMillis();
            try {
                this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                    public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                        entryReplaced.set(mappedValue != null);
                        if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                            mappedValue = null;
                        }
                        if (mappedValue == null) {
                            return AbstractOffHeapStore.this.newCreateValueHolder(key, value, now);
                        }
                        return AbstractOffHeapStore.this.newUpdatedValueHolder(key, value, mappedValue, now);
                    }
                }, false);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
        if (entryReplaced.get()) {
            this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.REPLACED);
        } else {
            this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, final V value) throws NullPointerException, CacheAccessException {
        this.putIfAbsentObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference returnValue = new AtomicReference();
        while (true) {
            try {
                this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                    public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                        long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                        if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                            if (mappedValue != null) {
                                AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                            }
                            return AbstractOffHeapStore.this.newCreateValueHolder(mappedKey, value, now);
                        }
                        returnValue.set(mappedValue);
                        return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
                    }
                }, false);
                Store.ValueHolder resultHolder = (Store.ValueHolder)returnValue.get();
                if (resultHolder == null) {
                    this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
                    return null;
                }
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
                return resultHolder;
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
    }

    public void remove(K key) throws CacheAccessException {
        this.removeObserver.begin();
        this.checkKey(key);
        try {
            if (this.backingMap().remove(key) != null) {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
            } else {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public boolean remove(K key, final V value) throws CacheAccessException {
        this.conditionalRemoveObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                        return null;
                    }
                    if (mappedValue.value().equals(value)) {
                        removed.set(true);
                        return null;
                    }
                    return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
                }
            });
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        if (removed.get()) {
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
            return true;
        }
        this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
        return false;
    }

    public Store.ValueHolder<V> replace(K key, final V value) throws NullPointerException, CacheAccessException {
        this.replaceObserver.begin();
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                returnValue.set(mappedValue);
                return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, value, mappedValue, now);
            }
        };
        while (true) {
            try {
                this.backingMap().compute(key, mappingFunction, false);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
        Store.ValueHolder resultHolder = returnValue.get();
        if (resultHolder != null) {
            this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
        } else {
            this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
        }
        return resultHolder;
    }

    public boolean replace(K key, final V oldValue, final V newValue) throws NullPointerException, IllegalArgumentException, CacheAccessException {
        this.conditionalReplaceObserver.begin();
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicBoolean replaced = new AtomicBoolean(false);
        BiFunction mappingFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                if (oldValue.equals(mappedValue.value())) {
                    replaced.set(true);
                    return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, newValue, mappedValue, now);
                }
                return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
            }
        };
        while (true) {
            try {
                this.backingMap().compute(key, mappingFunction, false);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(key, ex);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
        if (replaced.get()) {
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
            return true;
        }
        this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
        return false;
    }

    public void clear() throws CacheAccessException {
        try {
            this.backingMap().clear();
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
        this.eventListener = listener;
        ((BackingMapEvictionListener)this.mapEvictionListener).setStoreEventListener(this.eventListener);
    }

    public void disableStoreEventNotifications() {
        this.eventListener = CacheEvents.nullStoreEventListener();
        ((BackingMapEvictionListener)this.mapEvictionListener).setStoreEventListener(this.eventListener);
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return new OffHeapStoreIterator();
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        OffHeapValueHolder<V> result;
        this.computeObserver.begin();
        this.checkKey(key);
        final AtomicBoolean write = new AtomicBoolean(false);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                Object existingValue = null;
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                    }
                    mappedValue = null;
                } else {
                    existingValue = mappedValue.value();
                }
                Object computedValue = mappingFunction.apply(mappedKey, existingValue);
                if (computedValue == null) {
                    if (mappedValue != null) {
                        write.set(true);
                    }
                    return null;
                }
                if (AbstractOffHeapStore.this.safeEquals(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    if (mappedValue != null) {
                        return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
                    }
                    return mappedValue;
                }
                AbstractOffHeapStore.this.checkValue(computedValue);
                write.set(true);
                if (mappedValue != null) {
                    return AbstractOffHeapStore.this.newUpdatedValueHolder(key, computedValue, mappedValue, now);
                }
                return AbstractOffHeapStore.this.newCreateValueHolder(key, computedValue, now);
            }
        };
        while (true) {
            try {
                result = this.backingMap().compute(key, computeFunction, false);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
        if (result == null) {
            if (write.get()) {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.REMOVED);
            } else {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.MISS);
            }
        } else if (write.get()) {
            this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.PUT);
        } else {
            this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.HIT);
        }
        return result;
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, false);
    }

    private Store.ValueHolder<V> internalComputeIfAbsent(K key, final Function<? super K, ? extends V> mappingFunction, boolean fault) throws CacheAccessException {
        OffHeapValueHolder<V> computeResult;
        if (fault) {
            this.computeIfAbsentAndFaultObserver.begin();
        } else {
            this.computeIfAbsentObserver.begin();
        }
        this.checkKey(key);
        final AtomicBoolean write = new AtomicBoolean(false);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                    }
                    write.set(true);
                    Object computedValue = mappingFunction.apply(mappedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    AbstractOffHeapStore.this.checkValue(computedValue);
                    return AbstractOffHeapStore.this.newCreateValueHolder(mappedKey, computedValue, now);
                }
                return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
            }
        };
        while (true) {
            try {
                computeResult = this.backingMap().compute(key, computeFunction, fault);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
        if (write.get()) {
            if (computeResult != null) {
                if (fault) {
                    this.computeIfAbsentAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.PUT);
                } else {
                    this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                }
            } else if (fault) {
                this.computeIfAbsentAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.NOOP);
            } else {
                this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
            }
        } else if (fault) {
            this.computeIfAbsentAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.HIT);
        } else {
            this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
        }
        return computeResult;
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        OffHeapValueHolder<V> computeResult;
        this.computeIfPresentObserver.begin();
        this.checkKey(key);
        final AtomicBoolean write = new AtomicBoolean(false);
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                    }
                    return null;
                }
                Object computedValue = remappingFunction.apply(mappedKey, mappedValue.value());
                if (computedValue == null) {
                    write.set(true);
                    return null;
                }
                if (AbstractOffHeapStore.this.safeEquals(mappedValue.value(), computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(mappedKey, mappedValue, now);
                }
                AbstractOffHeapStore.this.checkValue(computedValue);
                write.set(true);
                return AbstractOffHeapStore.this.newUpdatedValueHolder(mappedKey, computedValue, mappedValue, now);
            }
        };
        while (true) {
            try {
                computeResult = this.backingMap().compute(key, computeFunction, false);
            }
            catch (OversizeMappingException e) {
                this.handleOversizeMappingException(key, e);
                continue;
            }
            catch (RuntimeException re) {
                CachePassThroughException.handleRuntimeException((RuntimeException)re);
                continue;
            }
            break;
        }
        if (computeResult == null) {
            if (write.get()) {
                this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.REMOVED);
            } else {
                this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.MISS);
            }
        } else if (write.get()) {
            this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.PUT);
        } else {
            this.computeIfPresentObserver.end((Enum)StoreOperationOutcomes.ComputeIfPresentOutcome.HIT);
        }
        return computeResult;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            BiFunction biFunction = new BiFunction<K, V, V>(){

                public V apply(final K k, final V v) {
                    Map.Entry entry = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return k;
                        }

                        @Override
                        public V getValue() {
                            return v;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    Iterator iterator = ((Iterable)remappingFunction.apply(Collections.singleton(entry))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        AbstractOffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.compute(key, biFunction, replaceEqual);
            result.put(key, computed);
        }
        return result;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Function function = new Function<K, V>(){

                public V apply(K k) {
                    Iterator iterator = ((Iterable)mappingFunction.apply(Collections.singleton(k))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        AbstractOffHeapStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.computeIfAbsent(key, function);
            result.put(key, computed);
        }
        return result;
    }

    public Store.ValueHolder<V> getAndFault(K key) throws CacheAccessException {
        this.getAndFaultObserver.begin();
        this.checkKey(key);
        Store.ValueHolder mappedValue = null;
        try {
            mappedValue = (Store.ValueHolder)this.backingMap().getAndPin(key);
            if (mappedValue != null && mappedValue.isExpired(this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                if (this.backingMap().remove(key, mappedValue)) {
                    this.onExpiration(key, mappedValue);
                }
                mappedValue = null;
            }
            if (mappedValue == null) {
                this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.MISS);
            } else {
                this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.HIT);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
        return mappedValue;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, true);
    }

    public boolean flush(K key, final Store.ValueHolder<V> valueFlushed) {
        this.flushObserver.begin();
        this.checkKey(key);
        boolean result = this.backingMap().computeIfPinned(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> valuePresent) {
                if (valuePresent.getId() == valueFlushed.getId()) {
                    if (valueFlushed.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), OffHeapValueHolder.TIME_UNIT)) {
                        AbstractOffHeapStore.this.onExpiration(k, valuePresent);
                        return null;
                    }
                    valuePresent.updateMetadata(valueFlushed);
                    valuePresent.writeBack();
                }
                return valuePresent;
            }
        }, new Function<OffHeapValueHolder<V>, Boolean>(){

            public Boolean apply(OffHeapValueHolder<V> valuePresent) {
                return valuePresent.getId() == valueFlushed.getId();
            }
        });
        if (result) {
            this.flushObserver.end((Enum)AuthoritativeTierOperationOutcomes.FlushOutcome.HIT);
            return true;
        }
        this.flushObserver.end((Enum)AuthoritativeTierOperationOutcomes.FlushOutcome.MISS);
        return false;
    }

    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.eventListener = new StoreEventListener<K, V>(){

            public void onEviction(K key, Store.ValueHolder<V> valueHolder) {
                AbstractOffHeapStore.this.invalidationListener.onInvalidation(key, valueHolder);
            }

            public void onExpiration(K key, Store.ValueHolder<V> valueHolder) {
                AbstractOffHeapStore.this.invalidationListener.onInvalidation(key, valueHolder);
            }
        };
    }

    public void invalidate(final K key) throws CacheAccessException {
        this.invalidateObserver.begin();
        final AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().computeIfPresent(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> present) {
                    removed.set(true);
                    AbstractOffHeapStore.this.notifyInvalidation(key, present);
                    return null;
                }
            });
            if (removed.get()) {
                this.invalidateObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateOutcome.REMOVED);
            } else {
                this.invalidateObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    public void invalidate(K key, final NullaryFunction<K> function) throws CacheAccessException {
        this.invalidateObserver.begin();
        final AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().compute(key, new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> offHeapValueHolder) {
                    if (offHeapValueHolder != null) {
                        removed.set(true);
                        AbstractOffHeapStore.this.notifyInvalidation(k, offHeapValueHolder);
                    }
                    function.apply();
                    return null;
                }
            }, false);
            if (removed.get()) {
                this.invalidateObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateOutcome.REMOVED);
            } else {
                this.invalidateObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
        }
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public Store.ValueHolder<V> getAndRemove(K key) throws CacheAccessException {
        this.getAndRemoveObserver.begin();
        this.checkKey(key);
        final AtomicReference valueHolderAtomicReference = new AtomicReference();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K mappedKey, OffHeapValueHolder<V> mappedValue) {
                long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        AbstractOffHeapStore.this.onExpiration(mappedKey, mappedValue);
                    }
                    mappedValue = null;
                }
                valueHolderAtomicReference.set(mappedValue);
                return null;
            }
        };
        try {
            this.backingMap().compute(key, computeFunction, false);
            Store.ValueHolder result = (Store.ValueHolder)valueHolderAtomicReference.get();
            if (result == null) {
                this.getAndRemoveObserver.end((Enum)LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.MISS);
            } else {
                this.getAndRemoveObserver.end((Enum)LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.HIT_REMOVED);
            }
            return result;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public Store.ValueHolder<V> installMapping(final K key, final Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
        this.installMappingObserver.begin();
        BiFunction computeFunction = new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

            public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> offHeapValueHolder) {
                if (offHeapValueHolder != null) {
                    throw new AssertionError();
                }
                Store.ValueHolder valueHolder = (Store.ValueHolder)source.apply(k);
                if (valueHolder != null) {
                    if (valueHolder.isExpired(AbstractOffHeapStore.this.timeSource.getTimeMillis(), TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.onExpiration(key, valueHolder);
                        return null;
                    }
                    return AbstractOffHeapStore.this.newTransferValueHolder(valueHolder);
                }
                return null;
            }
        };
        try {
            OffHeapValueHolder<V> computeResult;
            while (true) {
                try {
                    computeResult = this.backingMap().compute(key, computeFunction, false);
                }
                catch (OversizeMappingException e) {
                    this.handleOversizeMappingException(key, e);
                    continue;
                }
                break;
            }
            if (computeResult != null) {
                this.installMappingObserver.end((Enum)LowerCachingTierOperationsOutcome.InstallMappingOutcome.PUT);
            } else {
                this.installMappingObserver.end((Enum)LowerCachingTierOperationsOutcome.InstallMappingOutcome.NOOP);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            CachePassThroughException.handleRuntimeException((RuntimeException)re);
            return null;
        }
    }

    public void registerEmergencyValve(Callable<Void> valve) {
        this.valve = valve;
    }

    private boolean safeEquals(V existingValue, V computedValue) {
        return existingValue == computedValue || existingValue != null && existingValue.equals(computedValue);
    }

    private OffHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMapping(K key, OffHeapValueHolder<V> valueHolder, long now) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder.value());
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            this.onExpiration(key, (Store.ValueHolder<V>)valueHolder);
            return null;
        }
        valueHolder.accessed(now, duration);
        valueHolder.writeBack();
        return valueHolder;
    }

    private OffHeapValueHolder<V> newUpdatedValueHolder(K key, V value, OffHeapValueHolder<V> existing, long now) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForUpdate(key, existing.value(), value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return null;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration == null) {
            return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, existing.expirationTime(OffHeapValueHolder.TIME_UNIT));
        }
        if (duration.isForever()) {
            return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, AbstractOffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newCreateValueHolder(K key, V value, long now) {
        Duration duration;
        try {
            duration = this.expiry.getExpiryForCreation(key, value);
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return null;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration.isForever()) {
            return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new OffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, AbstractOffHeapStore.safeExpireTime(now, duration));
    }

    private OffHeapValueHolder<V> newTransferValueHolder(Store.ValueHolder<V> valueHolder) {
        return new OffHeapValueHolder<Object>(valueHolder.getId(), valueHolder.value(), valueHolder.creationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.expirationTime(OffHeapValueHolder.TIME_UNIT), valueHolder.lastAccessTime(OffHeapValueHolder.TIME_UNIT), valueHolder.hits(), null);
    }

    public void handleOversizeMappingException(K key, OversizeMappingException cause) throws CacheAccessException {
        this.handleOversizeMappingException(key, cause, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOversizeMappingException(K key, OversizeMappingException cause, AtomicBoolean invokeValve) throws CacheAccessException {
        if (!this.backingMap().shrinkOthers(key.hashCode()) && !this.invokeValve(invokeValve)) {
            for (Segment<K, OffHeapValueHolder<V>> segment : this.backingMap().getSegments()) {
                Lock lock = segment.writeLock();
                lock.lock();
                try {
                    for (Object keyToEvict : segment.keySet()) {
                        if (this.backingMap().getAndSetMetadata(keyToEvict, 0x20000000, 0) != 0x20000000) continue;
                        return;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            throw new CacheAccessException("The element with key '" + key + "' is too large to be stored" + " in this offheap store.", (Throwable)cause);
        }
    }

    private boolean invokeValve(AtomicBoolean invokeValve) throws CacheAccessException {
        if (invokeValve == null || !invokeValve.get()) {
            return false;
        }
        invokeValve.set(false);
        Callable<Void> valve = this.valve;
        if (valve != null) {
            try {
                valve.call();
            }
            catch (Exception exception) {
                throw new CacheAccessException("Failed invoking valve", (Throwable)exception);
            }
        }
        return true;
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OffHeapValueHolder.TIME_UNIT.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private void onExpiration(K mappedKey, Store.ValueHolder<V> mappedValue) {
        this.expirationObserver.begin();
        this.expirationObserver.end((Enum)StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
        this.eventListener.onExpiration(mappedKey, mappedValue);
    }

    protected abstract EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap();

    protected static <K, V> Predicate<Map.Entry<K, OffHeapValueHolder<V>>> wrap(EvictionVeto<? super K, ? super V> delegate, TimeSource timeSource) {
        return new OffHeapEvictionVetoWrapper(delegate, timeSource);
    }

    static class BackingMapEvictionListener<K, V>
    implements EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, OffHeapValueHolder<V>> {
        private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
        private StoreEventListener<K, V> storeEventListener;

        private BackingMapEvictionListener(OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver) {
            this.evictionObserver = evictionObserver;
            this.storeEventListener = CacheEvents.nullStoreEventListener();
        }

        private void setStoreEventListener(StoreEventListener<K, V> storeEventListener) {
            if (storeEventListener == null) {
                throw new NullPointerException("store event listener cannot be null");
            }
            this.storeEventListener = storeEventListener;
        }

        @Override
        public void onEviction(K key, OffHeapValueHolder<V> value) {
            this.evictionObserver.begin();
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            this.storeEventListener.onEviction(key, value);
        }
    }

    class OffHeapStoreIterator
    implements Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> {
        private final Iterator<Map.Entry<K, OffHeapValueHolder<V>>> mapIterator;
        private Map.Entry<K, OffHeapValueHolder<V>> next = null;
        private CacheAccessException prefetchFailure = null;

        OffHeapStoreIterator() {
            this.mapIterator = AbstractOffHeapStore.this.backingMap().entrySet().iterator();
            this.advance();
        }

        private void advance() {
            this.next = null;
            try {
                while (this.next == null && this.mapIterator.hasNext()) {
                    Map.Entry entry = this.mapIterator.next();
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    if (entry.getValue().isExpired(now, TimeUnit.MILLISECONDS)) {
                        AbstractOffHeapStore.this.containsKey(entry.getKey());
                        continue;
                    }
                    this.next = entry;
                }
            }
            catch (CacheAccessException ce) {
                this.prefetchFailure = ce;
            }
            catch (RuntimeException re) {
                this.prefetchFailure = new CacheAccessException((Throwable)re);
            }
        }

        public boolean hasNext() {
            return this.next != null || this.prefetchFailure != null;
        }

        public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
            Duration duration;
            if (this.prefetchFailure != null) {
                throw this.prefetchFailure;
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            final Map.Entry thisEntry = this.next;
            this.advance();
            final long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
            AbstractOffHeapStore.this.backingMap().computeIfPresent(thisEntry.getKey(), new BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>>(){

                public OffHeapValueHolder<V> apply(K k, OffHeapValueHolder<V> currentMapping) {
                    if (currentMapping.getId() == ((OffHeapValueHolder)((Object)thisEntry.getValue())).getId()) {
                        return AbstractOffHeapStore.this.setAccessTimeAndExpiryThenReturnMapping(k, currentMapping, now);
                    }
                    return currentMapping;
                }
            });
            try {
                duration = AbstractOffHeapStore.this.expiry.getExpiryForAccess(thisEntry.getKey(), thisEntry.getValue().value());
            }
            catch (RuntimeException re) {
                LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
                duration = Duration.ZERO;
            }
            thisEntry.getValue().accessed(now, duration);
            return new Cache.Entry<K, Store.ValueHolder<V>>(){

                public K getKey() {
                    return thisEntry.getKey();
                }

                public Store.ValueHolder<V> getValue() {
                    return (Store.ValueHolder)thisEntry.getValue();
                }

                public long getCreationTime(TimeUnit unit) {
                    return ((OffHeapValueHolder)((Object)thisEntry.getValue())).creationTime(unit);
                }

                public long getLastAccessTime(TimeUnit unit) {
                    return ((OffHeapValueHolder)((Object)thisEntry.getValue())).lastAccessTime(unit);
                }

                public float getHitRate(TimeUnit unit) {
                    long now = AbstractOffHeapStore.this.timeSource.getTimeMillis();
                    return ((OffHeapValueHolder)((Object)thisEntry.getValue())).hitRate(now, unit);
                }
            };
        }
    }

    private static class OffHeapEvictionVetoWrapper<K, V>
    implements Predicate<Map.Entry<K, OffHeapValueHolder<V>>> {
        private final EvictionVeto<K, V> delegate;
        private final TimeSource timeSource;

        private OffHeapEvictionVetoWrapper(EvictionVeto<? super K, ? super V> delegate, TimeSource timeSource) {
            this.delegate = delegate;
            this.timeSource = timeSource;
        }

        public boolean test(Map.Entry<K, OffHeapValueHolder<V>> argument) {
            try {
                return this.delegate.test((Object)CacheStoreHelper.cacheEntry(argument.getKey(), (Store.ValueHolder)((Store.ValueHolder)argument.getValue()), (TimeSource)this.timeSource));
            }
            catch (Exception e) {
                LOG.error("Exception raised while running eviction veto - Eviction will assume entry is NOT vetoed", (Throwable)e);
                return false;
            }
        }
    }
}

