/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.serialization;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.internal.serialization.CompactJavaSerializer;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.FileBasedPersistenceContext;

public class CompactPersistentJavaSerializer<T>
implements Serializer<T>,
Closeable {
    private final File stateFile;
    private final CompactJavaSerializer<T> serializer;

    public CompactPersistentJavaSerializer(ClassLoader classLoader, FileBasedPersistenceContext persistence) throws IOException, ClassNotFoundException {
        this.stateFile = new File(persistence.getDirectory(), "CompactPersistentJavaSerializer.state");
        this.serializer = this.stateFile.exists() ? new CompactJavaSerializer(classLoader, CompactPersistentJavaSerializer.readSerializationMappings(this.stateFile)) : new CompactJavaSerializer(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        try {
            CompactPersistentJavaSerializer.writeSerializationMappings(this.stateFile, this.serializer.getSerializationMappings());
        }
        finally {
            this.serializer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, ObjectStreamClass> readSerializationMappings(File stateFile) throws IOException, ClassNotFoundException {
        FileInputStream fin = new FileInputStream(stateFile);
        try {
            Map map;
            ObjectInputStream oin = new ObjectInputStream(fin);
            try {
                map = (Map)oin.readObject();
            }
            catch (Throwable throwable) {
                oin.close();
                throw throwable;
            }
            oin.close();
            return map;
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSerializationMappings(File stateFile, Map<Integer, ObjectStreamClass> mappings) throws IOException {
        FileOutputStream fout = new FileOutputStream(stateFile);
        try {
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            try {
                oout.writeObject(mappings);
            }
            finally {
                oout.close();
            }
        }
        finally {
            ((OutputStream)fout).close();
        }
    }

    public ByteBuffer serialize(T object) throws SerializerException {
        return this.serializer.serialize(object);
    }

    public T read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        return this.serializer.read(binary);
    }

    public boolean equals(T object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        return this.serializer.equals(object, binary);
    }
}

