/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.executor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.config.executor.PooledExecutionServiceConfiguration;
import org.ehcache.internal.executor.OutOfBandScheduledExecutor;
import org.ehcache.internal.executor.PartitionedOrderedExecutor;
import org.ehcache.internal.executor.PartitionedScheduledExecutor;
import org.ehcache.internal.executor.PartitionedUnorderedExecutor;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.ExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledExecutionService
implements ExecutionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledExecutionService.class);
    private final String defaultPoolAlias;
    private final Map<String, PooledExecutionServiceConfiguration.PoolConfiguration> poolConfigurations;
    private final Map<String, ThreadPoolExecutor> pools = new HashMap<String, ThreadPoolExecutor>();
    private volatile boolean running = false;
    private volatile OutOfBandScheduledExecutor scheduledExecutor;

    PooledExecutionService(PooledExecutionServiceConfiguration configuration) {
        this.defaultPoolAlias = configuration.getDefaultPoolAlias();
        this.poolConfigurations = configuration.getPoolConfigurations();
    }

    public ScheduledExecutorService getScheduledExecutor(String poolAlias) {
        if (this.running) {
            ThreadPoolExecutor executor = this.pools.get(poolAlias);
            if (executor == null) {
                throw new IllegalStateException("Pool '" + poolAlias + "' is not in the set of available pools " + this.pools.keySet());
            }
            return new PartitionedScheduledExecutor(this.scheduledExecutor, this.getUnorderedExecutor(poolAlias, new LinkedBlockingQueue<Runnable>()));
        }
        throw new IllegalStateException("Service cannot be used, it isn't running");
    }

    public ExecutorService getOrderedExecutor(String poolAlias, BlockingQueue<Runnable> queue) {
        if (this.running) {
            ThreadPoolExecutor executor = this.pools.get(poolAlias);
            if (executor == null) {
                throw new IllegalStateException("Pool '" + poolAlias + "' is not in the set of available pools " + this.pools.keySet());
            }
            return new PartitionedOrderedExecutor(queue, executor);
        }
        throw new IllegalStateException("Service cannot be used, it isn't running");
    }

    public ExecutorService getUnorderedExecutor(String poolAlias, BlockingQueue<Runnable> queue) {
        if (this.running) {
            ThreadPoolExecutor executor = this.pools.get(poolAlias);
            if (executor == null) {
                throw new IllegalStateException("Pool '" + poolAlias + "' is not in the set of available pools " + this.pools.keySet());
            }
            return new PartitionedUnorderedExecutor(queue, executor, executor.getMaximumPoolSize());
        }
        throw new IllegalStateException("Service cannot be used, it isn't running");
    }

    public void start(ServiceProvider serviceProvider) {
        for (Map.Entry<String, PooledExecutionServiceConfiguration.PoolConfiguration> e : this.poolConfigurations.entrySet()) {
            this.pools.put(e.getKey(), PooledExecutionService.createPool(e.getKey(), e.getValue()));
        }
        if (this.defaultPoolAlias != null) {
            ThreadPoolExecutor defaultPool = this.pools.get(this.defaultPoolAlias);
            if (defaultPool == null) {
                throw new IllegalStateException("Pool for default pool alias is null");
            }
            this.pools.put(null, defaultPool);
        }
        this.scheduledExecutor = new OutOfBandScheduledExecutor();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.info("Shutting down PooledExecutionService");
        this.running = false;
        Iterator<Map.Entry<String, ThreadPoolExecutor>> it = this.pools.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ThreadPoolExecutor> e = it.next();
            try {
                if (e.getKey() == null) continue;
                PooledExecutionService.destroyPool(e.getKey(), e.getValue());
            }
            finally {
                it.remove();
            }
        }
    }

    private static ThreadPoolExecutor createPool(String alias, PooledExecutionServiceConfiguration.PoolConfiguration config) {
        return new ThreadPoolExecutor(config.minSize(), config.maxSize(), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), PooledExecutionService.threadFactory(alias));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void destroyPool(String alias, ThreadPoolExecutor executor) {
        List<Runnable> tasks = executor.shutdownNow();
        if (!tasks.isEmpty()) {
            LOGGER.warn("Tasks remaining in pool '{}' at shutdown: {}", (Object)alias, tasks);
        }
        boolean interrupted = false;
        while (true) {
            try {
                if (executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            catch (Throwable throwable) {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            {
                LOGGER.warn("Still waiting for termination of pool '{}'", (Object)alias);
                continue;
            }
            break;
        }
    }

    private static ThreadFactory threadFactory(final String alias) {
        return new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "[" + alias + "]-" + this.threadCount.getAndIncrement());
            }
        };
    }
}

