/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.events;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.ehcache.config.event.CacheEventDispatcherFactoryConfiguration;
import org.ehcache.events.CacheEventDispatcher;
import org.ehcache.events.CacheEventDispatcherFactory;
import org.ehcache.events.CacheEventDispatcherImpl;
import org.ehcache.events.DisabledCacheEventNotificationService;
import org.ehcache.internal.executor.ExecutorUtil;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.service.ExecutionService;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;

@ServiceDependencies(value={ExecutionService.class})
public class CacheEventDispatcherFactoryImpl
implements CacheEventDispatcherFactory {
    private final String threadPoolAlias;
    private volatile ExecutionService executionService;
    private volatile ExecutorService orderedExecutor;
    private volatile ExecutorService unorderedExecutor;

    public CacheEventDispatcherFactoryImpl() {
        this.threadPoolAlias = null;
    }

    public CacheEventDispatcherFactoryImpl(CacheEventDispatcherFactoryConfiguration configuration) {
        this.threadPoolAlias = configuration.getThreadPoolAlias();
    }

    public void start(ServiceProvider serviceProvider) {
        this.executionService = (ExecutionService)serviceProvider.getService(ExecutionService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (this.orderedExecutor != null) {
                ExecutorUtil.shutdown(this.orderedExecutor);
            }
        }
        finally {
            if (this.unorderedExecutor != null) {
                ExecutorUtil.shutdown(this.unorderedExecutor);
            }
        }
    }

    public <K, V> CacheEventDispatcher<K, V> createCacheEventDispatcher(Store<K, V> store, ServiceConfiguration<?> ... serviceConfigs) {
        if (this.getOrderedExecutor() == null || this.getUnorderedExecutor() == null) {
            return new DisabledCacheEventNotificationService();
        }
        return new CacheEventDispatcherImpl(this.getOrderedExecutor(), this.getUnorderedExecutor(), store);
    }

    public <K, V> void releaseCacheEventDispatcher(CacheEventDispatcher<K, V> cenlService) {
        if (cenlService != null) {
            cenlService.releaseAllListeners();
        }
    }

    private synchronized ExecutorService getOrderedExecutor() {
        if (this.orderedExecutor == null) {
            this.orderedExecutor = this.executionService.getOrderedExecutor(this.threadPoolAlias, new LinkedBlockingQueue());
        }
        return this.orderedExecutor;
    }

    private synchronized ExecutorService getUnorderedExecutor() {
        if (this.unorderedExecutor == null) {
            this.unorderedExecutor = this.executionService.getUnorderedExecutor(this.threadPoolAlias, new LinkedBlockingQueue());
        }
        return this.unorderedExecutor;
    }
}

