/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.copy;

import org.ehcache.config.copy.CopierConfiguration;
import org.ehcache.config.copy.DefaultCopierConfiguration;
import org.ehcache.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.copy.CopyProvider;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class DefaultCopyProviderConfiguration
extends ClassInstanceProviderConfiguration<Class<?>, Copier<?>>
implements ServiceCreationConfiguration<CopyProvider> {
    public Class<CopyProvider> getServiceType() {
        return CopyProvider.class;
    }

    public <T> DefaultCopyProviderConfiguration addCopierFor(Class<T> clazz, Class<? extends Copier<T>> copierClass) {
        if (clazz == null) {
            throw new NullPointerException("Copy target class cannot be null");
        }
        if (copierClass == null) {
            throw new NullPointerException("Copier class cannot be null");
        }
        if (this.getDefaults().containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate copier for class : " + clazz);
        }
        this.getDefaults().put(clazz, new DefaultCopierConfiguration(copierClass, CopierConfiguration.Type.KEY));
        this.getDefaults().put(clazz, new DefaultCopierConfiguration(copierClass, CopierConfiguration.Type.VALUE));
        return this;
    }
}

