/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.CacheConfigurationChangeListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.internal.store.tiering.CompoundCachingTierServiceConfiguration;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.cache.tiering.LowerCachingTier;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.SupplementaryService;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundCachingTier<K, V>
implements CachingTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompoundCachingTier.class);
    private final CachingTier<K, V> higher;
    private final LowerCachingTier<K, V> lower;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;

    public CompoundCachingTier(CachingTier<K, V> higher, final LowerCachingTier<K, V> lower) {
        this.higher = higher;
        this.lower = lower;
        this.higher.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            public void onInvalidation(K key, final Store.ValueHolder<V> valueHolder) {
                try {
                    CompoundCachingTier.this.lower.getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                        public Store.ValueHolder<V> apply(K k) {
                            return valueHolder;
                        }
                    });
                }
                catch (CacheAccessException cae) {
                    CompoundCachingTier.this.notifyInvalidation(key, valueHolder);
                    LOGGER.warn("Error overflowing '{}' into lower caching tier {}", new Object[]{key, lower, cae});
                }
            }
        });
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(K key, final Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
        try {
            return this.higher.getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                public Store.ValueHolder<V> apply(K k) {
                    try {
                        Store.ValueHolder valueHolder = CompoundCachingTier.this.lower.getAndRemove(k);
                        if (valueHolder != null) {
                            return valueHolder;
                        }
                        return (Store.ValueHolder)source.apply(k);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    public void invalidate(final K key) throws CacheAccessException {
        try {
            this.higher.invalidate(key, new NullaryFunction<K>(){

                public K apply() {
                    try {
                        CompoundCachingTier.this.lower.invalidate(key);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                    return null;
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    public void invalidate(final K key, final NullaryFunction<K> function) throws CacheAccessException {
        try {
            this.higher.invalidate(key, new NullaryFunction<K>(){

                public K apply() {
                    try {
                        CompoundCachingTier.this.lower.invalidate(key, function);
                    }
                    catch (CacheAccessException cae) {
                        throw new ComputationException(cae);
                    }
                    return null;
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getCacheAccessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws CacheAccessException {
        try {
            this.higher.clear();
        }
        finally {
            this.lower.clear();
        }
    }

    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.lower.setInvalidationListener(invalidationListener);
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> listeners = new ArrayList<CacheConfigurationChangeListener>();
        listeners.addAll(this.higher.getConfigurationChangeListeners());
        listeners.addAll(this.lower.getConfigurationChangeListeners());
        return listeners;
    }

    @SupplementaryService
    public static class Provider
    implements CachingTier.Provider {
        private volatile ServiceProvider serviceProvider;
        private final ConcurrentMap<CachingTier<?, ?>, Map.Entry<CachingTier.Provider, LowerCachingTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new RuntimeException("ServiceProvider is null.");
            }
            CompoundCachingTierServiceConfiguration compoundCachingTierServiceConfiguration = (CompoundCachingTierServiceConfiguration)ServiceLocator.findSingletonAmongst(CompoundCachingTierServiceConfiguration.class, (Object[])serviceConfigs);
            if (compoundCachingTierServiceConfiguration == null) {
                throw new IllegalArgumentException("Compound caching tier cannot be configured without explicit config");
            }
            CachingTier.Provider higherProvider = (CachingTier.Provider)this.serviceProvider.getService(compoundCachingTierServiceConfiguration.higherProvider());
            CachingTier higherCachingTier = higherProvider.createCachingTier(storeConfig, serviceConfigs);
            LowerCachingTier.Provider lowerProvider = (LowerCachingTier.Provider)this.serviceProvider.getService(compoundCachingTierServiceConfiguration.lowerProvider());
            LowerCachingTier lowerCachingTier = lowerProvider.createCachingTier(storeConfig, serviceConfigs);
            CompoundCachingTier compoundCachingTier = new CompoundCachingTier(higherCachingTier, lowerCachingTier);
            this.providersMap.put(compoundCachingTier, new AbstractMap.SimpleEntry<CachingTier.Provider, LowerCachingTier.Provider>(higherProvider, lowerProvider));
            return compoundCachingTier;
        }

        public void releaseCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((CachingTier.Provider)entry.getKey()).releaseCachingTier(compoundCachingTier.higher);
            ((LowerCachingTier.Provider)entry.getValue()).releaseCachingTier(compoundCachingTier.lower);
        }

        public void initCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((LowerCachingTier.Provider)entry.getValue()).initCachingTier(compoundCachingTier.lower);
            ((CachingTier.Provider)entry.getKey()).initCachingTier(compoundCachingTier.higher);
        }

        public void start(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(CacheAccessException cause) {
            super(cause);
        }

        public CacheAccessException getCacheAccessException() {
            return (CacheAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

