/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.offheap.portability;

import java.nio.ByteBuffer;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.spi.serialization.Serializer;
import org.terracotta.offheapstore.storage.portability.WriteBackPortability;
import org.terracotta.offheapstore.storage.portability.WriteContext;

public class OffHeapValueHolderPortability<V>
implements WriteBackPortability<OffHeapValueHolder<V>> {
    public static final int ACCESS_TIME_OFFSET = 16;
    public static final int EXPIRE_TIME_OFFSET = 24;
    public static final int HITS_OFFSET = 32;
    private static final int FIELDS_OVERHEAD = 40;
    private final Serializer<V> serializer;

    public OffHeapValueHolderPortability(Serializer<V> serializer) {
        this.serializer = serializer;
    }

    public ByteBuffer encode(OffHeapValueHolder<V> valueHolder) {
        ByteBuffer serialized = this.serializer.serialize(valueHolder.value());
        ByteBuffer byteBuffer = ByteBuffer.allocate(serialized.remaining() + 40);
        byteBuffer.putLong(valueHolder.getId());
        byteBuffer.putLong(valueHolder.creationTime(OffHeapValueHolder.TIME_UNIT));
        byteBuffer.putLong(valueHolder.lastAccessTime(OffHeapValueHolder.TIME_UNIT));
        byteBuffer.putLong(valueHolder.expirationTime(OffHeapValueHolder.TIME_UNIT));
        byteBuffer.putLong(valueHolder.hits());
        byteBuffer.put(serialized);
        byteBuffer.flip();
        return byteBuffer;
    }

    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer) {
        return this.decode(byteBuffer, null);
    }

    public boolean equals(Object o, ByteBuffer byteBuffer) {
        return o.equals(this.decode(byteBuffer));
    }

    public OffHeapValueHolder<V> decode(ByteBuffer byteBuffer, WriteContext writeContext) {
        try {
            long id = byteBuffer.getLong();
            long creationTime = byteBuffer.getLong();
            long lastAccessTime = byteBuffer.getLong();
            long expireTime = byteBuffer.getLong();
            long hits = byteBuffer.getLong();
            OffHeapValueHolder<Object> valueHolder = new OffHeapValueHolder<Object>(id, this.serializer.read(byteBuffer), creationTime, expireTime, lastAccessTime, hits, writeContext);
            return valueHolder;
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException((Throwable)e);
        }
    }
}

