/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.disk.factories;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.Predicate;
import org.ehcache.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.terracotta.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.disk.persistent.PersistentStorageEngine;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.util.Factory;

public class EhcachePersistentSegmentFactory<K, V>
implements Factory<PinnableSegment<K, V>> {
    private final Factory<? extends PersistentStorageEngine<? super K, ? super V>> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final Predicate<Map.Entry<K, V>> evictionVeto;
    private final EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener;
    private final boolean bootstrap;

    public EhcachePersistentSegmentFactory(MappedPageSource source, Factory<? extends PersistentStorageEngine<? super K, ? super V>> storageEngineFactory, int initialTableSize, Predicate<Map.Entry<K, V>> evictionVeto, EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener, boolean bootstrap) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.evictionVeto = evictionVeto;
        this.evictionListener = evictionListener;
        this.bootstrap = bootstrap;
    }

    public EhcachePersistentSegment<K, V> newInstance() {
        PersistentStorageEngine storageEngine = (PersistentStorageEngine)this.storageEngineFactory.newInstance();
        try {
            return new EhcachePersistentSegment<K, V>(this.tableSource, storageEngine, this.tableSize, this.bootstrap, this.evictionVeto, this.evictionListener);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcachePersistentSegment<K, V>
    extends PersistentReadWriteLockedOffHeapClockCache<K, V> {
        private final Predicate<Map.Entry<K, V>> evictionVeto;
        private final EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener;

        EhcachePersistentSegment(MappedPageSource source, PersistentStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap, Predicate<Map.Entry<K, V>> evictionVeto, EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener) {
            super(source, storageEngine, tableSize, bootstrap);
            this.evictionVeto = evictionVeto;
            this.evictionListener = evictionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V compute(K key, BiFunction<K, V, V> mappingFunction, boolean pin) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Object value = this.get(key);
                Object newValue = mappingFunction.apply(key, value);
                if (newValue != null) {
                    if (newValue != value) {
                        this.put(key, newValue);
                    }
                    if (pin) {
                        this.setPinning(key, true);
                    }
                } else {
                    this.remove(key);
                }
                Object object = newValue;
                return (V)object;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V computeIfPresent(K key, BiFunction<K, V, V> mappingFunction) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Object value = this.get(key);
                if (value != null) {
                    Object newValue = mappingFunction.apply(key, value);
                    if (newValue != value) {
                        if (newValue != null) {
                            this.put(key, newValue);
                        } else {
                            this.remove(key);
                        }
                    }
                    Object object = newValue;
                    return (V)object;
                }
                V v = null;
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean computeIfPinned(K key, BiFunction<K, V, V> remappingFunction, Function<V, Boolean> flippingPinningBitFunction) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                if (this.isPinned(key)) {
                    Object previousValue = this.get(key);
                    Object newValue = remappingFunction.apply(key, previousValue);
                    if (newValue != previousValue) {
                        if (newValue == null) {
                            this.remove(key);
                        } else {
                            this.put(key, newValue);
                        }
                    }
                    if (((Boolean)flippingPinningBitFunction.apply(previousValue)).booleanValue()) {
                        this.getAndSetMetadata(key, 0x40000000, 0);
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        public V put(K key, V value) {
            int metadata = this.getVetoedStatus(key, value);
            return (V)this.put(key, value, metadata);
        }

        private int getVetoedStatus(K key, V value) {
            return this.evictionVeto.test(new AbstractMap.SimpleImmutableEntry<K, V>(key, value)) ? 0x20000000 : 0;
        }

        public V putPinned(K key, V value) {
            int metadata = this.getVetoedStatus(key, value) | 0x40000000;
            return (V)this.put(key, value, metadata);
        }

        protected boolean evictable(int status) {
            return super.evictable(status) && (status & 0x20000000) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evict(int index, boolean shrink) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Map.Entry entry = this.getEntryAtTableOffset(index);
                boolean evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.onEviction(entry.getKey(), entry.getValue());
                }
                boolean bl = evicted;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

