/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.classes;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.internal.classes.ClassInstanceConfiguration;
import org.ehcache.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.internal.classes.commonslang.reflect.ConstructorUtils;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.ServiceConfiguration;

public class ClassInstanceProvider<T> {
    protected final Map<String, ClassInstanceConfiguration<T>> preconfiguredLoaders = Collections.synchronizedMap(new LinkedHashMap());
    private final Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig;

    protected ClassInstanceProvider(ClassInstanceProviderConfiguration<T> factoryConfig, Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig) {
        if (factoryConfig != null) {
            this.preconfiguredLoaders.putAll(factoryConfig.getDefaults());
        }
        this.cacheLevelConfig = cacheLevelConfig;
    }

    protected ClassInstanceConfiguration<T> getPreconfigured(String alias) {
        return this.preconfiguredLoaders.get(alias);
    }

    protected T newInstance(String alias, CacheConfiguration<?, ?> cacheConfiguration) {
        ClassInstanceConfiguration<T> config = null;
        for (ServiceConfiguration serviceConfiguration : cacheConfiguration.getServiceConfigurations()) {
            if (!this.cacheLevelConfig.isAssignableFrom(serviceConfiguration.getClass())) continue;
            config = this.cacheLevelConfig.cast(serviceConfiguration);
        }
        return this.newInstance(alias, config);
    }

    protected T newInstance(String alias, ServiceConfiguration<?> serviceConfiguration) {
        ClassInstanceConfiguration<T> config = null;
        if (serviceConfiguration != null && this.cacheLevelConfig.isAssignableFrom(serviceConfiguration.getClass())) {
            config = this.cacheLevelConfig.cast(serviceConfiguration);
        }
        return this.newInstance(alias, config);
    }

    private T newInstance(String alias, ClassInstanceConfiguration<T> config) {
        if (config == null && (config = this.getPreconfigured(alias)) == null) {
            return null;
        }
        try {
            return ConstructorUtils.invokeConstructor(config.getClazz(), config.getArguments());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(ServiceProvider serviceProvider) {
    }

    public void stop() {
    }
}

