/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.serializer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class DefaultSerializationProviderConfiguration
implements ServiceCreationConfiguration<SerializationProvider> {
    private final Map<String, Class<? extends Serializer<?>>> transientSerializers = new LinkedHashMap();
    private final Map<String, Class<? extends Serializer<?>>> persistentSerializers = new LinkedHashMap();

    public Class<SerializationProvider> getServiceType() {
        return SerializationProvider.class;
    }

    public <T> DefaultSerializationProviderConfiguration addSerializerFor(Class<T> serializableClass, Class<? extends Serializer<T>> serializerClass) {
        if (serializableClass == null) {
            throw new NullPointerException("Serializable class cannot be null");
        }
        if (serializerClass == null) {
            throw new NullPointerException("Serializer class cannot be null");
        }
        String alias = serializableClass.getName();
        if (serializerClass.isAnnotationPresent(Serializer.Transient.class)) {
            if (serializerClass.isAnnotationPresent(Serializer.Persistent.class)) {
                if (this.transientSerializers.containsKey(alias)) {
                    if (this.persistentSerializers.containsKey(alias)) {
                        throw new IllegalArgumentException("Duplicate transient & persistent serializer for class : " + alias);
                    }
                    this.persistentSerializers.put(alias, serializerClass);
                } else if (this.persistentSerializers.containsKey(alias)) {
                    this.transientSerializers.put(alias, serializerClass);
                } else {
                    this.persistentSerializers.put(alias, serializerClass);
                    this.transientSerializers.put(alias, serializerClass);
                }
            } else {
                if (this.transientSerializers.containsKey(alias)) {
                    throw new IllegalArgumentException("Duplicate transient serializer for class : " + alias);
                }
                this.transientSerializers.put(alias, serializerClass);
            }
        } else if (serializerClass.isAnnotationPresent(Serializer.Persistent.class)) {
            if (this.persistentSerializers.containsKey(alias)) {
                throw new IllegalArgumentException("Duplicate persistent serializer for class : " + alias);
            }
            this.persistentSerializers.put(alias, serializerClass);
        } else {
            throw new IllegalArgumentException("Serializer class '" + serializerClass + "' does not identify as persistent or transient.");
        }
        return this;
    }

    public Map<String, Class<? extends Serializer<?>>> getTransientSerializers() {
        return Collections.unmodifiableMap(this.transientSerializers);
    }

    public Map<String, Class<? extends Serializer<?>>> getPersistentSerializers() {
        return Collections.unmodifiableMap(this.persistentSerializers);
    }
}

