/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.loaderwriter.writebehind.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ehcache.loaderwriter.writebehind.operations.BatchOperation;
import org.ehcache.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.loaderwriter.writebehind.operations.SingleOperationType;
import org.ehcache.loaderwriter.writebehind.operations.WriteAllOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;

public class WriteOperation<K, V>
implements SingleOperation<K, V> {
    private final K key;
    private final V value;
    private final long creationTime;

    public WriteOperation(K k, V v) {
        this(k, v, System.nanoTime());
    }

    public WriteOperation(K k, V v, long creationTime) {
        this.key = k;
        this.value = v;
        this.creationTime = creationTime;
    }

    @Override
    public void performSingleOperation(CacheLoaderWriter<K, V> cacheWriter) throws Exception {
        cacheWriter.write(this.key, this.value);
    }

    @Override
    public BatchOperation<K, V> createBatchOperation(List<SingleOperation<K, V>> operations) {
        ArrayList<1> entries = new ArrayList<1>();
        for (final SingleOperation<K, V> operation : operations) {
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return ((WriteOperation)operation).key;
                }

                @Override
                public V getValue() {
                    return ((WriteOperation)operation).value;
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException("Not Supported.");
                }
            });
        }
        return new WriteAllOperation(entries);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public SingleOperationType getType() {
        return SingleOperationType.WRITE;
    }

    public int hashCode() {
        int hash = (int)this.getCreationTime();
        hash = hash * 31 + this.getKey().hashCode();
        return hash;
    }

    public boolean equals(Object other) {
        if (other instanceof WriteOperation) {
            return this.getCreationTime() == ((WriteOperation)other).getCreationTime() && this.getKey().equals(((WriteOperation)other).getKey());
        }
        return false;
    }
}

