/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.loaderwriter.writebehind;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ehcache.exceptions.CacheWritingException;
import org.ehcache.loaderwriter.writebehind.LocalHeapWriteBehindQueue;
import org.ehcache.loaderwriter.writebehind.WriteBehind;
import org.ehcache.loaderwriter.writebehind.operations.OperationsFilter;
import org.ehcache.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;

public class AggregateWriteBehindQueue<K, V>
implements WriteBehind<K, V> {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
    private final List<WriteBehind<K, V>> queues = new ArrayList<WriteBehind<K, V>>();

    protected AggregateWriteBehindQueue(WriteBehindConfiguration config, WriteBehindQueueFactory<K, V> queueFactory, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        int writeBehindConcurrency = config.getWriteBehindConcurrency();
        for (int i = 0; i < writeBehindConcurrency; ++i) {
            this.queues.add(queueFactory.createQueue(i, config, cacheLoaderWriter));
        }
    }

    public AggregateWriteBehindQueue(WriteBehindConfiguration config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        this(config, new WriteBehindQueueFactory(), cacheLoaderWriter);
    }

    private WriteBehind<K, V> getQueue(Object key) {
        return this.queues.get(Math.abs(key.hashCode() % this.queues.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.writeLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.queues) {
                queue.start();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V load(K key) throws Exception {
        V v = null;
        this.readLock.lock();
        try {
            v = this.getQueue(key).load(key);
        }
        finally {
            this.readLock.unlock();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(K key, V value) throws CacheWritingException {
        this.readLock.lock();
        try {
            this.getQueue(key).write(key, value);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(K key) throws CacheWritingException {
        this.readLock.lock();
        try {
            this.getQueue(key).delete(key);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.writeLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.queues) {
                queue.stop();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOperationsFilter(OperationsFilter<SingleOperation<K, V>> filter) {
        this.readLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.queues) {
                queue.setOperationsFilter(filter);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getQueueSize() {
        int size = 0;
        this.readLock.lock();
        try {
            for (WriteBehind<K, V> queue : this.queues) {
                size = (int)((long)size + queue.getQueueSize());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return size;
    }

    protected static class WriteBehindQueueFactory<K, V> {
        protected WriteBehindQueueFactory() {
        }

        protected WriteBehind<K, V> createQueue(int index, WriteBehindConfiguration config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
            return new LocalHeapWriteBehindQueue<K, V>(config, cacheLoaderWriter);
        }
    }
}

