/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.heap;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.CacheConfigurationChangeEvent;
import org.ehcache.CacheConfigurationChangeListener;
import org.ehcache.CacheConfigurationProperty;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionPrioritizer;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.events.CacheEvents;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceService;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.internal.store.heap.ByRefOnHeapValueHolder;
import org.ehcache.internal.store.heap.ByValueOnHeapValueHolder;
import org.ehcache.internal.store.heap.LookupOnlyOnHeapKey;
import org.ehcache.internal.store.heap.OnHeapKey;
import org.ehcache.internal.store.heap.OnHeapValueHolder;
import org.ehcache.internal.store.heap.SerializedOnHeapKey;
import org.ehcache.internal.store.heap.service.OnHeapStoreServiceConfiguration;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.CacheStoreHelper;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.statistics.StoreOperationOutcomes;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public class OnHeapStore<K, V>
implements Store<K, V>,
CachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(OnHeapStore.class);
    private static final int ATTEMPT_RATIO = 4;
    private static final int EVICTION_RATIO = 2;
    static final int SAMPLE_SIZE = 8;
    private final MapWrapper<K, V> map;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Serializer<V> valueSerializer;
    private final Serializer<K> keySerializer;
    private volatile long capacity;
    private final Predicate<? extends Map.Entry<? super K, ? extends OnHeapValueHolder<? super V>>> evictionVeto;
    private final Comparator<? extends Map.Entry<? super K, ? extends OnHeapValueHolder<? super V>>> evictionPrioritizer;
    private final Expiry<? super K, ? super V> expiry;
    private final TimeSource timeSource;
    private volatile StoreEventListener<K, V> eventListener = CacheEvents.nullStoreEventListener();
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;
    private CacheConfigurationChangeListener cacheConfigurationChangeListener = new CacheConfigurationChangeListener(){

        public void cacheConfigurationChange(CacheConfigurationChangeEvent event) {
            if (event.getProperty().equals((Object)CacheConfigurationProperty.UPDATESIZE)) {
                ResourcePools updatedPools = (ResourcePools)event.getNewValue();
                ResourcePools configuredPools = (ResourcePools)event.getOldValue();
                if (updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize() != configuredPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize()) {
                    LOG.info("Setting size: " + updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize());
                    OnHeapStore.this.capacity = updatedPools.getPoolForResource((ResourceType)ResourceType.Core.HEAP).getSize();
                }
            }
        }
    };
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).named("eviction")).of((Object)this)).tag(new String[]{"onheap-store"})).build();
    private final OnHeapStoreStatsSettings onHeapStoreStatsSettings;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public OnHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, boolean storeByValue, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ResourcePool heapPool = config.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        if (heapPool == null) {
            throw new IllegalArgumentException("OnHeap store must be configured with a resource of type 'heap'");
        }
        if (!heapPool.getUnit().equals(EntryUnit.ENTRIES)) {
            throw new IllegalArgumentException("OnHeap store only handles resource unit 'entries'");
        }
        this.capacity = heapPool.getSize();
        EvictionPrioritizer prioritizer = config.getEvictionPrioritizer();
        if (prioritizer == null) {
            prioritizer = Eviction.Prioritizer.LRU;
        }
        this.timeSource = timeSource;
        this.evictionVeto = OnHeapStore.wrap(config.getEvictionVeto(), timeSource);
        this.evictionPrioritizer = OnHeapStore.wrap(prioritizer, timeSource);
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.expiry = config.getExpiry();
        if (storeByValue) {
            this.valueSerializer = valueSerializer;
            this.keySerializer = keySerializer;
        } else {
            this.valueSerializer = null;
            this.keySerializer = null;
        }
        this.map = new MapWrapper(this.keySerializer);
        this.onHeapStoreStatsSettings = new OnHeapStoreStatsSettings(this);
        StatisticsManager.associate((Object)this.onHeapStoreStatsSettings).withParent((Object)this);
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, true);
    }

    private OnHeapValueHolder<V> internalGet(final K key, final boolean updateAccess) throws CacheAccessException {
        return this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                long now = OnHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    return null;
                }
                if (updateAccess) {
                    OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                }
                return mappedValue;
            }
        });
    }

    public boolean containsKey(K key) throws CacheAccessException {
        this.checkKey(key);
        return this.internalGet(key, false) != null;
    }

    public void put(K key, V value) throws CacheAccessException {
        this.putReturnHolder(key, value);
    }

    private OnHeapValueHolder<V> putReturnHolder(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        OnHeapValueHolder<V> valuePut = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                entryActuallyAdded.set(mappedValue == null);
                if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    mappedValue = null;
                }
                if (mappedValue == null) {
                    return OnHeapStore.this.newCreateValueHolder(key, value, now);
                }
                return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now);
            }
        });
        if (entryActuallyAdded.get()) {
            this.enforceCapacity(1);
        }
        return valuePut;
    }

    public void remove(K key) throws CacheAccessException {
        this.checkKey(key);
        this.map.remove(key);
    }

    OnHeapValueHolder<V> putIfAbsentReturnHolder(K key, V value) throws CacheAccessException {
        return this.putIfAbsent(key, value, true);
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws CacheAccessException {
        return this.putIfAbsent(key, value, false);
    }

    private OnHeapValueHolder<V> putIfAbsent(final K key, final V value, boolean returnInCacheHolder) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        final long now = this.timeSource.getTimeMillis();
        OnHeapValueHolder<V> inCache = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    if (mappedValue != null) {
                        OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    entryActuallyAdded.set(true);
                    return OnHeapStore.this.newCreateValueHolder(key, value, now);
                }
                returnValue.set(mappedValue);
                OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        });
        if (entryActuallyAdded.get()) {
            this.enforceCapacity(1);
        }
        if (returnInCacheHolder) {
            return inCache;
        }
        return returnValue.get();
    }

    public boolean remove(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                long now = OnHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    return null;
                }
                if (value.equals(mappedValue.value())) {
                    removed.set(true);
                    return null;
                }
                OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        });
        return removed.get();
    }

    public Store.ValueHolder<V> replace(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                long now = OnHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    return null;
                }
                returnValue.set(mappedValue);
                return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, value, now);
            }
        });
        return returnValue.get();
    }

    public boolean replace(final K key, final V oldValue, final V newValue) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        final AtomicBoolean returnValue = new AtomicBoolean(false);
        this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                long now = OnHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    return null;
                }
                if (oldValue.equals(mappedValue.value())) {
                    returnValue.set(true);
                    return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, newValue, now);
                }
                OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        });
        return returnValue.get();
    }

    public void clear() throws CacheAccessException {
        this.map.clear();
    }

    private void invalidate() {
        if (((MapWrapper)this.map).map != null) {
            for (Object k : ((MapWrapper)this.map).map.keySet()) {
                try {
                    this.invalidate(k);
                }
                catch (CacheAccessException cae) {
                    LOG.warn("Failed to invalidate mapping for key {}", k, (Object)cae);
                }
            }
        }
        if (((MapWrapper)this.map).keyCopyMap != null) {
            for (OnHeapKey key : ((MapWrapper)this.map).keyCopyMap.keySet()) {
                try {
                    this.invalidate(key.getActualKeyObject());
                }
                catch (CacheAccessException cae) {
                    LOG.warn("Failed to invalidate mapping for key {}", (Object)key, (Object)cae);
                }
            }
        }
        this.map.clear();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() throws CacheAccessException {
        final Iterator<Map.Entry<K, OnHeapValueHolder<V>>> it = this.map.entrySetIterator();
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private Map.Entry<K, OnHeapValueHolder<V>> next = null;
            {
                this.advance();
            }

            private void advance() {
                this.next = null;
                while (this.next == null && it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    long now = OnHeapStore.this.timeSource.getTimeMillis();
                    if (((OnHeapValueHolder)((Object)entry.getValue())).isExpired(now, TimeUnit.MILLISECONDS)) {
                        it.remove();
                        OnHeapStore.this.eventListener.onExpiration(entry.getKey(), (Store.ValueHolder)entry.getValue());
                        continue;
                    }
                    this.next = entry;
                }
            }

            public boolean hasNext() throws CacheAccessException {
                return this.next != null;
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                final Map.Entry thisEntry = this.next;
                this.advance();
                OnHeapStore.this.setAccessTimeAndExpiry(thisEntry.getKey(), thisEntry.getValue(), OnHeapStore.this.timeSource.getTimeMillis());
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return thisEntry.getKey();
                    }

                    public Store.ValueHolder<V> getValue() {
                        return (Store.ValueHolder)thisEntry.getValue();
                    }

                    public long getCreationTime(TimeUnit unit) {
                        return ((OnHeapValueHolder)((Object)thisEntry.getValue())).creationTime(unit);
                    }

                    public long getLastAccessTime(TimeUnit unit) {
                        return ((OnHeapValueHolder)((Object)thisEntry.getValue())).lastAccessTime(unit);
                    }

                    public float getHitRate(TimeUnit unit) {
                        long now = OnHeapStore.this.timeSource.getTimeMillis();
                        return ((OnHeapValueHolder)((Object)thisEntry.getValue())).hitRate(now, unit);
                    }
                };
            }
        };
    }

    public Store.ValueHolder<V> getOrComputeIfAbsent(final K key, final Function<K, Store.ValueHolder<V>> source) throws CacheAccessException {
        Fault fault;
        MapWrapper<K, V> backEnd = this.map;
        OnHeapValueHolder<V> cachedValue = backEnd.get(key);
        long now = this.timeSource.getTimeMillis();
        if (cachedValue == null && (cachedValue = backEnd.putIfAbsent(key, fault = new Fault(new NullaryFunction<Store.ValueHolder<V>>(){

            public Store.ValueHolder<V> apply() {
                return (Store.ValueHolder)source.apply(key);
            }
        }))) == null) {
            this.enforceCapacity(1);
            try {
                Store.ValueHolder value = fault.get();
                if (value == null) {
                    backEnd.remove(key, fault);
                    return null;
                }
                OnHeapValueHolder newValue = this.valueSerializer != null ? new ByValueOnHeapValueHolder<V>(value, this.valueSerializer) : new ByRefOnHeapValueHolder(value);
                newValue.accessed(now, this.expiry.getExpiryForAccess(key, value.value()));
                if (backEnd.replace(key, fault, newValue)) {
                    return this.getValue((Object)newValue);
                }
                Store.ValueHolder<V> p = this.getValue(backEnd.remove(key));
                if (p != null) {
                    this.notifyInvalidation(key, p);
                    if (p.isExpired(now, TimeUnit.MILLISECONDS)) {
                        return null;
                    }
                    return p;
                }
                return newValue;
            }
            catch (Throwable e) {
                backEnd.remove(key, fault);
                throw new CacheAccessException(e);
            }
        }
        if (cachedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
            if (backEnd.remove(key, cachedValue)) {
                this.eventListener.onExpiration(key, cachedValue);
            }
            return null;
        }
        this.setAccessTimeAndExpiry(key, cachedValue, now);
        return this.getValue(cachedValue);
    }

    public void invalidate(final K key) throws CacheAccessException {
        this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> present) {
                OnHeapStore.this.notifyInvalidation(key, OnHeapStore.this.getValue(present));
                return null;
            }
        });
    }

    public void invalidate(K key, final NullaryFunction<K> function) throws CacheAccessException {
        this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K k, OnHeapValueHolder<V> onHeapValueHolder) {
                if (onHeapValueHolder != null) {
                    OnHeapStore.this.notifyInvalidation(k, onHeapValueHolder);
                }
                function.apply();
                return null;
            }
        });
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public void setInvalidationListener(final CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.eventListener = new StoreEventListener<K, V>(){

            public void onEviction(K key, Store.ValueHolder<V> valueHolder) {
                invalidationListener.onInvalidation(key, valueHolder);
            }

            public void onExpiration(K key, Store.ValueHolder<V> valueHolder) {
                invalidationListener.onInvalidation(key, valueHolder);
            }
        };
    }

    private Store.ValueHolder<V> getValue(Object cachedValue) {
        if (cachedValue instanceof Fault) {
            return ((Fault)((Object)cachedValue)).get();
        }
        return (Store.ValueHolder)cachedValue;
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        final long now = this.timeSource.getTimeMillis();
        OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                Object existingValue;
                Object computedValue;
                if (mappedValue != null && mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    mappedValue = null;
                }
                if ((computedValue = mappingFunction.apply(mappedKey, existingValue = mappedValue == null ? null : mappedValue.value())) == null) {
                    return null;
                }
                if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    if (mappedValue != null) {
                        OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                    }
                    return mappedValue;
                }
                OnHeapStore.this.checkValue(computedValue);
                if (mappedValue != null) {
                    return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, computedValue, now);
                }
                return OnHeapStore.this.newCreateValueHolder(key, computedValue, now);
            }
        });
        return this.enforceCapacityIfValueNotNull(computeResult);
    }

    public Store.ValueHolder<V> computeIfAbsent(final K key, final Function<? super K, ? extends V> mappingFunction) {
        this.checkKey(key);
        final long now = this.timeSource.getTimeMillis();
        OnHeapValueHolder<V> computeResult = this.map.compute(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                if (mappedValue == null || mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    Object computedValue;
                    if (mappedValue != null) {
                        OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    }
                    if ((computedValue = mappingFunction.apply(mappedKey)) == null) {
                        return null;
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    return OnHeapStore.this.newCreateValueHolder(key, computedValue, now);
                }
                OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        });
        return this.enforceCapacityIfValueNotNull(computeResult);
    }

    Store.ValueHolder<V> enforceCapacityIfValueNotNull(OnHeapValueHolder<V> computeResult) {
        if (computeResult != null) {
            this.enforceCapacity(1);
        }
        return computeResult;
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(final K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) {
        this.checkKey(key);
        return this.map.computeIfPresent(key, new BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

            public OnHeapValueHolder<V> apply(K mappedKey, OnHeapValueHolder<V> mappedValue) {
                long now = OnHeapStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now, TimeUnit.MILLISECONDS)) {
                    OnHeapStore.this.eventListener.onExpiration(mappedKey, mappedValue);
                    return null;
                }
                Object computedValue = remappingFunction.apply(mappedKey, mappedValue.value());
                if (computedValue == null) {
                    return null;
                }
                Object existingValue = mappedValue.value();
                if (OnHeapStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    OnHeapStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                    return mappedValue;
                }
                OnHeapStore.this.checkValue(computedValue);
                return OnHeapStore.this.newUpdateValueHolder(key, mappedValue, computedValue, now);
            }
        });
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            Store.ValueHolder<V> newValue = this.computeIfAbsent(key, new Function<K, V>(){

                public V apply(K k) {
                    Set keySet = Collections.singleton(k);
                    Iterable entries = (Iterable)mappingFunction.apply(keySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object computedKey = next.getKey();
                    Object computedValue = next.getValue();
                    OnHeapStore.this.checkKey(computedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    OnHeapStore.this.checkValue(computedValue);
                    return computedValue;
                }
            });
            result.put(key, newValue);
        }
        return result;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(this.cacheConfigurationChangeListener);
        return configurationChangeListenerList;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Store.ValueHolder<V> newValue = this.compute(key, new BiFunction<K, V, V>(){

                public V apply(K k, V oldValue) {
                    Set entrySet = Collections.singletonMap(k, oldValue).entrySet();
                    Iterable entries = (Iterable)remappingFunction.apply(entrySet);
                    Iterator iterator = entries.iterator();
                    Map.Entry next = (Map.Entry)iterator.next();
                    Object key = next.getKey();
                    Object value = next.getValue();
                    OnHeapStore.this.checkKey(key);
                    if (value != null) {
                        OnHeapStore.this.checkValue(value);
                    }
                    return value;
                }
            }, replaceEqual);
            result.put(key, newValue);
        }
        return result;
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
        this.eventListener = listener;
    }

    public void disableStoreEventNotifications() {
        this.eventListener = CacheEvents.nullStoreEventListener();
    }

    private void setAccessTimeAndExpiry(K key, OnHeapValueHolder<V> valueHolder, long now) {
        valueHolder.accessed(now, this.expiry.getExpiryForAccess(key, valueHolder.value()));
    }

    private OnHeapValueHolder<V> newUpdateValueHolder(K key, OnHeapValueHolder<V> oldValue, V newValue, long now) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Duration duration = this.expiry.getExpiryForUpdate(key, oldValue.value(), newValue);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        long expirationTime = duration == null ? oldValue.expirationTime(OnHeapValueHolder.TIME_UNIT) : (duration.isForever() ? -1L : OnHeapStore.safeExpireTime(now, duration));
        if (this.valueSerializer != null) {
            return new ByValueOnHeapValueHolder<V>(newValue, now, expirationTime, this.valueSerializer);
        }
        return new ByRefOnHeapValueHolder<V>(newValue, now, expirationTime);
    }

    private OnHeapValueHolder<V> newCreateValueHolder(K key, V value, long now) {
        long expirationTime;
        if (value == null) {
            throw new NullPointerException();
        }
        Duration duration = this.expiry.getExpiryForCreation(key, value);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        long l = expirationTime = duration.isForever() ? -1L : OnHeapStore.safeExpireTime(now, duration);
        if (this.valueSerializer != null) {
            return new ByValueOnHeapValueHolder<V>(value, now, expirationTime, this.valueSerializer);
        }
        return new ByRefOnHeapValueHolder<V>(value, now, expirationTime);
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = OnHeapValueHolder.TIME_UNIT.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private void enforceCapacity(int delta) {
        int evicted = 0;
        for (int attempts = 0; attempts < 4 * delta && evicted < 2 * delta && this.capacity < (long)this.map.size(); ++attempts) {
            if (!this.evict()) continue;
            ++evicted;
        }
    }

    boolean evict() {
        this.evictionObserver.begin();
        Random random = new Random();
        Set<Map.Entry<K, OnHeapValueHolder<V>>> values = this.map.getRandomValues(random, 8, this.evictionVeto);
        if (values.isEmpty()) {
            values = this.map.getRandomValues(random, 8, Predicates.none());
        }
        if (values.isEmpty()) {
            return false;
        }
        Map.Entry<K, OnHeapValueHolder<V>> evict = Collections.max(values, this.evictionPrioritizer);
        if (this.map.remove(evict.getKey(), evict.getValue())) {
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
            this.eventListener.onEviction(evict.getKey(), (Store.ValueHolder)evict.getValue());
            return true;
        }
        this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.FAILURE);
        return false;
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static <K, V> Predicate<Map.Entry<K, OnHeapValueHolder<V>>> wrap(final Predicate<Cache.Entry<K, V>> predicate, final TimeSource timeSource) {
        if (predicate == null) {
            return Predicates.none();
        }
        return new Predicate<Map.Entry<K, OnHeapValueHolder<V>>>(){

            public boolean test(Map.Entry<K, OnHeapValueHolder<V>> argument) {
                return predicate.test((Object)OnHeapStore.wrap(argument, timeSource));
            }
        };
    }

    private static <K, V> Comparator<Map.Entry<K, OnHeapValueHolder<V>>> wrap(final Comparator<Cache.Entry<K, V>> comparator, final TimeSource timeSource) {
        return new Comparator<Map.Entry<K, OnHeapValueHolder<V>>>(){

            @Override
            public int compare(Map.Entry<K, OnHeapValueHolder<V>> t, Map.Entry<K, OnHeapValueHolder<V>> u) {
                return comparator.compare(OnHeapStore.wrap(t, timeSource), OnHeapStore.wrap(u, timeSource));
            }
        };
    }

    private static <K, V> Cache.Entry<K, V> wrap(Map.Entry<K, OnHeapValueHolder<V>> value, TimeSource timeSource) {
        return CacheStoreHelper.cacheEntry(value.getKey(), (Store.ValueHolder)((Store.ValueHolder)value.getValue()), (TimeSource)timeSource);
    }

    private static final class OnHeapStoreStatsSettings {
        @ContextAttribute(value="tags")
        private final Set<String> tags = new HashSet<String>(Arrays.asList("store"));
        @ContextAttribute(value="cachingTier")
        private final CachingTier<?, ?> cachingTier = null;
        @ContextAttribute(value="authoritativeTier")
        private final OnHeapStore<?, ?> authoritativeTier;

        OnHeapStoreStatsSettings(OnHeapStore<?, ?> onHeapStore) {
            this.authoritativeTier = onHeapStore;
        }
    }

    private static class MapWrapper<K, V> {
        private final ConcurrentHashMap<K, OnHeapValueHolder<V>> map;
        private final ConcurrentHashMap<OnHeapKey<K>, OnHeapValueHolder<V>> keyCopyMap;
        private final Serializer<K> keySerializer;

        MapWrapper(Serializer<K> keySerializer) {
            this.keySerializer = keySerializer;
            if (keySerializer == null) {
                this.map = new ConcurrentHashMap();
                this.keyCopyMap = null;
            } else {
                this.keyCopyMap = new ConcurrentHashMap();
                this.map = null;
            }
        }

        boolean remove(K key, OnHeapValueHolder<V> value) {
            if (this.keySerializer == null) {
                return this.map.remove(key, value);
            }
            return this.keyCopyMap.remove(this.lookupOnlyKey(key), value);
        }

        Set<Map.Entry<K, OnHeapValueHolder<V>>> getRandomValues(Random random, int size, final Predicate<Map.Entry<K, OnHeapValueHolder<V>>> veto) {
            if (this.keySerializer == null) {
                return this.map.getRandomValues(random, size, veto);
            }
            Set<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>> values = this.keyCopyMap.getRandomValues(random, size, new Predicate<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>>(){

                public boolean test(Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>> entry) {
                    return veto.test(new AbstractMap.SimpleEntry(entry.getKey().getActualKeyObject(), entry.getValue()));
                }
            });
            LinkedHashSet<Map.Entry<K, OnHeapValueHolder<V>>> rv = new LinkedHashSet<Map.Entry<K, OnHeapValueHolder<V>>>(values.size());
            for (Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>> entry : values) {
                rv.add(new AbstractMap.SimpleEntry<K, OnHeapValueHolder<V>>(entry.getKey().getActualKeyObject(), entry.getValue()));
            }
            return rv;
        }

        int size() {
            if (this.keySerializer == null) {
                return this.map.size();
            }
            return this.keyCopyMap.size();
        }

        Iterator<Map.Entry<K, OnHeapValueHolder<V>>> entrySetIterator() {
            if (this.keySerializer == null) {
                return this.map.entrySet().iterator();
            }
            final Iterator<Map.Entry<OnHeapKey<K>, OnHeapValueHolder<V>>> iter = this.keyCopyMap.entrySet().iterator();
            return new Iterator<Map.Entry<K, OnHeapValueHolder<V>>>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Map.Entry<K, OnHeapValueHolder<V>> next() {
                    Map.Entry entry = (Map.Entry)iter.next();
                    return new AbstractMap.SimpleEntry(((OnHeapKey)entry.getKey()).getActualKeyObject(), entry.getValue());
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }

        OnHeapValueHolder<V> compute(final K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
            if (this.keySerializer == null) {
                return this.map.compute(key, computeFunction);
            }
            return this.keyCopyMap.compute(this.makeKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                    return (OnHeapValueHolder)((Object)computeFunction.apply(key, mappedValue));
                }
            });
        }

        void clear() {
            if (this.keySerializer == null) {
                this.map.clear();
            } else {
                this.keyCopyMap.clear();
            }
        }

        OnHeapValueHolder<V> remove(K key) {
            if (this.keySerializer == null) {
                return this.map.remove(key);
            }
            return this.keyCopyMap.remove(this.lookupOnlyKey(key));
        }

        OnHeapValueHolder<V> computeIfPresent(final K key, final BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
            if (this.keySerializer == null) {
                return this.map.computeIfPresent(key, computeFunction);
            }
            return this.keyCopyMap.computeIfPresent(this.lookupOnlyKey(key), new BiFunction<OnHeapKey<K>, OnHeapValueHolder<V>, OnHeapValueHolder<V>>(){

                public OnHeapValueHolder<V> apply(OnHeapKey<K> mappedKey, OnHeapValueHolder<V> mappedValue) {
                    return (OnHeapValueHolder)((Object)computeFunction.apply(key, mappedValue));
                }
            });
        }

        private OnHeapKey<K> makeKey(K key) {
            return new SerializedOnHeapKey<K>(key, this.keySerializer);
        }

        private OnHeapKey<K> lookupOnlyKey(K key) {
            return new LookupOnlyOnHeapKey<K>(key);
        }

        public OnHeapValueHolder<V> get(K key) {
            if (this.keySerializer == null) {
                return this.map.get(key);
            }
            return this.keyCopyMap.get(this.lookupOnlyKey(key));
        }

        public OnHeapValueHolder<V> putIfAbsent(K key, OnHeapValueHolder<V> valueHolder) {
            if (this.keySerializer == null) {
                return this.map.putIfAbsent(key, valueHolder);
            }
            return this.keyCopyMap.putIfAbsent(this.lookupOnlyKey(key), valueHolder);
        }

        public boolean replace(K key, OnHeapValueHolder<V> oldValue, OnHeapValueHolder<V> newValue) {
            if (this.keySerializer == null) {
                return this.map.replace(key, oldValue, newValue);
            }
            return this.keyCopyMap.replace(this.lookupOnlyKey(key), oldValue, newValue);
        }
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class})
    public static class Provider
    implements Store.Provider,
    CachingTier.Provider {
        private volatile ServiceProvider serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        public <K, V> OnHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            OnHeapStoreServiceConfiguration onHeapStoreServiceConfig = (OnHeapStoreServiceConfiguration)ServiceLocator.findSingletonAmongst(OnHeapStoreServiceConfiguration.class, (Object[])serviceConfigs);
            boolean storeByValue = onHeapStoreServiceConfig != null && onHeapStoreServiceConfig.storeByValue();
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            Serializer keySerializer = null;
            Serializer valueSerializer = null;
            if (storeByValue) {
                if (this.serviceProvider == null) {
                    throw new RuntimeException("ServiceProvider is null.");
                }
                SerializationProvider serializationProvider = (SerializationProvider)this.serviceProvider.getService(SerializationProvider.class);
                keySerializer = serializationProvider.createKeySerializer(storeConfig.getKeyType(), storeConfig.getClassLoader(), serviceConfigs);
                valueSerializer = serializationProvider.createValueSerializer(storeConfig.getValueType(), storeConfig.getClassLoader(), serviceConfigs);
            }
            OnHeapStore<K, V> onHeapStore = new OnHeapStore<K, V>(storeConfig, timeSource, storeByValue, keySerializer, valueSerializer);
            this.createdStores.add(onHeapStore);
            return onHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.remove(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OnHeapStore onHeapStore = (OnHeapStore)resource;
            Provider.close(onHeapStore);
        }

        static void close(OnHeapStore onHeapStore) {
            onHeapStore.map.clear();
            onHeapStore.disableStoreEventNotifications();
        }

        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
        }

        public void start(ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore((Store.Configuration)storeConfig, (ServiceConfiguration[])serviceConfigs);
        }

        public void releaseCachingTier(CachingTier<?, ?> resource) {
            ((OnHeapStore)resource).invalidate();
            this.releaseStore((Store)resource);
        }

        public void initCachingTier(CachingTier<?, ?> resource) {
            this.initStore((Store)resource);
        }
    }

    private static class Fault<V>
    extends OnHeapValueHolder<V> {
        private final NullaryFunction<Store.ValueHolder<V>> source;
        private Store.ValueHolder<V> value;
        private Throwable throwable;
        private boolean complete;

        public Fault(NullaryFunction<Store.ValueHolder<V>> source) {
            super(-1L, 0L);
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(Store.ValueHolder<V> value) {
            Fault fault = this;
            synchronized (fault) {
                this.value = value;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Store.ValueHolder<V> get() {
            Fault fault = this;
            synchronized (fault) {
                if (!this.complete) {
                    try {
                        this.complete((Store.ValueHolder)this.source.apply());
                    }
                    catch (Throwable e) {
                        this.fail(e);
                    }
                }
            }
            return this.throwOrReturn();
        }

        public long getId() {
            throw new UnsupportedOperationException("You should NOT call that?!");
        }

        private Store.ValueHolder<V> throwOrReturn() {
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException("Faulting from repository failed", this.throwable);
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable t) {
            Fault fault = this;
            synchronized (fault) {
                this.throwable = t;
                this.complete = true;
                ((Object)((Object)this)).notifyAll();
            }
            this.throwOrReturn();
        }

        public V value() {
            throw new UnsupportedOperationException();
        }

        public long creationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public void setExpirationTime(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long expirationTime(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean isExpired(long expirationTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long lastAccessTime(TimeUnit unit) {
            return Long.MAX_VALUE;
        }

        public void setLastAccessTime(long lastAccessTime, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[Fault : " + (this.complete ? (this.throwable == null ? this.value.toString() : this.throwable.getMessage()) : "???") + "]";
        }
    }
}

