/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.store.disk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionPrioritizer;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.events.StoreEventListener;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.function.BiFunction;
import org.ehcache.function.Function;
import org.ehcache.function.NullaryFunction;
import org.ehcache.function.Predicate;
import org.ehcache.function.Predicates;
import org.ehcache.internal.SystemTimeSource;
import org.ehcache.internal.TimeSource;
import org.ehcache.internal.TimeSourceConfiguration;
import org.ehcache.internal.store.disk.DiskStorageFactory;
import org.ehcache.internal.store.disk.DiskStorePathManager;
import org.ehcache.internal.store.disk.DiskValueHolder;
import org.ehcache.internal.store.disk.ElementSubstituteFilter;
import org.ehcache.internal.store.disk.HashEntry;
import org.ehcache.internal.store.disk.Segment;
import org.ehcache.spi.ServiceLocator;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.cache.Store;
import org.ehcache.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.spi.cache.tiering.CachingTier;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.LocalPersistenceService;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStore<K, V>
implements AuthoritativeTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DiskStore.class);
    private static final int ATTEMPT_RATIO = 4;
    private static final int EVICTION_RATIO = 2;
    private static final int DEFAULT_SEGMENT_COUNT = 16;
    private static final int DEFAULT_QUEUE_CAPACITY = 16;
    private static final int DEFAULT_EXPIRY_THREAD_INTERVAL = 30000;
    private static final DiskStorePathManager DISK_STORE_PATH_MANAGER = new DiskStorePathManager();
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final TimeSource timeSource;
    private final Expiry<? super K, ? super V> expiry;
    private final Serializer<DiskStorageFactory.Element> elementSerializer;
    private final Serializer<Object> indexSerializer;
    private final long capacity;
    private final Predicate<DiskStorageFactory.DiskSubstitute<K, V>> evictionVeto;
    private final Comparator<DiskStorageFactory.DiskSubstitute<K, V>> evictionPrioritizer;
    private final Random random = new Random();
    private volatile DiskStorageFactory<K, V> diskStorageFactory;
    private volatile Segment<K, V>[] segments;
    private volatile int segmentShift;
    private final File dataFile;
    private final File indexFile;
    private static final NullaryFunction<Boolean> REPLACE_EQUALS_TRUE = new NullaryFunction<Boolean>(){

        public Boolean apply() {
            return Boolean.TRUE;
        }
    };

    public DiskStore(Store.Configuration<K, V> config, File dataFile, File indexFile, TimeSource timeSource, Serializer<DiskStorageFactory.Element> elementSerializer, Serializer<Object> indexSerializer) {
        ResourcePool diskPool = config.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.DISK);
        if (diskPool == null) {
            throw new IllegalArgumentException("Disk store must be configured with a resource of type 'disk'");
        }
        if (!diskPool.getUnit().equals(EntryUnit.ENTRIES)) {
            throw new IllegalArgumentException("Disk store only handles resource unit 'entries'");
        }
        this.capacity = diskPool.getSize();
        EvictionPrioritizer prioritizer = config.getEvictionPrioritizer();
        if (prioritizer == null) {
            prioritizer = Eviction.Prioritizer.LRU;
        }
        this.evictionVeto = this.wrap((Predicate<Cache.Entry<K, V>>)config.getEvictionVeto());
        this.evictionPrioritizer = this.wrap((Comparator<Cache.Entry<K, V>>)prioritizer);
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.timeSource = timeSource;
        this.expiry = config.getExpiry();
        this.elementSerializer = elementSerializer;
        this.indexSerializer = indexSerializer;
        this.dataFile = dataFile;
        this.indexFile = indexFile;
    }

    private Predicate<DiskStorageFactory.DiskSubstitute<K, V>> wrap(final Predicate<Cache.Entry<K, V>> predicate) {
        if (predicate == null) {
            return Predicates.none();
        }
        return new Predicate<DiskStorageFactory.DiskSubstitute<K, V>>(){

            public boolean test(DiskStorageFactory.DiskSubstitute<K, V> argument) {
                return predicate.test((Object)DiskStore.this.wrap(argument));
            }
        };
    }

    private Cache.Entry<K, V> wrap(final DiskStorageFactory.DiskSubstitute<K, V> value) {
        return new Cache.Entry<K, V>(){

            public K getKey() {
                return value.getKey();
            }

            public V getValue() {
                return this.getDiskValueHolder().value();
            }

            public long getCreationTime(TimeUnit unit) {
                return this.getDiskValueHolder().creationTime(unit);
            }

            public long getLastAccessTime(TimeUnit unit) {
                return this.getDiskValueHolder().lastAccessTime(unit);
            }

            public float getHitRate(TimeUnit unit) {
                return this.getDiskValueHolder().hitRate(unit);
            }

            private DiskValueHolder<V> getDiskValueHolder() {
                Object key = value.getKey();
                int hash = DiskStore.hash(key.hashCode());
                DiskStorageFactory.Element element = DiskStore.this.segmentFor(hash).get(key, hash, false);
                return element == null ? null : element.getValueHolder();
            }
        };
    }

    private Comparator<DiskStorageFactory.DiskSubstitute<K, V>> wrap(final Comparator<Cache.Entry<K, V>> comparator) {
        return new Comparator<DiskStorageFactory.DiskSubstitute<K, V>>(){

            @Override
            public int compare(DiskStorageFactory.DiskSubstitute<K, V> t, DiskStorageFactory.DiskSubstitute<K, V> u) {
                return comparator.compare(DiskStore.this.wrap(t), DiskStore.this.wrap(u));
            }
        };
    }

    private void checkKey(K keyObject) {
        if (keyObject == null) {
            throw new NullPointerException();
        }
        if (!this.keyType.isAssignableFrom(keyObject.getClass())) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    private void checkValue(V valueObject) {
        if (valueObject == null) {
            throw new NullPointerException();
        }
        if (!this.valueType.isAssignableFrom(valueObject.getClass())) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    private int size() {
        int size = 0;
        for (Segment<K, V> segment : this.segments) {
            size += segment.count;
        }
        return size;
    }

    private static int hash(int hash) {
        int spread = hash;
        spread += spread << 15 ^ 0xFFFFCD7D;
        spread ^= spread >>> 10;
        spread += spread << 3;
        spread ^= spread >>> 6;
        spread += (spread << 2) + (spread << 14);
        return spread ^ spread >>> 16;
    }

    private Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift];
    }

    public Store.ValueHolder<V> get(K key) throws CacheAccessException {
        return this.internalGetAndFault(key, false);
    }

    Store.ValueHolder<V> internalGetAndFault(final K key, boolean markFaulted) throws CacheAccessException {
        this.checkKey(key);
        int hash = DiskStore.hash(key.hashCode());
        DiskStorageFactory.Element<K, V> existingElement = this.segmentFor(hash).compute(key, hash, new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedValue) {
                long now = DiskStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    return null;
                }
                DiskStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        }, Segment.Compute.IF_PRESENT, true, markFaulted);
        return existingElement == null ? null : existingElement.getValueHolder();
    }

    public boolean containsKey(K key) throws CacheAccessException {
        this.checkKey(key);
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    public void put(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        int hash = DiskStore.hash(key.hashCode());
        final long now = this.timeSource.getTimeMillis();
        final AtomicBoolean entryActuallyAdded = new AtomicBoolean();
        this.segmentFor(hash).compute(key, hash, new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedValue) {
                entryActuallyAdded.set(mappedValue == null);
                if (mappedValue != null && mappedValue.isExpired(now)) {
                    mappedValue = null;
                }
                if (mappedValue == null) {
                    return DiskStore.this.newCreateValueHolder(key, value, now);
                }
                return DiskStore.this.newUpdateValueHolder(key, mappedValue, value, now);
            }
        }, Segment.Compute.ALWAYS, false, false);
        if (entryActuallyAdded.get()) {
            this.enforceCapacity(1);
        }
    }

    public Store.ValueHolder<V> putIfAbsent(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        int hash = DiskStore.hash(key.hashCode());
        final long now = this.timeSource.getTimeMillis();
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        this.segmentFor(hash).compute(key, hash, new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedValue) {
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    return DiskStore.this.newCreateValueHolder(key, value, now);
                }
                returnValue.set(mappedValue.getValueHolder());
                DiskStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        }, Segment.Compute.ALWAYS, false, false);
        return returnValue.get();
    }

    public void remove(K key) throws CacheAccessException {
        this.checkKey(key);
        int hash = DiskStore.hash(key.hashCode());
        this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        int hash = DiskStore.hash(key.hashCode());
        final AtomicBoolean removed = new AtomicBoolean(false);
        this.segmentFor(hash).compute(key, hash, new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedValue) {
                long now = DiskStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    return null;
                }
                if (value.equals(mappedValue.getValueHolder().value())) {
                    removed.set(true);
                    return null;
                }
                DiskStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        }, Segment.Compute.IF_PRESENT, false, false);
        return removed.get();
    }

    public Store.ValueHolder<V> replace(final K key, final V value) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(value);
        int hash = DiskStore.hash(key.hashCode());
        final AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        this.segmentFor(hash).compute(key, hash, new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedValue) {
                long now = DiskStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    return null;
                }
                returnValue.set(mappedValue.getValueHolder());
                return DiskStore.this.newUpdateValueHolder(key, mappedValue, value, now);
            }
        }, Segment.Compute.IF_PRESENT, false, false);
        return returnValue.get();
    }

    public boolean replace(final K key, final V oldValue, final V newValue) throws CacheAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        int hash = DiskStore.hash(key.hashCode());
        final AtomicBoolean returnValue = new AtomicBoolean(false);
        this.segmentFor(hash).compute(key, hash, new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedValue) {
                long now = DiskStore.this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    return null;
                }
                if (oldValue.equals(mappedValue.getValueHolder().value())) {
                    returnValue.set(true);
                    return DiskStore.this.newUpdateValueHolder(key, mappedValue, newValue, now);
                }
                DiskStore.this.setAccessTimeAndExpiry(key, mappedValue, now);
                return mappedValue;
            }
        }, Segment.Compute.IF_PRESENT, false, false);
        return returnValue.get();
    }

    public void clear() throws CacheAccessException {
        this.internalClear();
    }

    void internalClear() {
        if (this.segments != null) {
            for (Segment<K, V> s : this.segments) {
                s.clear();
            }
        }
    }

    public void destroy() throws CacheAccessException {
        if (this.dataFile.delete() | this.indexFile.delete()) {
            LOG.info("Destroyed " + this.dataFile.getAbsolutePath() + " and " + this.indexFile.getAbsolutePath());
        }
    }

    public void create() throws CacheAccessException {
        boolean success;
        try {
            success = this.dataFile.createNewFile();
            if (!success) {
                throw new CacheAccessException("Data file already exists: " + this.dataFile.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            throw new CacheAccessException((Throwable)ioe);
        }
        try {
            success = this.indexFile.createNewFile();
            if (!success) {
                throw new CacheAccessException("Index file already exists: " + this.indexFile.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            this.dataFile.delete();
            throw new CacheAccessException((Throwable)ioe);
        }
        LOG.info("Created " + this.dataFile.getAbsolutePath() + " and " + this.indexFile.getAbsolutePath());
    }

    public void close() {
        if (this.diskStorageFactory == null) {
            LOG.warn("disk store already closed");
            return;
        }
        this.diskStorageFactory.unbind();
        this.diskStorageFactory = null;
        this.segments = null;
    }

    public void init() {
        try {
            this.diskStorageFactory = new DiskStorageFactory<K, V>(this.capacity, this.evictionVeto, this.evictionPrioritizer, this.timeSource, this.elementSerializer, this.indexSerializer, this.dataFile, this.indexFile, 16, 16L, 30000);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException(fnfe);
        }
        this.segments = new Segment[16];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment<K, V>(this.diskStorageFactory, this.timeSource, this);
        }
        this.segmentShift = Integer.numberOfLeadingZeros(this.segments.length - 1);
        this.diskStorageFactory.bind(this);
    }

    public void maintenance() {
    }

    public void enableStoreEventNotifications(StoreEventListener<K, V> listener) {
    }

    public void disableStoreEventNotifications() {
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() throws CacheAccessException {
        return new DiskStoreIterator();
    }

    public Store.ValueHolder<V> getAndFault(K key) throws CacheAccessException {
        return this.internalGetAndFault(key, true);
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, true);
    }

    public boolean flush(K key, Store.ValueHolder<V> valueHolder, CachingTier<K, V> cachingTier) {
        if (valueHolder instanceof DiskValueHolder) {
            throw new IllegalArgumentException("Value holder must be of a class coming from the caching tier");
        }
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).flush(key, hash, valueHolder, cachingTier);
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private void setAccessTimeAndExpiry(K key, DiskStorageFactory.Element<K, V> element, long now) {
        element.getValueHolder().setAccessTimeMillis(now);
        DiskValueHolder<V> valueHolder = element.getValueHolder();
        Duration duration = this.expiry.getExpiryForAccess(key, valueHolder.value());
        if (duration != null) {
            if (duration.isForever()) {
                valueHolder.setExpireTimeMillis(-1L);
            } else {
                valueHolder.setExpireTimeMillis(DiskStore.safeExpireTime(now, duration));
            }
        }
    }

    private static long safeExpireTime(long now, Duration duration) {
        long millis = TimeUnit.MILLISECONDS.convert(duration.getAmount(), duration.getTimeUnit());
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long result = now + millis;
        if (result < 0L) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    private DiskStorageFactory.Element<K, V> newUpdateValueHolder(K key, DiskStorageFactory.Element<K, V> oldValue, V newValue, long now) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Duration duration = this.expiry.getExpiryForUpdate(key, oldValue.getValueHolder().value(), newValue);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration == null) {
            return new DiskStorageFactory.ElementImpl<K, V>(key, newValue, now, oldValue.getValueHolder().getExpireTimeMillis());
        }
        if (duration.isForever()) {
            return new DiskStorageFactory.ElementImpl<K, V>(key, newValue, now, -1L);
        }
        return new DiskStorageFactory.ElementImpl<K, V>(key, newValue, now, DiskStore.safeExpireTime(now, duration));
    }

    private DiskStorageFactory.Element<K, V> newCreateValueHolder(K key, V value, long now) {
        if (value == null) {
            throw new NullPointerException();
        }
        Duration duration = this.expiry.getExpiryForCreation(key, value);
        if (Duration.ZERO.equals((Object)duration)) {
            return null;
        }
        if (duration.isForever()) {
            return new DiskStorageFactory.ElementImpl<K, V>(key, value, now, -1L);
        }
        return new DiskStorageFactory.ElementImpl<K, V>(key, value, now, DiskStore.safeExpireTime(now, duration));
    }

    DiskValueHolder<V> enforceCapacityIfValueNotNull(DiskStorageFactory.Element<K, V> computeResult) {
        if (computeResult != null) {
            this.enforceCapacity(1);
        }
        return computeResult == null ? null : computeResult.getValueHolder();
    }

    void enforceCapacity(int delta) {
        int attempts = 0;
        for (int evicted = 0; attempts < 4 * delta && evicted < 2 * delta && this.capacity < (long)this.size(); evicted += this.diskStorageFactory.evict(1), ++attempts) {
        }
    }

    DiskStorageFactory.Element<K, V> evict(K key, DiskStorageFactory.DiskSubstitute<K, V> diskSubstitute) {
        return this.evictElement(key, diskSubstitute);
    }

    DiskStorageFactory.Element<K, V> expire(K key, DiskStorageFactory.DiskSubstitute<K, V> diskSubstitute) {
        return this.evictElement(key, diskSubstitute);
    }

    private DiskStorageFactory.Element<K, V> evictElement(K key, DiskStorageFactory.DiskSubstitute<K, V> diskSubstitute) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).evict(key, hash, diskSubstitute);
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws CacheAccessException {
        return this.compute(key, mappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> compute(final K key, final BiFunction<? super K, ? super V, ? extends V> mappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        int hash = DiskStore.hash(key.hashCode());
        final long now = this.timeSource.getTimeMillis();
        BiFunction biFunction = new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedElement) {
                Object existingValue;
                Object computedValue;
                if (mappedElement != null && mappedElement.isExpired(now)) {
                    mappedElement = null;
                }
                if ((computedValue = mappingFunction.apply(mappedKey, existingValue = mappedElement == null ? null : mappedElement.getValueHolder().value())) == null) {
                    return null;
                }
                if (DiskStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    if (mappedElement != null) {
                        DiskStore.this.setAccessTimeAndExpiry(key, mappedElement, now);
                    }
                    return mappedElement;
                }
                DiskStore.this.checkValue(computedValue);
                if (mappedElement != null) {
                    return DiskStore.this.newUpdateValueHolder(key, mappedElement, computedValue, now);
                }
                return DiskStore.this.newCreateValueHolder(key, computedValue, now);
            }
        };
        DiskStorageFactory.Element<K, V> computedElement = this.segmentFor(hash).compute(key, hash, biFunction, Segment.Compute.ALWAYS, false, false);
        return this.enforceCapacityIfValueNotNull(computedElement);
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws CacheAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, false);
    }

    private Store.ValueHolder<V> internalComputeIfAbsent(final K key, final Function<? super K, ? extends V> mappingFunction, boolean fault) throws CacheAccessException {
        this.checkKey(key);
        int hash = DiskStore.hash(key.hashCode());
        final long now = this.timeSource.getTimeMillis();
        BiFunction biFunction = new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedElement) {
                if (mappedElement == null || mappedElement.isExpired(now)) {
                    Object computedValue = mappingFunction.apply(mappedKey);
                    if (computedValue == null) {
                        return null;
                    }
                    DiskStore.this.checkValue(computedValue);
                    return DiskStore.this.newCreateValueHolder(key, computedValue, now);
                }
                DiskStore.this.setAccessTimeAndExpiry(key, mappedElement, now);
                return mappedElement;
            }
        };
        DiskStorageFactory.Element<K, V> computedElement = this.segmentFor(hash).compute(key, hash, biFunction, Segment.Compute.IF_ABSENT, false, fault);
        return this.enforceCapacityIfValueNotNull(computedElement);
    }

    public Store.ValueHolder<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) throws CacheAccessException {
        return this.computeIfPresent(key, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Store.ValueHolder<V> computeIfPresent(final K key, final BiFunction<? super K, ? super V, ? extends V> remappingFunction, final NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        this.checkKey(key);
        int hash = DiskStore.hash(key.hashCode());
        BiFunction biFunction = new BiFunction<K, DiskStorageFactory.Element<K, V>, DiskStorageFactory.Element<K, V>>(){

            public DiskStorageFactory.Element<K, V> apply(K mappedKey, DiskStorageFactory.Element<K, V> mappedElement) {
                long now = DiskStore.this.timeSource.getTimeMillis();
                if (mappedElement != null && mappedElement.isExpired(now)) {
                    return null;
                }
                Object existingValue = mappedElement == null ? null : mappedElement.getValueHolder().value();
                Object computedValue = remappingFunction.apply(mappedKey, existingValue);
                if (computedValue == null) {
                    return null;
                }
                if (DiskStore.eq(existingValue, computedValue) && !((Boolean)replaceEqual.apply()).booleanValue()) {
                    DiskStore.this.setAccessTimeAndExpiry(key, mappedElement, now);
                    return mappedElement;
                }
                DiskStore.this.checkValue(computedValue);
                return DiskStore.this.newUpdateValueHolder(key, mappedElement, computedValue, now);
            }
        };
        DiskStorageFactory.Element<K, V> computedElement = this.segmentFor(hash).compute(key, hash, biFunction, Segment.Compute.IF_PRESENT, false, false);
        return computedElement == null ? null : computedElement.getValueHolder();
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws CacheAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, final Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, NullaryFunction<Boolean> replaceEqual) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            BiFunction biFunction = new BiFunction<K, V, V>(){

                public V apply(final K k, final V v) {
                    Map.Entry entry = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return k;
                        }

                        @Override
                        public V getValue() {
                            return v;
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    Iterator iterator = ((Iterable)remappingFunction.apply(Collections.singleton(entry))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        DiskStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.compute(key, biFunction, replaceEqual);
            result.put(key, computed);
        }
        return result;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, final Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws CacheAccessException {
        HashMap<K, Store.ValueHolder<V>> result = new HashMap<K, Store.ValueHolder<V>>();
        for (K key : keys) {
            this.checkKey(key);
            Function function = new Function<K, V>(){

                public V apply(K k) {
                    Iterator iterator = ((Iterable)mappingFunction.apply(Collections.singleton(k))).iterator();
                    Map.Entry result = (Map.Entry)iterator.next();
                    if (result != null) {
                        DiskStore.this.checkKey(result.getKey());
                        return result.getValue();
                    }
                    return null;
                }
            };
            Store.ValueHolder<V> computed = this.computeIfAbsent(key, function);
            result.put(key, computed);
        }
        return result;
    }

    public void flushToDisk() throws ExecutionException, InterruptedException {
        this.diskStorageFactory.flush().get();
        this.diskStorageFactory.evictToSize();
    }

    boolean fault(K key, DiskStorageFactory.Placeholder<K, V> expect, DiskStorageFactory.DiskMarker<K, V> fault) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).fault(key, hash, expect, fault, false);
    }

    DiskStorageFactory.DiskSubstitute<K, V> unretrievedGet(K key) {
        if (key == null) {
            return null;
        }
        int hash = DiskStore.hash(key.hashCode());
        DiskStorageFactory.DiskSubstitute<K, V> o = this.segmentFor(hash).unretrievedGet(key, hash);
        return o;
    }

    Iterator<DiskStorageFactory.DiskSubstitute<K, V>> diskSubstituteIterator() {
        return new DiskSubstituteIterator();
    }

    boolean putRawIfAbsent(K key, DiskStorageFactory.DiskMarker<K, V> encoded) {
        int hash = DiskStore.hash(key.hashCode());
        return this.segmentFor(hash).putRawIfAbsent(key, hash, encoded);
    }

    public List<DiskStorageFactory.DiskSubstitute<K, V>> getRandomSample(ElementSubstituteFilter factory, int sampleSize, Object keyHint) {
        ArrayList sampled = new ArrayList(sampleSize);
        int randomHash = this.random.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift : DiskStore.hash(keyHint.hashCode()) >>> this.segmentShift;
        int segmentIndex = segmentStart;
        do {
            this.segments[segmentIndex].addRandomSample(factory, sampleSize, sampled, randomHash);
        } while (sampled.size() < sampleSize && (segmentIndex = segmentIndex + 1 & this.segments.length - 1) != segmentStart);
        return sampled;
    }

    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider {
        static final AtomicInteger aliasCounter = new AtomicInteger();
        private ServiceProvider serviceProvider;

        public <K, V> DiskStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            TimeSourceConfiguration timeSourceConfig = (TimeSourceConfiguration)ServiceLocator.findSingletonAmongst(TimeSourceConfiguration.class, (Object[])serviceConfigs);
            TimeSource timeSource = timeSourceConfig != null ? timeSourceConfig.getTimeSource() : SystemTimeSource.INSTANCE;
            SerializationProvider serializationProvider = (SerializationProvider)this.serviceProvider.findService(SerializationProvider.class);
            Serializer elementSerializer = serializationProvider.createSerializer(DiskStorageFactory.Element.class, storeConfig.getClassLoader(), new ServiceConfiguration[0]);
            Serializer objectSerializer = serializationProvider.createSerializer(Object.class, storeConfig.getClassLoader(), new ServiceConfiguration[0]);
            if (!(storeConfig instanceof Store.PersistentStoreConfiguration)) {
                throw new IllegalArgumentException("Store.Configuration for DiskStore should implement Store.PersistentStoreConfiguration");
            }
            Object identifier = ((Store.PersistentStoreConfiguration)storeConfig).getIdentifier();
            LocalPersistenceService localPersistenceService = (LocalPersistenceService)this.serviceProvider.findService(LocalPersistenceService.class);
            return new DiskStore<K, V>(storeConfig, localPersistenceService.getDataFile(identifier), localPersistenceService.getIndexFile(identifier), timeSource, (Serializer<DiskStorageFactory.Element>)elementSerializer, (Serializer<Object>)objectSerializer);
        }

        public void releaseStore(Store<?, ?> resource) {
            resource.close();
        }

        public void start(ServiceConfiguration<?> config, ServiceProvider serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }
    }

    class DiskSubstituteIterator
    extends HashIterator
    implements Iterator<DiskStorageFactory.DiskSubstitute<K, V>> {
        DiskSubstituteIterator() {
        }

        @Override
        public DiskStorageFactory.DiskSubstitute<K, V> next() {
            return super.nextEntry().element;
        }
    }

    abstract class HashIterator {
        private int segmentIndex;
        private Iterator<HashEntry<K, V>> currentIterator;

        HashIterator() {
            this.segmentIndex = DiskStore.this.segments.length;
            while (this.segmentIndex > 0) {
                --this.segmentIndex;
                this.currentIterator = DiskStore.this.segments[this.segmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
        }

        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            while (this.segmentIndex > 0) {
                --this.segmentIndex;
                this.currentIterator = DiskStore.this.segments[this.segmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        protected HashEntry<K, V> nextEntry() {
            if (this.currentIterator == null) {
                return null;
            }
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            while (this.segmentIndex > 0) {
                --this.segmentIndex;
                this.currentIterator = DiskStore.this.segments[this.segmentIndex].hashIterator();
                if (!this.currentIterator.hasNext()) continue;
                return this.currentIterator.next();
            }
            return null;
        }

        public void remove() {
            this.currentIterator.remove();
        }
    }

    class DiskStoreIterator
    implements Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> {
        private final DiskSubstituteIterator diskSubstituteIterator;
        private DiskStorageFactory.Element<K, V> next;

        DiskStoreIterator() {
            this.diskSubstituteIterator = new DiskSubstituteIterator();
            this.advance();
        }

        private void advance() {
            this.next = null;
            while (this.diskSubstituteIterator.hasNext()) {
                Object nextSubstitute = this.diskSubstituteIterator.next();
                Object key = ((DiskStorageFactory.DiskSubstitute)nextSubstitute).getKey();
                int hash = DiskStore.hash(key.hashCode());
                this.next = DiskStore.this.segmentFor(hash).get(key, hash, false);
                if (this.next == null) continue;
                break;
            }
        }

        public boolean hasNext() throws CacheAccessException {
            return this.next != null;
        }

        public Cache.Entry<K, Store.ValueHolder<V>> next() throws CacheAccessException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DiskStorageFactory.Element element = this.next;
            this.advance();
            final Object key = element.getKey();
            final DiskValueHolder valueHolder = element.getValueHolder();
            return new Cache.Entry<K, Store.ValueHolder<V>>(){

                public K getKey() {
                    return key;
                }

                public Store.ValueHolder<V> getValue() {
                    return valueHolder;
                }

                public long getCreationTime(TimeUnit unit) {
                    return valueHolder == null ? 0L : valueHolder.creationTime(unit);
                }

                public long getLastAccessTime(TimeUnit unit) {
                    return valueHolder == null ? 0L : valueHolder.lastAccessTime(unit);
                }

                public float getHitRate(TimeUnit unit) {
                    return valueHolder == null ? 0.0f : valueHolder.hitRate(unit);
                }
            };
        }
    }
}

