/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.UUID;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.persistence.PersistenceConfiguration;
import org.ehcache.internal.store.disk.DiskStorePathManager;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.LocalPersistenceService;
import org.ehcache.spi.service.ServiceConfiguration;

public class DefaultLocalPersistenceService
implements LocalPersistenceService {
    private final File rootDirectory;
    private final DiskStorePathManager diskStorePathManager;
    private FileLock lock;
    private File lockFile;
    private RandomAccessFile rw;
    private boolean started;

    public DefaultLocalPersistenceService(PersistenceConfiguration persistenceConfiguration) {
        this.rootDirectory = persistenceConfiguration != null ? persistenceConfiguration.getRootDirectory() : new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID() + File.separator);
        this.diskStorePathManager = new DiskStorePathManager(this.rootDirectory.getAbsolutePath());
    }

    public synchronized void start(ServiceConfiguration<?> config, ServiceProvider serviceProvider) {
        if (!this.started) {
            DefaultLocalPersistenceService.createLocationIfRequiredAndVerify(this.rootDirectory);
            try {
                this.lockFile = new File(this.rootDirectory, ".lock");
                this.rw = new RandomAccessFile(this.lockFile, "rw");
                this.lock = this.rw.getChannel().lock();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't lock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void stop() {
        if (this.started) {
            try {
                this.lock.release();
                this.rw.close();
                if (this.lockFile.delete()) {
                    // empty if block
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't unlock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = false;
        }
    }

    static void createLocationIfRequiredAndVerify(File rootDirectory) {
        if (!rootDirectory.exists()) {
            if (!rootDirectory.mkdirs()) {
                throw new IllegalArgumentException("Directory couldn't be created: " + rootDirectory.getAbsolutePath());
            }
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Location is not a directory: " + rootDirectory.getAbsolutePath());
        }
        if (!rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Location isn't writable: " + rootDirectory.getAbsolutePath());
        }
    }

    public Object persistenceContext(String cacheAlias, CacheConfiguration<?, ?> cacheConfiguration) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public File getDataFile(Object identifier) {
        return this.diskStorePathManager.getFile(identifier, ".data");
    }

    public File getIndexFile(Object identifier) {
        return this.diskStorePathManager.getFile(identifier, ".index");
    }

    File getLockFile() {
        return this.lockFile;
    }
}

