/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.internal.cachingtier;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.internal.cachingtier.ClockEvictableEntry;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.spi.cache.tiering.CachingTier;

public class ClockEvictingHeapCachingTier<K>
implements CachingTier<K> {
    private static final int MAX_EVICTION = 5;
    private final ConcurrentHashMap<K, ClockEvictableEntry> map = new ConcurrentHashMap();
    private volatile AtomicReference<Iterator<Map.Entry<K, ClockEvictableEntry>>> iterator = new AtomicReference<Iterator<Map.Entry<K, ClockEvictableEntry>>>(this.map.entrySet().iterator());
    private final long maxOnHeapEntries;

    private Map.Entry<K, ClockEvictableEntry> newIterator(Iterator<Map.Entry<K, ClockEvictableEntry>> old) {
        Iterator<Map.Entry<K, ClockEvictableEntry>> newIt = this.map.entrySet().iterator();
        if (!this.iterator.compareAndSet(old, newIt)) {
            return this.iterator.get().next();
        }
        return newIt.next();
    }

    public ClockEvictingHeapCachingTier(long maxOnHeapEntryCount) {
        this.maxOnHeapEntries = maxOnHeapEntryCount;
    }

    public Object get(K key) {
        ClockEvictableEntry entry = this.map.get(key);
        return entry == null ? null : entry.getValue();
    }

    public Object putIfAbsent(K key, Object value) {
        ClockEvictableEntry previous = this.map.putIfAbsent(key, new ClockEvictableEntry(value));
        if (previous == null) {
            this.evictIfNecessary();
            return null;
        }
        return previous.getValue();
    }

    private void evictIfNecessary() {
        int count = 0;
        while (count < 5 && (long)this.map.size() > this.maxOnHeapEntries) {
            Map.Entry<K, ClockEvictableEntry> next = this.next();
            ClockEvictableEntry value = next.getValue();
            if (value.wasAccessedAndFlip() || !this.map.remove(next.getKey(), value)) continue;
            ++count;
        }
    }

    private Map.Entry<K, ClockEvictableEntry> next() {
        Iterator<Map.Entry<K, ClockEvictableEntry>> iterator = this.iterator.get();
        Map.Entry<K, ClockEvictableEntry> next = !iterator.hasNext() ? this.newIterator(iterator) : iterator.next();
        return next;
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public void remove(K key, Object value) {
        this.map.remove(key, new ClockEvictableEntry(value));
    }

    public boolean replace(K key, Object oldValue, Object newValue) {
        return this.map.replace(key, new ClockEvictableEntry(oldValue), new ClockEvictableEntry(newValue));
    }

    public long getMaxCacheSize() {
        return this.maxOnHeapEntries;
    }

    public long size() {
        return this.map.size();
    }
}

