/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.jsr107.config.ConfigurationElementState;
import org.ehcache.jsr107.config.Jsr107CacheConfiguration;
import org.ehcache.jsr107.config.Jsr107Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Element;

public class Jsr107CacheConfigurationParser
implements CacheServiceConfigurationParser<Jsr107Service> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/jsr107");
    private static final URL XML_SCHEMA = Jsr107CacheConfigurationParser.class.getResource("/ehcache-107ext.xsd");
    private static final String MANAGEMENT_ENABLED_ATTRIBUTE = "enable-management";
    private static final String STATISTICS_ENABLED_ATTRIBUTE = "enable-statistics";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceConfiguration<Jsr107Service> parseServiceConfiguration(Element fragment) {
        String localName = fragment.getLocalName();
        if ("mbeans".equals(localName)) {
            ConfigurationElementState managementEnabled = ConfigurationElementState.UNSPECIFIED;
            ConfigurationElementState statisticsEnabled = ConfigurationElementState.UNSPECIFIED;
            if (fragment.hasAttribute(MANAGEMENT_ENABLED_ATTRIBUTE)) {
                ConfigurationElementState configurationElementState = managementEnabled = Boolean.parseBoolean(fragment.getAttribute(MANAGEMENT_ENABLED_ATTRIBUTE)) ? ConfigurationElementState.ENABLED : ConfigurationElementState.DISABLED;
            }
            if (fragment.hasAttribute(STATISTICS_ENABLED_ATTRIBUTE)) {
                statisticsEnabled = Boolean.parseBoolean(fragment.getAttribute(STATISTICS_ENABLED_ATTRIBUTE)) ? ConfigurationElementState.ENABLED : ConfigurationElementState.DISABLED;
            }
            return new Jsr107CacheConfiguration(statisticsEnabled, managementEnabled);
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<Jsr107Service> getServiceType() {
        return null;
    }

    public Element unparseServiceConfiguration(ServiceConfiguration<Jsr107Service> serviceConfiguration) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

