/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.Unwrap;
import org.ehcache.spi.service.ServiceConfiguration;

class Eh107CompleteConfiguration<K, V>
extends Eh107Configuration<K, V>
implements CompleteConfiguration<K, V> {
    private static final long serialVersionUID = -142083640934760400L;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final boolean isStoreByValue;
    private final boolean isReadThrough;
    private final boolean isWriteThrough;
    private volatile boolean isStatisticsEnabled;
    private volatile boolean isManagementEnabled;
    private final List<CacheEntryListenerConfiguration<K, V>> cacheEntryListenerConfigs = new CopyOnWriteArrayList<CacheEntryListenerConfiguration<K, V>>();
    private final Factory<CacheLoader<K, V>> cacheLoaderFactory;
    private final Factory<CacheWriter<? super K, ? super V>> cacheWriterFactory;
    private final Factory<ExpiryPolicy> expiryPolicyFactory;
    private final transient CacheConfiguration<K, V> ehcacheConfig;

    Eh107CompleteConfiguration(Configuration<K, V> config) {
        this(config, null);
    }

    Eh107CompleteConfiguration(Configuration<K, V> config, CacheConfiguration<K, V> ehcacheConfig) {
        this(config, ehcacheConfig, false, false);
    }

    public Eh107CompleteConfiguration(Configuration<K, V> config, CacheConfiguration<K, V> ehcacheConfig, boolean useEhcacheExpiry, boolean useEhcacheLoaderWriter) {
        this.ehcacheConfig = ehcacheConfig;
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.isStoreByValue = Eh107CompleteConfiguration.isStoreByValue(config, ehcacheConfig);
        Factory tempExpiryPolicyFactory = EternalExpiryPolicy.factoryOf();
        if (config instanceof CompleteConfiguration) {
            CompleteConfiguration completeConfig = (CompleteConfiguration)config;
            this.isReadThrough = completeConfig.isReadThrough();
            this.isWriteThrough = completeConfig.isWriteThrough();
            this.isStatisticsEnabled = completeConfig.isStatisticsEnabled();
            this.isManagementEnabled = completeConfig.isManagementEnabled();
            if (useEhcacheLoaderWriter) {
                this.cacheLoaderFactory = this.createThrowingFactory();
                this.cacheWriterFactory = this.createThrowingFactory();
            } else {
                this.cacheLoaderFactory = completeConfig.getCacheLoaderFactory();
                this.cacheWriterFactory = completeConfig.getCacheWriterFactory();
            }
            tempExpiryPolicyFactory = completeConfig.getExpiryPolicyFactory();
            for (CacheEntryListenerConfiguration listenerConfig : completeConfig.getCacheEntryListenerConfigurations()) {
                this.cacheEntryListenerConfigs.add(listenerConfig);
            }
        } else {
            this.isReadThrough = false;
            this.isWriteThrough = false;
            this.isStatisticsEnabled = false;
            this.isManagementEnabled = false;
            this.cacheLoaderFactory = null;
            this.cacheWriterFactory = null;
        }
        if (useEhcacheExpiry) {
            tempExpiryPolicyFactory = this.createThrowingFactory();
        }
        this.expiryPolicyFactory = tempExpiryPolicyFactory;
    }

    private static <K, V> boolean isStoreByValue(Configuration<K, V> config, CacheConfiguration<K, V> ehcacheConfig) {
        if (ehcacheConfig != null) {
            Collection serviceConfigurations = ehcacheConfig.getServiceConfigurations();
            for (ServiceConfiguration serviceConfiguration : serviceConfigurations) {
                DefaultCopierConfiguration copierConfig;
                if (!(serviceConfiguration instanceof DefaultCopierConfiguration) || !(copierConfig = (DefaultCopierConfiguration)serviceConfiguration).getType().equals((Object)DefaultCopierConfiguration.Type.VALUE)) continue;
                return !copierConfig.getClazz().isAssignableFrom(IdentityCopier.class);
            }
        }
        return config.isStoreByValue();
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    public Class<V> getValueType() {
        return this.valueType;
    }

    public boolean isStoreByValue() {
        return this.isStoreByValue;
    }

    @Override
    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    @Override
    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public boolean isManagementEnabled() {
        return this.isManagementEnabled;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return Collections.unmodifiableList(this.cacheEntryListenerConfigs);
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.cacheLoaderFactory;
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.cacheWriterFactory;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.expiryPolicyFactory;
    }

    @Override
    void setManagementEnabled(boolean isManagementEnabled) {
        this.isManagementEnabled = isManagementEnabled;
    }

    @Override
    void setStatisticsEnabled(boolean isStatisticsEnabled) {
        this.isStatisticsEnabled = isStatisticsEnabled;
    }

    @Override
    void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.cacheEntryListenerConfigs.add(listenerConfig);
    }

    @Override
    void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerConfig) {
        this.cacheEntryListenerConfigs.remove(listenerConfig);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return Unwrap.unwrap(clazz, this, this.ehcacheConfig);
    }

    private Object writeReplace() throws ObjectStreamException {
        throw new UnsupportedOperationException("Serialization of Ehcache provider configuration classes is not supported");
    }

    private <T> Factory<T> createThrowingFactory() {
        return new Factory<T>(){

            public T create() {
                throw new UnsupportedOperationException("Cannot convert from Ehcache type to JSR-107 factory");
            }
        };
    }
}

