/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.core.internal.service.ServiceLocator;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.Eh107CacheLoaderWriter;
import org.ehcache.jsr107.Eh107CacheLoaderWriterProvider;
import org.ehcache.jsr107.Eh107CompleteConfiguration;
import org.ehcache.jsr107.Eh107Expiry;
import org.ehcache.jsr107.EhcacheExpiryWrapper;
import org.ehcache.jsr107.ExpiryPolicyToEhcacheExpiry;
import org.ehcache.jsr107.ListenerResources;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.config.Jsr107Service;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationMerger.class);
    private final XmlConfiguration xmlConfiguration;
    private final Jsr107Service jsr107Service;
    private final Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory;

    ConfigurationMerger(org.ehcache.config.Configuration ehConfig, Jsr107Service jsr107Service, Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory) {
        this.xmlConfiguration = ehConfig instanceof XmlConfiguration ? (XmlConfiguration)ehConfig : null;
        this.jsr107Service = jsr107Service;
        this.cacheLoaderWriterFactory = cacheLoaderWriterFactory;
    }

    <K, V> ConfigHolder<K, V> mergeConfigurations(String cacheName, Configuration<K, V> configuration) {
        Eh107CompleteConfiguration<K, V> jsr107Configuration = new Eh107CompleteConfiguration<K, V>(configuration);
        Eh107Expiry<K, V> expiryPolicy = null;
        CacheLoaderWriter<K, V> loaderWriter = null;
        try {
            boolean useEhcacheLoaderWriter;
            boolean hasConfiguredExpiry;
            CacheConfigurationBuilder templateBuilder;
            CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder((Class)configuration.getKeyType(), (Class)configuration.getValueType());
            String templateName = this.jsr107Service.getTemplateNameForCache(cacheName);
            if (this.xmlConfiguration != null && templateName != null && (templateBuilder = this.xmlConfiguration.newCacheConfigurationBuilderFromTemplate(templateName, jsr107Configuration.getKeyType(), jsr107Configuration.getValueType())) != null) {
                builder = templateBuilder;
                LOG.info("Configuration of cache {} will be supplemented by template {}", (Object)cacheName, (Object)templateName);
            }
            if (hasConfiguredExpiry = (builder = this.handleStoreByValue(jsr107Configuration, builder, cacheName)).hasConfiguredExpiry()) {
                LOG.info("Cache {} will use expiry configuration from template {}", (Object)cacheName, (Object)templateName);
            } else {
                expiryPolicy = this.initExpiryPolicy(jsr107Configuration);
                builder = builder.withExpiry(expiryPolicy);
            }
            DefaultCacheLoaderWriterConfiguration ehcacheLoaderWriterConfiguration = (DefaultCacheLoaderWriterConfiguration)builder.getExistingServiceConfiguration(DefaultCacheLoaderWriterConfiguration.class);
            if (ehcacheLoaderWriterConfiguration == null) {
                useEhcacheLoaderWriter = false;
                loaderWriter = this.initCacheLoaderWriter(jsr107Configuration, new MultiCacheException());
                if (loaderWriter != null && (jsr107Configuration.isReadThrough() || jsr107Configuration.isWriteThrough())) {
                    this.cacheLoaderWriterFactory.registerJsr107Loader(cacheName, loaderWriter);
                }
            } else {
                useEhcacheLoaderWriter = true;
                if (!jsr107Configuration.isReadThrough() && !jsr107Configuration.isWriteThrough()) {
                    LOG.warn("Activating Ehcache loader/writer for JSR-107 cache {} which was neither read-through nor write-through", (Object)cacheName);
                }
                LOG.info("Cache {} will use loader/writer configuration from template {}", (Object)cacheName, (Object)templateName);
            }
            CacheConfiguration cacheConfiguration = builder.build();
            if (hasConfiguredExpiry) {
                expiryPolicy = new EhcacheExpiryWrapper(cacheConfiguration.getExpiry());
            }
            return new ConfigHolder<K, V>(new CacheResources<K, V>(cacheName, loaderWriter, expiryPolicy, this.initCacheEventListeners(jsr107Configuration)), new Eh107CompleteConfiguration<K, V>(jsr107Configuration, cacheConfiguration, hasConfiguredExpiry, useEhcacheLoaderWriter), cacheConfiguration, useEhcacheLoaderWriter);
        }
        catch (Throwable throwable) {
            MultiCacheException mce = new MultiCacheException(throwable);
            CacheResources.close(expiryPolicy, mce);
            CacheResources.close(loaderWriter, mce);
            throw mce;
        }
    }

    private <K, V> CacheConfigurationBuilder<K, V> handleStoreByValue(Eh107CompleteConfiguration<K, V> jsr107Configuration, CacheConfigurationBuilder<K, V> builder, String cacheName) {
        DefaultCopierConfiguration copierConfig = (DefaultCopierConfiguration)builder.getExistingServiceConfiguration(DefaultCopierConfiguration.class);
        if (copierConfig == null) {
            if (jsr107Configuration.isStoreByValue()) {
                DefaultCopyProviderConfiguration defaultCopyProviderConfiguration;
                if (this.xmlConfiguration != null && (defaultCopyProviderConfiguration = (DefaultCopyProviderConfiguration)ServiceLocator.findSingletonAmongst(DefaultCopyProviderConfiguration.class, (Object[])this.xmlConfiguration.getServiceCreationConfigurations().toArray())) != null) {
                    Map defaults = defaultCopyProviderConfiguration.getDefaults();
                    boolean matchingDefault = false;
                    if (defaults.containsKey(jsr107Configuration.getKeyType())) {
                        matchingDefault = true;
                    } else {
                        builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.KEY));
                    }
                    if (defaults.containsKey(jsr107Configuration.getValueType())) {
                        matchingDefault = true;
                    } else {
                        builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.VALUE));
                    }
                    if (matchingDefault) {
                        LOG.info("CacheManager level copier configuration overwriting JSR-107 by-value semantics for cache {}", (Object)cacheName);
                    }
                    return builder;
                }
                builder = builder.add((ServiceConfiguration)new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.KEY)).add((ServiceConfiguration)new DefaultCopierConfiguration(SerializingCopier.class, DefaultCopierConfiguration.Type.VALUE));
                LOG.debug("Using default SerializingCopier for JSR-107 store-by-value cache {}", (Object)cacheName);
            }
        } else {
            LOG.info("Cache level copier configuration overwriting JSR-107 by-value semantics for cache {}", (Object)cacheName);
        }
        return builder;
    }

    private <K, V> Map<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> initCacheEventListeners(CompleteConfiguration<K, V> config) {
        ConcurrentHashMap listenerResources = new ConcurrentHashMap();
        MultiCacheException mce = new MultiCacheException();
        for (CacheEntryListenerConfiguration listenerConfig : config.getCacheEntryListenerConfigurations()) {
            listenerResources.put(listenerConfig, ListenerResources.createListenerResources(listenerConfig, mce));
        }
        return listenerResources;
    }

    private <K, V> Eh107Expiry<K, V> initExpiryPolicy(CompleteConfiguration<K, V> config) {
        return new ExpiryPolicyToEhcacheExpiry((ExpiryPolicy)config.getExpiryPolicyFactory().create());
    }

    private <K, V> CacheLoaderWriter<K, V> initCacheLoaderWriter(CompleteConfiguration<K, V> config, MultiCacheException mce) {
        CacheWriter cacheWriter;
        Factory cacheLoaderFactory = config.getCacheLoaderFactory();
        Factory<CacheWriter<K, V>> cacheWriterFactory = ConfigurationMerger.getCacheWriterFactory(config);
        CacheLoader cacheLoader = cacheLoaderFactory == null ? null : (CacheLoader)cacheLoaderFactory.create();
        try {
            cacheWriter = cacheWriterFactory == null ? null : (CacheWriter)cacheWriterFactory.create();
        }
        catch (Throwable t) {
            if (t != mce) {
                mce.addThrowable(t);
            }
            CacheResources.close(cacheLoader, mce);
            throw mce;
        }
        if (cacheLoader == null && cacheWriter == null) {
            return null;
        }
        return new Eh107CacheLoaderWriter(cacheLoader, cacheWriter);
    }

    private static <K, V> Factory<CacheWriter<K, V>> getCacheWriterFactory(CompleteConfiguration<K, V> config) {
        Factory factory = config.getCacheWriterFactory();
        return factory;
    }

    static class ConfigHolder<K, V> {
        final CacheResources<K, V> cacheResources;
        final CacheConfiguration<K, V> cacheConfiguration;
        final Eh107CompleteConfiguration<K, V> jsr107Configuration;
        final boolean useEhcacheLoaderWriter;

        public ConfigHolder(CacheResources<K, V> cacheResources, Eh107CompleteConfiguration<K, V> jsr107Configuration, CacheConfiguration<K, V> cacheConfiguration, boolean useEhcacheLoaderWriter) {
            this.cacheResources = cacheResources;
            this.jsr107Configuration = jsr107Configuration;
            this.cacheConfiguration = cacheConfiguration;
            this.useEhcacheLoaderWriter = useEhcacheLoaderWriter;
        }
    }
}

