/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.jsr107.config.Jsr107Configuration;
import org.ehcache.jsr107.config.Jsr107Service;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Jsr107ServiceConfigurationParser
implements CacheManagerServiceConfigurationParser<Jsr107Service> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/jsr107");
    private static final URL XML_SCHEMA = Jsr107ServiceConfigurationParser.class.getResource("/ehcache-107ext.xsd");

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceCreationConfiguration<Jsr107Service> parseServiceCreationConfiguration(Element fragment) {
        boolean jsr107CompliantAtomics = true;
        if (fragment.hasAttribute("jsr-107-compliant-atomics")) {
            jsr107CompliantAtomics = Boolean.parseBoolean(fragment.getAttribute("jsr-107-compliant-atomics"));
        }
        String defaultTemplate = fragment.getAttribute("default-template");
        HashMap<String, String> templates = new HashMap<String, String>();
        NodeList childNodes = fragment.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element item = (Element)node;
            templates.put(item.getAttribute("name"), item.getAttribute("template"));
        }
        return new Jsr107Configuration(defaultTemplate, templates, jsr107CompliantAtomics);
    }
}

