/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.config.Jsr107Configuration;
import org.ehcache.config.xml.XmlConfigurationParser;
import org.ehcache.jsr107.Jsr107Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceConfigParser
implements XmlConfigurationParser<Jsr107Service> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/jsr107");
    private static final URL XML_SCHEMA = ServiceConfigParser.class.getResource("/ehcache-107ext.xsd");

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceConfiguration<Jsr107Service> parse(Element fragment) {
        boolean jsr107CompliantAtomics = true;
        if (fragment.hasAttribute("jsr107CompliantAtomics")) {
            jsr107CompliantAtomics = Boolean.parseBoolean(fragment.getAttribute("jsr107CompliantAtomics"));
        }
        String defaultTemplate = fragment.getAttribute("default-template");
        HashMap<String, String> templates = new HashMap<String, String>();
        NodeList childNodes = fragment.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element item = (Element)childNodes.item(i);
            templates.put(item.getAttribute("name"), item.getAttribute("template"));
        }
        return new Jsr107Configuration(defaultTemplate, templates, jsr107CompliantAtomics);
    }
}

