/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import org.ehcache.exceptions.BulkCacheWriterException;
import org.ehcache.spi.writer.CacheWriter;

class Eh107CacheWriter<K, V>
implements CacheWriter<K, V>,
Closeable {
    private final javax.cache.integration.CacheWriter<K, V> cacheWriter;

    Eh107CacheWriter(javax.cache.integration.CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void write(K key, V value) throws Exception {
        this.cacheWriter.write(this.cacheEntryFor(key, value));
    }

    public void delete(K key) throws Exception {
        this.cacheWriter.delete(key);
    }

    public void deleteAll(Iterable<? extends K> keys) throws Exception {
        HashSet<K> allKeys = new HashSet<K>();
        for (K key : keys) {
            allKeys.add(key);
        }
        try {
            this.cacheWriter.deleteAll(allKeys);
        }
        catch (Exception e) {
            Map<?, Exception> failures = this.failures(allKeys, e);
            Set<?> successes = this.successes(keys, failures.keySet());
            throw new BulkCacheWriterException(failures, successes);
        }
    }

    private Set<?> successes(Iterable<? extends K> keys, Set<?> failures) {
        HashSet<K> set = new HashSet<K>();
        for (K key : keys) {
            if (failures.contains(key)) continue;
            set.add(key);
        }
        return set;
    }

    private Map<?, Exception> failures(Set<K> keys, Exception e) {
        HashMap<K, Exception> map = new HashMap<K, Exception>(keys.size());
        for (K key : keys) {
            map.put(key, e);
        }
        return map;
    }

    public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) throws Exception {
        ArrayList<Cache.Entry<K, V>> toWrite = new ArrayList<Cache.Entry<K, V>>();
        for (Map.Entry<K, V> entry : entries) {
            toWrite.add(this.cacheEntryFor(entry.getKey(), entry.getValue()));
        }
        try {
            this.cacheWriter.writeAll(toWrite);
        }
        catch (Exception e) {
            HashMap<Object, Exception> failures = new HashMap<Object, Exception>();
            for (Cache.Entry entry : toWrite) {
                failures.put(entry.getKey(), e);
            }
            HashSet<K> successes = new HashSet<K>();
            for (Map.Entry<K, V> entry : entries) {
                K key = entry.getKey();
                if (failures.containsKey(key)) continue;
                successes.add(key);
            }
            throw new BulkCacheWriterException(failures, successes);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cacheWriter instanceof Closeable) {
            ((Closeable)this.cacheWriter).close();
        }
    }

    private Cache.Entry<K, V> cacheEntryFor(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    private static class Entry<K, V>
    implements Cache.Entry<K, V> {
        private final K key;
        private final V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new IllegalArgumentException();
        }
    }
}

