/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.offheap;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.server.offheap.InternalChain;
import org.ehcache.clustered.server.offheap.OffHeapChainMap;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.portability.Portability;

public class PinningOffHeapChainMap<K>
extends OffHeapChainMap<K> {
    public PinningOffHeapChainMap(PageSource source, Portability<? super K> keyPortability, int minPageSize, int maxPageSize, boolean shareByThieving) {
        super(source, keyPortability, minPageSize, maxPageSize, shareByThieving);
    }

    @Override
    public Chain getAndAppend(K key, ByteBuffer element) {
        return this.execute(key, () -> super.getAndAppend(key, element));
    }

    @Override
    public void append(K key, ByteBuffer element) {
        this.execute(key, () -> {
            super.append(key, element);
            return null;
        });
    }

    @Override
    public void put(K key, Chain chain) {
        this.execute(key, () -> {
            super.put(key, chain);
            return null;
        });
    }

    @Override
    public void replaceAtHead(K key, Chain expected, Chain replacement) {
        this.execute(key, () -> {
            this.heads.setPinning(key, false);
            super.replaceAtHead(key, expected, replacement);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chain execute(K key, Supplier<Chain> supplier) {
        Lock lock = this.heads.writeLock();
        lock.lock();
        try {
            Chain chain = supplier.get();
            return chain;
        }
        finally {
            this.pinIfNeeded(key);
            lock.unlock();
        }
    }

    private void pinIfNeeded(K key) {
        InternalChain internalChain = (InternalChain)this.heads.get(key);
        if (internalChain != null && this.shouldBePinned(internalChain.detach())) {
            this.heads.setPinning(key, true);
        }
    }

    private boolean shouldBePinned(Chain chain) {
        for (Element element : chain) {
            if (!OperationsCodec.getOperationCode((ByteBuffer)element.getPayload()).shouldBePinned()) continue;
            return true;
        }
        return false;
    }
}

