/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.server.management.ClusterTierManagerBinding;
import org.ehcache.clustered.server.management.ClusterTierManagerSettingsManagementProvider;
import org.ehcache.clustered.server.management.Notification;
import org.ehcache.clustered.server.management.PoolBinding;
import org.ehcache.clustered.server.management.PoolSettingsManagementProvider;
import org.ehcache.clustered.server.management.PoolStatisticsManagementProvider;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.service.monitoring.EntityManagementRegistry;
import org.terracotta.management.service.monitoring.EntityManagementRegistryConfiguration;

public class Management
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Management.class);
    private final EntityManagementRegistry managementRegistry;
    private final EhcacheStateService ehcacheStateService;
    private final String clusterTierManagerIdentifier;

    public Management(ServiceRegistry services, EhcacheStateService ehcacheStateService, boolean active, String clusterTierManagerIdentifier) throws ConfigurationException {
        this.ehcacheStateService = ehcacheStateService;
        try {
            this.managementRegistry = (EntityManagementRegistry)services.getService((ServiceConfiguration)new EntityManagementRegistryConfiguration(services, active));
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to retrieve service: " + e.getMessage());
        }
        if (this.managementRegistry != null) {
            this.registerClusterTierManagerSettingsProvider();
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolSettingsManagementProvider());
            this.managementRegistry.addManagementProvider((ManagementProvider)new PoolStatisticsManagementProvider(ehcacheStateService));
        }
        this.clusterTierManagerIdentifier = clusterTierManagerIdentifier;
    }

    @Override
    public void close() {
        if (this.managementRegistry != null) {
            this.managementRegistry.close();
        }
    }

    protected EhcacheStateService getEhcacheStateService() {
        return this.ehcacheStateService;
    }

    public EntityManagementRegistry getManagementRegistry() {
        return this.managementRegistry;
    }

    protected ClusterTierManagerBinding generateClusterTierManagerBinding() {
        return new ClusterTierManagerBinding(this.clusterTierManagerIdentifier, this.getEhcacheStateService());
    }

    protected void registerClusterTierManagerSettingsProvider() {
        this.getManagementRegistry().addManagementProvider((ManagementProvider)new ClusterTierManagerSettingsManagementProvider());
    }

    public void entityCreated() {
        if (this.managementRegistry != null) {
            LOGGER.trace("entityCreated()");
            this.managementRegistry.entityCreated();
            this.init();
        }
    }

    public void entityPromotionCompleted() {
        if (this.managementRegistry != null) {
            LOGGER.trace("entityPromotionCompleted()");
            this.managementRegistry.entityPromotionCompleted();
            this.init();
        }
    }

    public void sharedPoolsConfigured() {
        if (this.managementRegistry != null) {
            LOGGER.trace("sharedPoolsConfigured()");
            CompletableFuture.allOf((CompletableFuture[])this.ehcacheStateService.getSharedResourcePools().entrySet().stream().map(e -> this.managementRegistry.register((Object)new PoolBinding((String)e.getKey(), (ServerSideConfiguration.Pool)e.getValue(), PoolBinding.AllocationType.SHARED))).toArray(CompletableFuture[]::new)).thenRun(() -> {
                this.managementRegistry.refresh();
                this.managementRegistry.pushServerEntityNotification((Object)PoolBinding.ALL_SHARED, Notification.EHCACHE_RESOURCE_POOLS_CONFIGURED.name());
            });
        }
    }

    private void init() {
        CompletableFuture.allOf(this.managementRegistry.register((Object)this.generateClusterTierManagerBinding()), this.managementRegistry.register((Object)PoolBinding.ALL_SHARED)).thenRun(() -> ((EntityManagementRegistry)this.managementRegistry).refresh());
    }
}

