/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.messages.CommonConfigCodec;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EntityConfigurationCodec;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageCodec;
import org.ehcache.clustered.common.internal.messages.ResponseCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpCodec;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpCodec;
import org.ehcache.clustered.server.ClusterTierManagerActiveEntity;
import org.ehcache.clustered.server.ClusterTierManagerPassiveEntity;
import org.ehcache.clustered.server.ConcurrencyStrategies;
import org.ehcache.clustered.server.EhcacheExecutionStrategy;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.internal.messages.EhcacheServerCodec;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessageCodec;
import org.ehcache.clustered.server.management.Management;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.ehcache.clustered.server.state.config.EhcacheStateServiceConfig;
import org.terracotta.entity.CommonServerEntity;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.ExecutionStrategy;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.SyncMessageCodec;

public class ClusterTierManagerServerEntityService
implements EntityServerService<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final int DEFAULT_CONCURRENCY = 16;
    private static final KeySegmentMapper DEFAULT_MAPPER = new KeySegmentMapper(16);
    private static final ConfigCodec CONFIG_CODEC = new CommonConfigCodec();
    private final EntityConfigurationCodec configCodec = new EntityConfigurationCodec(CONFIG_CODEC);

    public long getVersion() {
        return 10L;
    }

    public boolean handlesEntityType(String typeName) {
        return "org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity".equals(typeName);
    }

    public ClusterTierManagerActiveEntity createActiveEntity(ServiceRegistry registry, byte[] configuration) throws ConfigurationException {
        EhcacheStateService ehcacheStateService;
        ClusterTierManagerConfiguration clusterTierManagerConfiguration = this.configCodec.decodeClusterTierManagerConfiguration(configuration);
        try {
            ehcacheStateService = (EhcacheStateService)registry.getService((ServiceConfiguration)new EhcacheStateServiceConfig(clusterTierManagerConfiguration, registry, DEFAULT_MAPPER));
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to retrieve EhcacheStateService: " + e.getMessage());
        }
        Management management = new Management(registry, ehcacheStateService, true, clusterTierManagerConfiguration.getIdentifier());
        return new ClusterTierManagerActiveEntity(clusterTierManagerConfiguration, ehcacheStateService, management);
    }

    public ClusterTierManagerPassiveEntity createPassiveEntity(ServiceRegistry registry, byte[] configuration) throws ConfigurationException {
        EhcacheStateService ehcacheStateService;
        ClusterTierManagerConfiguration clusterTierManagerConfiguration = this.configCodec.decodeClusterTierManagerConfiguration(configuration);
        try {
            ehcacheStateService = (EhcacheStateService)registry.getService((ServiceConfiguration)new EhcacheStateServiceConfig(clusterTierManagerConfiguration, registry, DEFAULT_MAPPER));
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Unable to retrieve EhcacheStateService: " + e.getMessage());
        }
        Management management = new Management(registry, ehcacheStateService, false, clusterTierManagerConfiguration.getIdentifier());
        return new ClusterTierManagerPassiveEntity(clusterTierManagerConfiguration, ehcacheStateService, management);
    }

    public ConcurrencyStrategy<EhcacheEntityMessage> getConcurrencyStrategy(byte[] config) {
        return ConcurrencyStrategies.clusterTierManagerConcurrency();
    }

    public MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> getMessageCodec() {
        EhcacheCodec ehcacheCodec = new EhcacheCodec(new ServerStoreOpCodec(), new LifeCycleMessageCodec(CONFIG_CODEC), new StateRepositoryOpCodec(), new ResponseCodec());
        return new EhcacheServerCodec(ehcacheCodec, new PassiveReplicationMessageCodec());
    }

    public SyncMessageCodec<EhcacheEntityMessage> getSyncMessageCodec() {
        return new SyncMessageCodec<EhcacheEntityMessage>(){

            public byte[] encode(int concurrencyKey, EhcacheEntityMessage response) {
                throw new UnsupportedOperationException("This entity does not have sync messages");
            }

            public EhcacheEntityMessage decode(int concurrencyKey, byte[] payload) {
                throw new UnsupportedOperationException("This entity does not have sync messages");
            }
        };
    }

    public <AP extends CommonServerEntity<EhcacheEntityMessage, EhcacheEntityResponse>> AP reconfigureEntity(ServiceRegistry registry, AP oldEntity, byte[] configuration) {
        throw new UnsupportedOperationException("Reconfigure not supported in Ehcache");
    }

    public ExecutionStrategy<EhcacheEntityMessage> getExecutionStrategy(byte[] configuration) {
        return new EhcacheExecutionStrategy();
    }
}

