/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.util.Map;
import java.util.stream.Collectors;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessage;
import org.ehcache.clustered.server.internal.messages.SyncMessageType;
import org.terracotta.client.message.tracker.OOOMessageHandler;
import org.terracotta.entity.ClientSourceId;

public class EhcacheMessageTrackerMessage
extends EhcacheSyncMessage {
    private final int segmentId;
    private final Map<Long, Map<Long, EhcacheEntityResponse>> trackedMessages;

    public EhcacheMessageTrackerMessage(int segmentId, Map<Long, Map<Long, EhcacheEntityResponse>> trackedMessages) {
        this.segmentId = segmentId;
        this.trackedMessages = trackedMessages;
    }

    public EhcacheMessageTrackerMessage(int segmentId, OOOMessageHandler<EhcacheEntityMessage, EhcacheEntityResponse> messageHandler) {
        this(segmentId, messageHandler.getTrackedClients().collect(Collectors.toMap(ClientSourceId::toLong, clientSourceId -> messageHandler.getTrackedResponsesForSegment(segmentId, clientSourceId))));
    }

    public SyncMessageType getMessageType() {
        return SyncMessageType.MESSAGE_TRACKER;
    }

    public Map<Long, Map<Long, EhcacheEntityResponse>> getTrackedMessages() {
        return this.trackedMessages;
    }

    public int getSegmentId() {
        return this.segmentId;
    }
}

