/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.ehcache.clustered.server.store.ServerLockManager;
import org.terracotta.entity.ClientDescriptor;

public class LockManagerImpl
implements ServerLockManager {
    private final Map<Long, ClientDescriptor> blockedKeys = new ConcurrentHashMap<Long, ClientDescriptor>();

    @Override
    public boolean lock(long key, ClientDescriptor client) {
        if (this.blockedKeys.containsKey(key)) {
            return false;
        }
        this.blockedKeys.put(key, client);
        return true;
    }

    @Override
    public void unlock(long key) {
        this.blockedKeys.remove(key);
    }

    @Override
    public void createLockStateAfterFailover(ClientDescriptor client, Set<Long> locksHeld) {
        locksHeld.forEach(key -> {
            ClientDescriptor absent = this.blockedKeys.putIfAbsent((Long)key, client);
            if (absent != null) {
                throw new IllegalStateException("Key is already locked");
            }
        });
    }

    @Override
    public void sweepLocksForClient(ClientDescriptor client, Consumer<List<Long>> removeHeldKeys) {
        HashSet<Map.Entry<Long, ClientDescriptor>> entries = new HashSet<Map.Entry<Long, ClientDescriptor>>(Collections.unmodifiableSet(this.blockedKeys.entrySet()));
        ArrayList heldKeys = new ArrayList();
        entries.forEach(entry -> {
            if (((ClientDescriptor)entry.getValue()).equals(client)) {
                heldKeys.add((Long)entry.getKey());
                this.blockedKeys.remove(entry.getKey());
            }
        });
        if (removeHeldKeys != null) {
            removeHeldKeys.accept(heldKeys);
        }
    }
}

