/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.common.internal.util.ChainBuilder;
import org.ehcache.core.spi.store.Store;

public abstract class ChainResolver<K, V> {
    protected final OperationsCodec<K, V> codec;

    public ChainResolver(OperationsCodec<K, V> codec) {
        this.codec = codec;
    }

    public abstract Store.ValueHolder<V> resolve(ServerStoreProxy.ChainEntry var1, K var2, long var3, int var5);

    public Store.ValueHolder<V> resolve(ServerStoreProxy.ChainEntry entry, K key, long now) {
        return this.resolve(entry, key, now, 0);
    }

    public abstract Map<K, Store.ValueHolder<V>> resolveAll(Chain var1, long var2);

    public abstract Map<K, Store.ValueHolder<V>> resolveAll(Chain var1);

    public void compact(ServerStoreProxy.ChainEntry entry) {
        ChainBuilder builder = new ChainBuilder();
        for (PutOperation<K, V> operation : this.resolveToSimplePuts(entry).values()) {
            builder = builder.add(this.codec.encode(operation));
        }
        Chain compacted = builder.build();
        if (compacted.length() < entry.length()) {
            entry.replaceAtHead(compacted);
        }
    }

    protected PutOperation<K, V> resolve(ServerStoreProxy.ChainEntry entry, K key, int threshold) {
        PutOperation<K, V> result = null;
        ChainBuilder resolvedChain = new ChainBuilder();
        Iterator iterator = entry.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            ByteBuffer payload = element.getPayload();
            Operation operation = this.codec.decode(payload);
            if (key.equals(operation.getKey())) {
                result = this.applyOperation(key, result, operation);
                continue;
            }
            payload.rewind();
            resolvedChain = resolvedChain.add(payload);
        }
        if (result != null) {
            resolvedChain = resolvedChain.add(this.codec.encode(result));
        }
        if (entry.length() - resolvedChain.length() > threshold) {
            entry.replaceAtHead(resolvedChain.build());
        }
        return result;
    }

    public Map<K, PutOperation<K, V>> resolveToSimplePuts(Chain chain) {
        HashMap<Object, PutOperation> compacted = new HashMap<Object, PutOperation>(2);
        for (Element element : chain) {
            ByteBuffer payload = element.getPayload();
            Operation operation = this.codec.decode(payload);
            compacted.compute(operation.getKey(), (k, v) -> this.applyOperation((K)k, (PutOperation<K, V>)v, (Operation<K, V>)operation));
        }
        return compacted;
    }

    public PutOperation<K, V> resolve(Chain chain, K key) {
        return this.resolveToSimplePuts(chain).get(key);
    }

    public abstract PutOperation<K, V> applyOperation(K var1, PutOperation<K, V> var2, Operation<K, V> var3);
}

