/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourcePool;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.internal.PerpetualCachePersistenceException;
import org.ehcache.clustered.client.internal.loaderwriter.writebehind.ClusteredWriteBehindStore;
import org.ehcache.clustered.client.internal.service.AbstractClientEntityFactory;
import org.ehcache.clustered.client.internal.service.ClusterStateRepository;
import org.ehcache.clustered.client.internal.service.ClusterTierException;
import org.ehcache.clustered.client.internal.service.ClusterTierValidationException;
import org.ehcache.clustered.client.internal.service.ConnectionState;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.EventualServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.StrongServerStoreProxy;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.client.internal.store.lock.LockingServerStoreProxyImpl;
import org.ehcache.clustered.client.service.ClientEntityFactory;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.client.service.EntityService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.Entity;

public class DefaultClusteringService
implements ClusteringService,
EntityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusteringService.class);
    static final String CONNECTION_PREFIX = "Ehcache:";
    private final ClusteringServiceConfiguration configuration;
    private final ConcurrentMap<String, ClusteredSpace> knownPersistenceSpaces = new ConcurrentHashMap<String, ClusteredSpace>();
    private final ConnectionState connectionState;
    private final Set<String> reconnectSet = ConcurrentHashMap.newKeySet();
    private final Collection<Runnable> connectionRecoveryListeners = new CopyOnWriteArrayList<Runnable>();
    private volatile boolean inMaintenance = false;
    private ExecutorService asyncExecutor;

    DefaultClusteringService(ClusteringServiceConfiguration configuration) {
        this.configuration = configuration;
        Properties properties = configuration.getProperties();
        this.connectionState = new ConnectionState(configuration.getTimeouts(), properties, configuration);
        this.connectionState.setConnectionRecoveryListener(() -> this.connectionRecoveryListeners.forEach(Runnable::run));
    }

    @Override
    public void addConnectionRecoveryListener(Runnable runnable) {
        this.connectionRecoveryListeners.add(runnable);
    }

    @Override
    public void removeConnectionRecoveryListener(Runnable runnable) {
        this.connectionRecoveryListeners.remove(runnable);
    }

    @Override
    public ClusteringServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <E extends Entity, C> ClientEntityFactory<E, C> newClientEntityFactory(String entityIdentifier, Class<E> entityType, long entityVersion, C configuration) {
        return new AbstractClientEntityFactory<E, C, Void>(entityIdentifier, entityType, entityVersion, configuration){

            @Override
            protected Connection getConnection() {
                if (!DefaultClusteringService.this.isConnected()) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " not started.");
                }
                return DefaultClusteringService.this.connectionState.getConnection();
            }
        };
    }

    @Override
    public boolean isConnected() {
        return this.connectionState.getConnection() != null;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.asyncExecutor = DefaultClusteringService.createAsyncWorker();
        this.connectionState.initClusterConnection(this.asyncExecutor);
        this.connectionState.initializeState();
    }

    public void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        this.asyncExecutor = DefaultClusteringService.createAsyncWorker();
        this.connectionState.initClusterConnection(this.asyncExecutor);
        if (maintenanceScope == MaintainableService.MaintenanceScope.CACHE_MANAGER) {
            this.connectionState.acquireLeadership();
        }
        this.inMaintenance = true;
    }

    public void stop() {
        LOGGER.info("Closing connection to cluster {}", (Object)this.configuration.getConnectionSource());
        this.connectionState.destroyState(true);
        this.inMaintenance = false;
        this.asyncExecutor.shutdown();
        this.connectionState.closeConnection();
    }

    public void destroyAll() throws CachePersistenceException {
        if (!this.inMaintenance) {
            throw new IllegalStateException("Maintenance mode required");
        }
        this.connectionState.destroyAll();
    }

    public boolean handlesResourceType(ResourceType<?> resourceType) {
        return Stream.of(ClusteredResourceType.Types.values()).anyMatch(t -> t.equals(resourceType));
    }

    public PersistableResourceService.PersistenceSpaceIdentifier<?> getPersistenceSpaceIdentifier(String name, CacheConfiguration<?, ?> config) {
        ClusteredSpace clusteredSpace = (ClusteredSpace)this.knownPersistenceSpaces.get(name);
        if (clusteredSpace != null) {
            return clusteredSpace.identifier;
        }
        DefaultClusterCacheIdentifier cacheIdentifier = new DefaultClusterCacheIdentifier(name);
        clusteredSpace = this.knownPersistenceSpaces.putIfAbsent(name, new ClusteredSpace(cacheIdentifier));
        if (clusteredSpace == null) {
            return cacheIdentifier;
        }
        return clusteredSpace.identifier;
    }

    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)identifier;
        if (this.knownPersistenceSpaces.remove(clusterCacheIdentifier.getId()) == null) {
            throw new PerpetualCachePersistenceException("Unknown identifier: " + clusterCacheIdentifier);
        }
    }

    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)identifier;
        ClusteredSpace clusteredSpace = (ClusteredSpace)this.knownPersistenceSpaces.get(clusterCacheIdentifier.getId());
        if (clusteredSpace == null) {
            throw new PerpetualCachePersistenceException("Clustered space not found for identifier: " + clusterCacheIdentifier);
        }
        ConcurrentMap stateRepositories = clusteredSpace.stateRepositories;
        ClusterStateRepository currentRepo = (ClusterStateRepository)stateRepositories.get(name);
        if (currentRepo != null) {
            return currentRepo;
        }
        ClusterStateRepository newRepo = new ClusterStateRepository(clusterCacheIdentifier, name, this.connectionState.getClusterTierClientEntity(clusterCacheIdentifier.getId()));
        currentRepo = stateRepositories.putIfAbsent(name, newRepo);
        if (currentRepo == null) {
            return newRepo;
        }
        return currentRepo;
    }

    private void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException(this.getClass().getName() + " should be started to call destroy");
        }
    }

    public void destroy(String name) throws CachePersistenceException {
        this.checkStarted();
        this.connectionState.destroy(name);
    }

    private boolean isStarted() {
        return this.connectionState.getEntityFactory() != null;
    }

    @Override
    public <K, V> ServerStoreProxy getServerStoreProxy(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration<K, V> storeConfig, Consistency configuredConsistency, ServerStoreProxy.ServerCallback invalidation) throws CachePersistenceException {
        ServerStoreProxy serverStoreProxy;
        String cacheId = cacheIdentifier.getId();
        if (configuredConsistency == null) {
            throw new NullPointerException("Consistency cannot be null");
        }
        ClusteredResourcePool clusteredResourcePool = null;
        for (ClusteredResourceType<? extends ClusteredResourcePool> type : ClusteredResourceType.Types.values()) {
            ClusteredResourcePool pool = (ClusteredResourcePool)storeConfig.getResourcePools().getPoolForResource(type);
            if (pool == null) continue;
            if (clusteredResourcePool != null) {
                throw new IllegalStateException("At most one clustered resource supported for a cache");
            }
            clusteredResourcePool = pool;
        }
        if (clusteredResourcePool == null) {
            throw new IllegalStateException("A clustered resource is required for a clustered cache");
        }
        ServerStoreConfiguration clientStoreConfiguration = new ServerStoreConfiguration(clusteredResourcePool.getPoolAllocation(), storeConfig.getKeyType().getName(), storeConfig.getValueType().getName(), storeConfig.getKeySerializer() == null ? null : storeConfig.getKeySerializer().getClass().getName(), storeConfig.getValueSerializer() == null ? null : storeConfig.getValueSerializer().getClass().getName(), configuredConsistency, storeConfig.getCacheLoaderWriter() != null, invalidation instanceof ClusteredWriteBehindStore.WriteBehindServerCallback);
        ClusterTierClientEntity storeClientEntity = this.connectionState.createClusterTierClientEntity(cacheId, clientStoreConfiguration, this.reconnectSet.remove(cacheId));
        switch (configuredConsistency) {
            case STRONG: {
                serverStoreProxy = new StrongServerStoreProxy(cacheId, storeClientEntity, invalidation);
                break;
            }
            case EVENTUAL: {
                serverStoreProxy = new EventualServerStoreProxy(cacheId, storeClientEntity, invalidation);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown consistency : " + configuredConsistency));
            }
        }
        try {
            try {
                storeClientEntity.validate(clientStoreConfiguration);
            }
            catch (ClusterTierValidationException e) {
                throw new PerpetualCachePersistenceException("Unable to create cluster tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.configuration.getConnectionSource().getClusterTierManager() + "'", e);
            }
            catch (ClusterTierException e) {
                throw new CachePersistenceException("Unable to create cluster tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.configuration.getConnectionSource().getClusterTierManager() + "'", (Throwable)e);
            }
            catch (TimeoutException e) {
                throw new CachePersistenceException("Unable to create cluster tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.configuration.getConnectionSource().getClusterTierManager() + "'; validate operation timed out", (Throwable)e);
            }
        }
        catch (Throwable t) {
            try {
                serverStoreProxy.close();
            }
            catch (Throwable u) {
                t.addSuppressed(u);
            }
            throw t;
        }
        if (storeConfig.getCacheLoaderWriter() != null) {
            LockManager lockManager = new LockManager(storeClientEntity);
            serverStoreProxy = new LockingServerStoreProxyImpl(serverStoreProxy, lockManager);
        }
        return serverStoreProxy;
    }

    @Override
    public void releaseServerStoreProxy(ServerStoreProxy storeProxy, boolean isReconnect) {
        this.connectionState.removeClusterTierClientEntity(storeProxy.getCacheId());
        if (!isReconnect) {
            storeProxy.close();
        } else {
            this.reconnectSet.add(storeProxy.getCacheId());
        }
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    private static ExecutorService createAsyncWorker() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "Async DefaultClusteringService Worker");
            t.setDaemon(true);
            return t;
        });
    }

    private static class ClusteredSpace {
        private final ClusteringService.ClusteredCacheIdentifier identifier;
        private final ConcurrentMap<String, ClusterStateRepository> stateRepositories;

        ClusteredSpace(ClusteringService.ClusteredCacheIdentifier identifier) {
            this.identifier = identifier;
            this.stateRepositories = new ConcurrentHashMap<String, ClusterStateRepository>();
        }
    }

    private static class DefaultClusterCacheIdentifier
    implements ClusteringService.ClusteredCacheIdentifier {
        private final String id;

        DefaultClusterCacheIdentifier(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Class<ClusteringService> getServiceType() {
            return ClusteringService.class;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.id;
        }
    }
}

