/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.TimeoutsBuilder;
import org.ehcache.clustered.client.internal.ConnectionSource;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.JaxbParsers;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.TimeTypeWithPropSubst;
import org.ehcache.xml.model.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class ClusteringCacheManagerServiceConfigurationParser
extends BaseConfigParser<ClusteringServiceConfiguration>
implements CacheManagerServiceConfigurationParser<ClusteringService> {
    public static final String CLUSTER_ELEMENT_NAME = "cluster";
    public static final String CONNECTION_ELEMENT_NAME = "connection";
    public static final String CLUSTER_CONNECTION_ELEMENT_NAME = "cluster-connection";
    public static final String CLUSTER_TIER_MANAGER_ATTRIBUTE_NAME = "cluster-tier-manager";
    public static final String SERVER_ELEMENT_NAME = "server";
    public static final String HOST_ATTRIBUTE_NAME = "host";
    public static final String PORT_ATTRIBUTE_NAME = "port";
    public static final String READ_TIMEOUT_ELEMENT_NAME = "read-timeout";
    public static final String WRITE_TIMEOUT_ELEMENT_NAME = "write-timeout";
    public static final String CONNECTION_TIMEOUT_ELEMENT_NAME = "connection-timeout";
    public static final String URL_ATTRIBUTE_NAME = "url";
    public static final String DEFAULT_RESOURCE_ELEMENT_NAME = "default-resource";
    public static final String SHARED_POOL_ELEMENT_NAME = "shared-pool";
    public static final String SERVER_SIDE_CONFIG = "server-side-config";
    public static final String AUTO_CREATE_ATTRIBUTE_NAME = "auto-create";
    public static final String CLIENT_MODE_ATTRIBUTE_NAME = "client-mode";
    public static final String UNIT_ATTRIBUTE_NAME = "unit";
    public static final String NAME_ATTRIBUTE_NAME = "name";
    public static final String FROM_ATTRIBUTE_NAME = "from";
    public static final String DEFAULT_UNIT_ATTRIBUTE_VALUE = "seconds";

    public ClusteringCacheManagerServiceConfigurationParser() {
        super(ClusteringServiceConfiguration.class);
    }

    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    public ServiceCreationConfiguration<ClusteringService, ?> parseServiceCreationConfiguration(Element fragment, ClassLoader classLoader) {
        if (CLUSTER_ELEMENT_NAME.equals(fragment.getLocalName())) {
            ServerSideConfig serverConfig = null;
            URI connectionUri = null;
            ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
            String clusterTierManager = null;
            Duration getTimeout = null;
            Duration putTimeout = null;
            Duration connectionTimeout = null;
            NodeList childNodes = fragment.getChildNodes();
            block20: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (1 != item.getNodeType()) continue;
                switch (item.getLocalName()) {
                    case "connection": {
                        Attr urlAttribute = ((Element)item).getAttributeNode(URL_ATTRIBUTE_NAME);
                        String urlValue = JaxbParsers.parseStringWithProperties((String)urlAttribute.getValue());
                        try {
                            connectionUri = new URI(urlValue);
                            continue block20;
                        }
                        catch (URISyntaxException e) {
                            throw new XmlConfigurationException(String.format("Value of %s attribute on XML configuration element <%s> in <%s> is not a valid URI - '%s'", urlAttribute.getName(), item.getNodeName(), fragment.getTagName(), connectionUri), (Throwable)e);
                        }
                    }
                    case "cluster-connection": {
                        clusterTierManager = JaxbParsers.parsePropertyOrString((String)((Element)item).getAttribute(CLUSTER_TIER_MANAGER_ATTRIBUTE_NAME));
                        NodeList serverNodes = item.getChildNodes();
                        for (int j = 0; j < serverNodes.getLength(); ++j) {
                            InetSocketAddress address;
                            Node serverNode = serverNodes.item(j);
                            String host = JaxbParsers.parsePropertyOrString((String)((Element)serverNode).getAttributeNode(HOST_ATTRIBUTE_NAME).getValue().trim());
                            Attr port = ((Element)serverNode).getAttributeNode(PORT_ATTRIBUTE_NAME);
                            if (port == null) {
                                address = InetSocketAddress.createUnresolved(host, 0);
                            } else {
                                String portString = JaxbParsers.parsePropertyOrString((String)port.getValue());
                                address = InetSocketAddress.createUnresolved(host, Integer.parseInt(portString));
                            }
                            serverAddresses.add(address);
                        }
                        continue block20;
                    }
                    case "read-timeout": {
                        getTimeout = this.processTimeout(fragment, item);
                        continue block20;
                    }
                    case "write-timeout": {
                        putTimeout = this.processTimeout(fragment, item);
                        continue block20;
                    }
                    case "connection-timeout": {
                        connectionTimeout = this.processTimeout(fragment, item);
                        continue block20;
                    }
                    case "server-side-config": {
                        serverConfig = this.processServerSideConfig((Element)item);
                        continue block20;
                    }
                    default: {
                        throw new XmlConfigurationException(String.format("Unknown XML configuration element <%s> in <%s>", item.getNodeName(), fragment.getTagName()));
                    }
                }
            }
            try {
                ConnectionSource connectionSource = connectionUri != null ? new ConnectionSource.ClusterUri(connectionUri) : new ConnectionSource.ServerList(serverAddresses, clusterTierManager);
                Timeouts timeouts = this.getTimeouts(getTimeout, putTimeout, connectionTimeout);
                if (serverConfig == null) {
                    return new ClusteringServiceConfiguration(connectionSource, timeouts, ClusteringServiceConfiguration.ClientMode.CONNECT, null, new Properties());
                }
                ServerSideConfiguration serverSideConfiguration = serverConfig.defaultServerResource == null ? new ServerSideConfiguration(serverConfig.pools) : new ServerSideConfiguration(serverConfig.defaultServerResource, serverConfig.pools);
                return new ClusteringServiceConfiguration(connectionSource, timeouts, serverConfig.clientMode, serverSideConfiguration, new Properties());
            }
            catch (IllegalArgumentException e) {
                throw new XmlConfigurationException((Throwable)e);
            }
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    public Element unparseServiceCreationConfiguration(ServiceCreationConfiguration<ClusteringService, ?> serviceCreationConfiguration) {
        Element rootElement = this.unparseConfig(serviceCreationConfiguration);
        return rootElement;
    }

    private Element createRootUrlElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element rootElement = doc.createElementNS(this.getNamespace().toString(), "tc:cluster");
        Element urlElement = this.createUrlElement(doc, clusteringServiceConfiguration);
        rootElement.appendChild(urlElement);
        return rootElement;
    }

    protected Element createUrlElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element urlElement = doc.createElement("tc:connection");
        urlElement.setAttribute(URL_ATTRIBUTE_NAME, clusteringServiceConfiguration.getClusterUri().toString());
        return urlElement;
    }

    private Element createServerElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        if (!(clusteringServiceConfiguration.getConnectionSource() instanceof ConnectionSource.ServerList)) {
            throw new IllegalArgumentException("When connection URL is null, source of connection MUST be of type ConnectionSource.ServerList.class");
        }
        ConnectionSource.ServerList servers = (ConnectionSource.ServerList)clusteringServiceConfiguration.getConnectionSource();
        Element rootElement = doc.createElementNS(this.getNamespace().toString(), "tc:cluster");
        Element connElement = this.createConnectionElementWrapper(doc, clusteringServiceConfiguration);
        servers.getServers().forEach(server -> {
            Element serverElement = doc.createElement("tc:server");
            serverElement.setAttribute(HOST_ATTRIBUTE_NAME, server.getHostName());
            if (server.getPort() > 0) {
                serverElement.setAttribute(PORT_ATTRIBUTE_NAME, Integer.toString(server.getPort()));
            }
            connElement.appendChild(serverElement);
        });
        rootElement.appendChild(connElement);
        return rootElement;
    }

    protected Element createConnectionElementWrapper(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element connElement = doc.createElement("tc:cluster-connection");
        connElement.setAttribute(CLUSTER_TIER_MANAGER_ATTRIBUTE_NAME, clusteringServiceConfiguration.getConnectionSource().getClusterTierManager());
        return connElement;
    }

    protected Element createRootElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element rootElement = clusteringServiceConfiguration.getConnectionSource() instanceof ConnectionSource.ClusterUri ? this.createRootUrlElement(doc, clusteringServiceConfiguration) : this.createServerElement(doc, clusteringServiceConfiguration);
        this.processTimeUnits(doc, rootElement, clusteringServiceConfiguration);
        Element serverSideConfigurationElem = this.processServerSideElements(doc, clusteringServiceConfiguration);
        if (serverSideConfigurationElem != null) {
            rootElement.appendChild(serverSideConfigurationElem);
        }
        return rootElement;
    }

    private void processTimeUnits(Document doc, Element parent, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        if (clusteringServiceConfiguration.getTimeouts() != null) {
            Timeouts timeouts = clusteringServiceConfiguration.getTimeouts();
            Element readTimeoutElem = this.createTimeoutElement(doc, READ_TIMEOUT_ELEMENT_NAME, timeouts.getReadOperationTimeout());
            Element writeTimeoutElem = this.createTimeoutElement(doc, WRITE_TIMEOUT_ELEMENT_NAME, timeouts.getWriteOperationTimeout());
            Element connectionTimeoutElem = this.createTimeoutElement(doc, CONNECTION_TIMEOUT_ELEMENT_NAME, timeouts.getConnectionTimeout());
            parent.appendChild(readTimeoutElem);
            parent.appendChild(writeTimeoutElem);
            parent.appendChild(connectionTimeoutElem);
        }
    }

    private Element createTimeoutElement(Document doc, String timeoutName, Duration timeout) {
        Element retElement = READ_TIMEOUT_ELEMENT_NAME.equals(timeoutName) ? doc.createElement("tc:read-timeout") : (WRITE_TIMEOUT_ELEMENT_NAME.equals(timeoutName) ? doc.createElement("tc:write-timeout") : doc.createElement("tc:connection-timeout"));
        retElement.setAttribute(UNIT_ATTRIBUTE_NAME, DEFAULT_UNIT_ATTRIBUTE_VALUE);
        retElement.setTextContent(Long.toString(timeout.getSeconds()));
        return retElement;
    }

    protected Element processServerSideElements(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        switch (clusteringServiceConfiguration.getClientMode()) {
            case CONNECT: {
                return null;
            }
            case EXPECTING: 
            case AUTO_CREATE: 
            case AUTO_CREATE_ON_RECONNECT: {
                Map resourcePools;
                Element serverSideConfigurationElem = this.createServerSideConfigurationElement(doc, clusteringServiceConfiguration);
                ServerSideConfiguration serverSideConfiguration = clusteringServiceConfiguration.getServerConfiguration();
                String defaultServerResource = serverSideConfiguration.getDefaultServerResource();
                if (defaultServerResource != null && defaultServerResource.trim().length() != 0) {
                    Element defaultResourceElement = this.createDefaultServerResourceElement(doc, defaultServerResource);
                    serverSideConfigurationElem.appendChild(defaultResourceElement);
                }
                if ((resourcePools = serverSideConfiguration.getResourcePools()) != null) {
                    resourcePools.forEach((key, value) -> {
                        Element poolElement = this.createSharedPoolElement(doc, (String)key, (ServerSideConfiguration.Pool)value);
                        serverSideConfigurationElem.appendChild(poolElement);
                    });
                }
                return serverSideConfigurationElem;
            }
        }
        throw new AssertionError();
    }

    private Element createServerSideConfigurationElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element serverSideConfigurationElem = doc.createElement("tc:server-side-config");
        serverSideConfigurationElem.setAttribute(CLIENT_MODE_ATTRIBUTE_NAME, clusteringServiceConfiguration.getClientMode().name().toLowerCase(Locale.ROOT).replace('_', '-'));
        return serverSideConfigurationElem;
    }

    private Element createSharedPoolElement(Document doc, String poolName, ServerSideConfiguration.Pool pool) {
        Element poolElement = doc.createElement("tc:shared-pool");
        poolElement.setAttribute(NAME_ATTRIBUTE_NAME, poolName);
        String from = pool.getServerResource();
        if (from != null) {
            if (from.trim().length() == 0) {
                throw new XmlConfigurationException("Resource pool name can not be empty.");
            }
            poolElement.setAttribute(FROM_ATTRIBUTE_NAME, from);
        }
        long memoryInBytes = MemoryUnit.B.convert(pool.getSize(), MemoryUnit.B);
        poolElement.setAttribute(UNIT_ATTRIBUTE_NAME, MemoryUnit.B.toString());
        poolElement.setTextContent(Long.toString(memoryInBytes));
        return poolElement;
    }

    private Element createDefaultServerResourceElement(Document doc, String defaultServerResource) {
        Element defaultResourceElement = doc.createElement("tc:default-resource");
        defaultResourceElement.setAttribute(FROM_ATTRIBUTE_NAME, defaultServerResource);
        return defaultResourceElement;
    }

    private ServerSideConfig processServerSideConfig(Element serverSideConfigElement) {
        ServerSideConfig serverSideConfig = new ServerSideConfig();
        String autoCreateAttr = serverSideConfigElement.getAttribute(AUTO_CREATE_ATTRIBUTE_NAME);
        String clientModeAttr = serverSideConfigElement.getAttribute(CLIENT_MODE_ATTRIBUTE_NAME);
        if (clientModeAttr.isEmpty()) {
            if (!autoCreateAttr.isEmpty()) {
                serverSideConfig.clientMode = Boolean.parseBoolean(autoCreateAttr) ? ClusteringServiceConfiguration.ClientMode.AUTO_CREATE : ClusteringServiceConfiguration.ClientMode.EXPECTING;
            }
        } else if (autoCreateAttr.isEmpty()) {
            clientModeAttr = JaxbParsers.parsePropertyOrString((String)clientModeAttr);
            serverSideConfig.clientMode = ClusteringServiceConfiguration.ClientMode.valueOf(clientModeAttr.toUpperCase(Locale.ROOT).replace('-', '_'));
        } else {
            throw new XmlConfigurationException("Cannot define both 'auto-create' and 'client-mode' attributes");
        }
        NodeList serverSideNodes = serverSideConfigElement.getChildNodes();
        for (int i = 0; i < serverSideNodes.getLength(); ++i) {
            long quantity;
            Node item = serverSideNodes.item(i);
            if (1 != item.getNodeType()) continue;
            String nodeLocalName = item.getLocalName();
            if (DEFAULT_RESOURCE_ELEMENT_NAME.equals(nodeLocalName)) {
                serverSideConfig.defaultServerResource = JaxbParsers.parsePropertyOrString((String)((Element)item).getAttribute(FROM_ATTRIBUTE_NAME));
                continue;
            }
            if (!SHARED_POOL_ELEMENT_NAME.equals(nodeLocalName)) continue;
            Element sharedPoolElement = (Element)item;
            String poolName = sharedPoolElement.getAttribute(NAME_ATTRIBUTE_NAME);
            Attr fromAttr = sharedPoolElement.getAttributeNode(FROM_ATTRIBUTE_NAME);
            String fromResource = fromAttr == null ? null : fromAttr.getValue();
            Attr unitAttr = sharedPoolElement.getAttributeNode(UNIT_ATTRIBUTE_NAME);
            String unit = unitAttr == null ? "B" : unitAttr.getValue();
            MemoryUnit memoryUnit = MemoryUnit.valueOf((String)unit.toUpperCase(Locale.ENGLISH));
            String quantityValue = sharedPoolElement.getFirstChild().getNodeValue();
            try {
                quantity = JaxbParsers.parsePropertyOrPositiveInteger((String)quantityValue).longValueExact();
            }
            catch (NumberFormatException e) {
                throw new XmlConfigurationException("Magnitude of value specified for <shared-pool name=\"" + poolName + "\"> is too large");
            }
            ServerSideConfiguration.Pool poolDefinition = fromResource == null ? new ServerSideConfiguration.Pool(memoryUnit.toBytes(quantity)) : new ServerSideConfiguration.Pool(memoryUnit.toBytes(quantity), JaxbParsers.parsePropertyOrString((String)fromResource));
            if (serverSideConfig.pools.put(poolName, poolDefinition) == null) continue;
            throw new XmlConfigurationException("Duplicate definition for <shared-pool name=\"" + poolName + "\">");
        }
        return serverSideConfig;
    }

    private Duration processTimeout(Element parentElement, Node timeoutNode) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TimeTypeWithPropSubst.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            JAXBElement jaxbElement = unmarshaller.unmarshal(timeoutNode, TimeTypeWithPropSubst.class);
            TimeTypeWithPropSubst timeType = (TimeTypeWithPropSubst)jaxbElement.getValue();
            BigInteger amount = timeType.getValue();
            if (amount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new XmlConfigurationException(String.format("Value of XML configuration element <%s> in <%s> exceeds allowed value - %s", timeoutNode.getNodeName(), parentElement.getTagName(), amount));
            }
            return Duration.of(amount.longValue(), XmlModel.convertToJavaTimeUnit((TimeUnit)timeType.getUnit()));
        }
        catch (JAXBException e) {
            throw new XmlConfigurationException((Throwable)e);
        }
    }

    private Timeouts getTimeouts(Duration getTimeout, Duration putTimeout, Duration connectionTimeout) {
        TimeoutsBuilder builder = TimeoutsBuilder.timeouts();
        if (getTimeout != null) {
            builder.read(getTimeout);
        }
        if (putTimeout != null) {
            builder.write(putTimeout);
        }
        if (connectionTimeout != null) {
            builder.connection(connectionTimeout);
        }
        return builder.build();
    }

    private static final class ServerSideConfig {
        private ClusteringServiceConfiguration.ClientMode clientMode = ClusteringServiceConfiguration.ClientMode.CONNECT;
        private String defaultServerResource = null;
        private final Map<String, ServerSideConfiguration.Pool> pools = new HashMap<String, ServerSideConfiguration.Pool>();

        private ServerSideConfig() {
        }
    }
}

