/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.ClusteringServiceConfigurationBuilder;
import org.ehcache.clustered.client.config.builders.ServerSideConfigurationBuilder;
import org.ehcache.clustered.client.config.builders.TimeoutsBuilder;
import org.ehcache.clustered.client.internal.ConnectionSource;
import org.ehcache.clustered.client.internal.config.xml.ClusteringParser;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.Builder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.ParsingUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class ClusteringCacheManagerServiceConfigurationParser
extends ClusteringParser<ClusteringServiceConfiguration>
implements CacheManagerServiceConfigurationParser<ClusteringService, ClusteringServiceConfiguration> {
    public static final String CONNECTION_ELEMENT_NAME = "connection";
    public static final String CLUSTER_CONNECTION_ELEMENT_NAME = "cluster-connection";
    public static final String SERVER_SIDE_CONFIG_ELEMENT_NAME = "server-side-config";
    private static final String CLUSTER_ELEMENT_NAME = "cluster";
    private static final String CLUSTER_TIER_MANAGER_ATTRIBUTE_NAME = "cluster-tier-manager";
    private static final String SERVER_ELEMENT_NAME = "server";
    private static final String HOST_ATTRIBUTE_NAME = "host";
    private static final String PORT_ATTRIBUTE_NAME = "port";
    private static final String READ_TIMEOUT_ELEMENT_NAME = "read-timeout";
    private static final String WRITE_TIMEOUT_ELEMENT_NAME = "write-timeout";
    private static final String CONNECTION_TIMEOUT_ELEMENT_NAME = "connection-timeout";
    private static final String URL_ATTRIBUTE_NAME = "url";
    private static final String DEFAULT_RESOURCE_ELEMENT_NAME = "default-resource";
    private static final String SHARED_POOL_ELEMENT_NAME = "shared-pool";
    private static final String AUTO_CREATE_ATTRIBUTE_NAME = "auto-create";
    private static final String CLIENT_MODE_ATTRIBUTE_NAME = "client-mode";
    private static final String UNIT_ATTRIBUTE_NAME = "unit";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String FROM_ATTRIBUTE_NAME = "from";
    private static final String DEFAULT_UNIT_ATTRIBUTE_VALUE = "seconds";

    public ClusteringServiceConfiguration parse(Element fragment, ClassLoader classLoader) {
        if (CLUSTER_ELEMENT_NAME.equals(fragment.getLocalName())) {
            return this.parseServerBehavior(this.parseConnection(fragment).timeouts(this.parseTimeouts(fragment)), fragment).build();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    protected ClusteringServiceConfigurationBuilder parseConnection(Element cluster) {
        Optional<Element> connectionElement = ClusteringCacheManagerServiceConfigurationParser.childElementOf(cluster, element -> element.getNamespaceURI().equals("http://www.ehcache.org/v3/clustered") && element.getLocalName().equals(CONNECTION_ELEMENT_NAME) || element.getSchemaTypeInfo().isDerivedFrom("http://www.ehcache.org/v3/clustered", "connection-spec", 2));
        Optional<Element> clusterConnectionElement = ClusteringCacheManagerServiceConfigurationParser.childElementOf(cluster, element -> element.getNamespaceURI().equals("http://www.ehcache.org/v3/clustered") && element.getLocalName().equals(CLUSTER_CONNECTION_ELEMENT_NAME) || element.getSchemaTypeInfo().isDerivedFrom("http://www.ehcache.org/v3/clustered", "cluster-connection-spec", 2));
        if (clusterConnectionElement.isPresent()) {
            Element clusterConnection = clusterConnectionElement.get();
            String clusterTierManager = ParsingUtil.parsePropertyOrString((String)clusterConnection.getAttribute(CLUSTER_TIER_MANAGER_ATTRIBUTE_NAME));
            ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
            NodeList serverNodes = clusterConnection.getElementsByTagNameNS("http://www.ehcache.org/v3/clustered", SERVER_ELEMENT_NAME);
            for (int j = 0; j < serverNodes.getLength(); ++j) {
                InetSocketAddress address;
                Node serverNode = serverNodes.item(j);
                String host = ParsingUtil.parsePropertyOrString((String)((Element)serverNode).getAttributeNode(HOST_ATTRIBUTE_NAME).getValue().trim());
                Attr port = ((Element)serverNode).getAttributeNode(PORT_ATTRIBUTE_NAME);
                if (port == null) {
                    address = InetSocketAddress.createUnresolved(host, 0);
                } else {
                    String portString = ParsingUtil.parsePropertyOrString((String)port.getValue());
                    address = InetSocketAddress.createUnresolved(host, Integer.parseInt(portString));
                }
                serverAddresses.add(address);
            }
            return ClusteringServiceConfigurationBuilder.cluster(serverAddresses, clusterTierManager);
        }
        if (connectionElement.isPresent()) {
            Element connection = connectionElement.get();
            Attr urlAttribute = connection.getAttributeNode(URL_ATTRIBUTE_NAME);
            String urlValue = ParsingUtil.parseStringWithProperties((String)urlAttribute.getValue());
            try {
                return ClusteringServiceConfigurationBuilder.cluster(new URI(urlValue));
            }
            catch (URISyntaxException e) {
                throw new XmlConfigurationException(String.format("Value of %s attribute on XML configuration element <%s> in <%s> is not a valid URI - '%s'", urlAttribute.getName(), connection.getNodeName(), connection.getParentNode().getNodeName(), urlValue), (Throwable)e);
            }
        }
        throw new AssertionError((Object)"Validation Leak!");
    }

    protected Builder<? extends Timeouts> parseTimeouts(Element cluster) {
        NodeList childNodes = cluster.getChildNodes();
        TimeoutsBuilder timeoutsBuilder = TimeoutsBuilder.timeouts();
        block10: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (1 != item.getNodeType()) continue;
            switch (item.getLocalName()) {
                case "read-timeout": {
                    timeoutsBuilder.read(this.processTimeout((Element)item));
                    continue block10;
                }
                case "write-timeout": {
                    timeoutsBuilder.write(this.processTimeout((Element)item));
                    continue block10;
                }
                case "connection-timeout": {
                    timeoutsBuilder.connection(this.processTimeout((Element)item));
                    continue block10;
                }
            }
        }
        return timeoutsBuilder;
    }

    protected ClusteringServiceConfigurationBuilder parseServerBehavior(ClusteringServiceConfigurationBuilder builder, Element cluster) {
        Optional<Element> serverSideConfigElement = ClusteringCacheManagerServiceConfigurationParser.childElementOf(cluster, element -> element.getNamespaceURI().equals("http://www.ehcache.org/v3/clustered") && element.getLocalName().equals(SERVER_SIDE_CONFIG_ELEMENT_NAME) || element.getSchemaTypeInfo().isDerivedFrom("http://www.ehcache.org/v3/clustered", "server-side-config-spec", 2));
        if (serverSideConfigElement.isPresent()) {
            Element serverSideConfig = serverSideConfigElement.get();
            String autoCreateAttr = serverSideConfig.getAttribute(AUTO_CREATE_ATTRIBUTE_NAME);
            String clientModeAttr = serverSideConfig.getAttribute(CLIENT_MODE_ATTRIBUTE_NAME);
            if (clientModeAttr.isEmpty()) {
                if (!autoCreateAttr.isEmpty()) {
                    if (Boolean.parseBoolean(autoCreateAttr)) {
                        return builder.autoCreate(this.parseServerConfig(serverSideConfig));
                    }
                    return builder.expecting(this.parseServerConfig(serverSideConfig));
                }
                return builder;
            }
            if (autoCreateAttr.isEmpty()) {
                switch (clientModeAttr = ParsingUtil.parsePropertyOrString((String)clientModeAttr)) {
                    case "expecting": {
                        return builder.expecting(this.parseServerConfig(serverSideConfig));
                    }
                    case "auto-create": {
                        return builder.autoCreate(this.parseServerConfig(serverSideConfig));
                    }
                    case "auto-create-on-reconnect": {
                        return builder.autoCreateOnReconnect(this.parseServerConfig(serverSideConfig));
                    }
                }
                throw new AssertionError((Object)"Validation Leak!");
            }
            throw new XmlConfigurationException("Cannot define both 'auto-create' and 'client-mode' attributes");
        }
        return builder;
    }

    private UnaryOperator<ServerSideConfigurationBuilder> parseServerConfig(Element serverSideConfig) {
        Function builder = Function.identity();
        Optional<Element> defaultResourceElement = ClusteringCacheManagerServiceConfigurationParser.optionalSingleton(Element.class, serverSideConfig.getElementsByTagNameNS("http://www.ehcache.org/v3/clustered", DEFAULT_RESOURCE_ELEMENT_NAME));
        if (defaultResourceElement.isPresent()) {
            String defaultServerResource = ParsingUtil.parsePropertyOrString((String)defaultResourceElement.get().getAttribute(FROM_ATTRIBUTE_NAME));
            builder = builder.andThen(b -> b.defaultServerResource(defaultServerResource));
        }
        NodeList sharedPoolElements = serverSideConfig.getElementsByTagNameNS("http://www.ehcache.org/v3/clustered", SHARED_POOL_ELEMENT_NAME);
        for (int i = 0; i < sharedPoolElements.getLength(); ++i) {
            long quantity;
            Element pool = (Element)sharedPoolElements.item(i);
            String poolName = pool.getAttribute(NAME_ATTRIBUTE_NAME);
            Attr fromAttr = pool.getAttributeNode(FROM_ATTRIBUTE_NAME);
            String fromResource = fromAttr == null ? null : fromAttr.getValue();
            Attr unitAttr = pool.getAttributeNode(UNIT_ATTRIBUTE_NAME);
            String unit = unitAttr == null ? "B" : unitAttr.getValue();
            MemoryUnit memoryUnit = MemoryUnit.valueOf((String)unit.toUpperCase(Locale.ENGLISH));
            String quantityValue = pool.getTextContent();
            try {
                quantity = ParsingUtil.parsePropertyOrPositiveInteger((String)quantityValue).longValueExact();
            }
            catch (NumberFormatException e) {
                throw new XmlConfigurationException("Magnitude of value specified for <shared-pool name=\"" + poolName + "\"> is too large");
            }
            builder = fromResource == null ? builder.andThen(b -> b.resourcePool(poolName, quantity, memoryUnit)) : builder.andThen(b -> b.resourcePool(poolName, quantity, memoryUnit, ParsingUtil.parsePropertyOrString((String)fromResource)));
        }
        return builder::apply;
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    private Element createRootUrlElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element rootElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:cluster");
        Element urlElement = this.createUrlElement(doc, clusteringServiceConfiguration);
        rootElement.appendChild(urlElement);
        return rootElement;
    }

    protected Element createUrlElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element urlElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:connection");
        urlElement.setAttribute(URL_ATTRIBUTE_NAME, clusteringServiceConfiguration.getClusterUri().toString());
        return urlElement;
    }

    private Element createServerElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        if (!(clusteringServiceConfiguration.getConnectionSource() instanceof ConnectionSource.ServerList)) {
            throw new IllegalArgumentException("When connection URL is null, source of connection MUST be of type ConnectionSource.ServerList.class");
        }
        ConnectionSource.ServerList servers = (ConnectionSource.ServerList)clusteringServiceConfiguration.getConnectionSource();
        Element rootElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:cluster");
        Element connElement = this.createConnectionElementWrapper(doc, clusteringServiceConfiguration);
        servers.getServers().forEach(server -> {
            Element serverElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:server");
            serverElement.setAttribute(HOST_ATTRIBUTE_NAME, server.getHostName());
            if (server.getPort() > 0) {
                serverElement.setAttribute(PORT_ATTRIBUTE_NAME, Integer.toString(server.getPort()));
            }
            connElement.appendChild(serverElement);
        });
        rootElement.appendChild(connElement);
        return rootElement;
    }

    protected Element createConnectionElementWrapper(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element connElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:cluster-connection");
        connElement.setAttribute(CLUSTER_TIER_MANAGER_ATTRIBUTE_NAME, clusteringServiceConfiguration.getConnectionSource().getClusterTierManager());
        return connElement;
    }

    public Element safeUnparse(Document target, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element rootElement = clusteringServiceConfiguration.getConnectionSource() instanceof ConnectionSource.ClusterUri ? this.createRootUrlElement(target, clusteringServiceConfiguration) : this.createServerElement(target, clusteringServiceConfiguration);
        this.processTimeUnits(target, rootElement, clusteringServiceConfiguration);
        Element serverSideConfigurationElem = this.processServerSideElements(target, clusteringServiceConfiguration);
        if (serverSideConfigurationElem != null) {
            rootElement.appendChild(serverSideConfigurationElem);
        }
        return rootElement;
    }

    private void processTimeUnits(Document doc, Element parent, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        if (clusteringServiceConfiguration.getTimeouts() != null) {
            Timeouts timeouts = clusteringServiceConfiguration.getTimeouts();
            Element readTimeoutElem = this.createTimeoutElement(doc, READ_TIMEOUT_ELEMENT_NAME, timeouts.getReadOperationTimeout());
            Element writeTimeoutElem = this.createTimeoutElement(doc, WRITE_TIMEOUT_ELEMENT_NAME, timeouts.getWriteOperationTimeout());
            Element connectionTimeoutElem = this.createTimeoutElement(doc, CONNECTION_TIMEOUT_ELEMENT_NAME, timeouts.getConnectionTimeout());
            parent.appendChild(readTimeoutElem);
            parent.appendChild(writeTimeoutElem);
            parent.appendChild(connectionTimeoutElem);
        }
    }

    private Element createTimeoutElement(Document doc, String timeoutName, Duration timeout) {
        Element retElement = READ_TIMEOUT_ELEMENT_NAME.equals(timeoutName) ? doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:read-timeout") : (WRITE_TIMEOUT_ELEMENT_NAME.equals(timeoutName) ? doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:write-timeout") : doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:connection-timeout"));
        retElement.setAttribute(UNIT_ATTRIBUTE_NAME, DEFAULT_UNIT_ATTRIBUTE_VALUE);
        retElement.setTextContent(Long.toString(timeout.getSeconds()));
        return retElement;
    }

    protected Element processServerSideElements(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        switch (clusteringServiceConfiguration.getClientMode()) {
            case CONNECT: {
                return null;
            }
            case EXPECTING: 
            case AUTO_CREATE: 
            case AUTO_CREATE_ON_RECONNECT: {
                Map resourcePools;
                Element serverSideConfigurationElem = this.createServerSideConfigurationElement(doc, clusteringServiceConfiguration);
                ServerSideConfiguration serverSideConfiguration = clusteringServiceConfiguration.getServerConfiguration();
                String defaultServerResource = serverSideConfiguration.getDefaultServerResource();
                if (defaultServerResource != null && defaultServerResource.trim().length() != 0) {
                    Element defaultResourceElement = this.createDefaultServerResourceElement(doc, defaultServerResource);
                    serverSideConfigurationElem.appendChild(defaultResourceElement);
                }
                if ((resourcePools = serverSideConfiguration.getResourcePools()) != null) {
                    resourcePools.forEach((key, value) -> {
                        Element poolElement = this.createSharedPoolElement(doc, (String)key, (ServerSideConfiguration.Pool)value);
                        serverSideConfigurationElem.appendChild(poolElement);
                    });
                }
                return serverSideConfigurationElem;
            }
        }
        throw new AssertionError();
    }

    private Element createServerSideConfigurationElement(Document doc, ClusteringServiceConfiguration clusteringServiceConfiguration) {
        Element serverSideConfigurationElem = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:server-side-config");
        serverSideConfigurationElem.setAttribute(CLIENT_MODE_ATTRIBUTE_NAME, clusteringServiceConfiguration.getClientMode().name().toLowerCase(Locale.ROOT).replace('_', '-'));
        return serverSideConfigurationElem;
    }

    private Element createSharedPoolElement(Document doc, String poolName, ServerSideConfiguration.Pool pool) {
        Element poolElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:shared-pool");
        poolElement.setAttribute(NAME_ATTRIBUTE_NAME, poolName);
        String from = pool.getServerResource();
        if (from != null) {
            if (from.trim().length() == 0) {
                throw new XmlConfigurationException("Resource pool name can not be empty.");
            }
            poolElement.setAttribute(FROM_ATTRIBUTE_NAME, from);
        }
        long memoryInBytes = MemoryUnit.B.convert(pool.getSize(), MemoryUnit.B);
        poolElement.setAttribute(UNIT_ATTRIBUTE_NAME, MemoryUnit.B.toString());
        poolElement.setTextContent(Long.toString(memoryInBytes));
        return poolElement;
    }

    private Element createDefaultServerResourceElement(Document doc, String defaultServerResource) {
        Element defaultResourceElement = doc.createElementNS("http://www.ehcache.org/v3/clustered", "tc:default-resource");
        defaultResourceElement.setAttribute(FROM_ATTRIBUTE_NAME, defaultServerResource);
        return defaultResourceElement;
    }

    private Duration processTimeout(Element timeoutNode) {
        BigInteger amount = ParsingUtil.parsePropertyOrPositiveInteger((String)timeoutNode.getTextContent());
        if (amount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new XmlConfigurationException(String.format("Value of XML configuration element <%s> in <%s> exceeds allowed value - %s", timeoutNode.getNodeName(), timeoutNode.getParentNode().getNodeName(), amount));
        }
        Attr unitAttribute = timeoutNode.getAttributeNode(UNIT_ATTRIBUTE_NAME);
        if (unitAttribute == null) {
            return Duration.of(amount.longValue(), ChronoUnit.SECONDS);
        }
        return Duration.of(amount.longValue(), ChronoUnit.valueOf(unitAttribute.getValue().toUpperCase(Locale.ROOT)));
    }
}

